/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.hyperlink.object;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.editorsfactory.IPageIconsRegistry;
import org.eclipse.papyrus.infra.core.editorsfactory.IPageIconsRegistryExtended;
import org.eclipse.papyrus.infra.core.editorsfactory.PageIconsRegistry;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageMngr;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.utils.EditorUtils;
import org.eclipse.papyrus.infra.hyperlink.Activator;
import org.eclipse.papyrus.infra.hyperlink.internal.IEditorLabelProvider;
import org.eclipse.papyrus.infra.hyperlink.object.HyperLinkObject;
import org.eclipse.papyrus.infra.hyperlink.ui.EditorHyperLinkEditorShell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HyperLinkEditor
extends HyperLinkObject
implements IEditorLabelProvider {
    private static IPageIconsRegistry editorRegistry;

    protected IPageIconsRegistryExtended getEditorRegistry() {
        if (editorRegistry == null) {
            editorRegistry = this.createEditorRegistry();
        }
        if (!(editorRegistry instanceof IPageIconsRegistryExtended)) {
            throw new RuntimeException("The editor registry do not implement IPageIconsRegistryExtended");
        }
        return (IPageIconsRegistryExtended)editorRegistry;
    }

    protected IPageIconsRegistry createEditorRegistry() {
        try {
            return (IPageIconsRegistry)EditorUtils.getServiceRegistry().getService(IPageIconsRegistry.class);
        }
        catch (ServiceException e) {
            return new PageIconsRegistry();
        }
    }

    @Override
    public void executeSelectPressed() {
        IPageMngr pageMngr = EditorUtils.getIPageMngr();
        try {
            pageMngr.openPage(this.getObject());
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
        }
    }

    @Override
    public void executeEditMousePressed(List<HyperLinkObject> list, EObject amodel) {
        IPageIconsRegistry editorRegistry = null;
        IMultiDiagramEditor papyrusEditor = EditorUtils.getMultiDiagramEditor();
        try {
            editorRegistry = (IPageIconsRegistry)papyrusEditor.getServicesRegistry().getService(IPageIconsRegistry.class);
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
        }
        EditorHyperLinkEditorShell editor = new EditorHyperLinkEditorShell(editorRegistry, amodel);
        editor.setHyperLinkEditor(this);
        editor.open();
        if (editor.getHyperLinkEditor() != null) {
            int index = list.indexOf(this);
            list.remove(this);
            list.add(index, editor.getHyperLinkEditor());
        }
    }
}

