/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.hyperlink.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.papyrus.infra.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.editorsfactory.IPageIconsRegistry;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.utils.EditorUtils;
import org.eclipse.papyrus.infra.hyperlink.helper.AbstractHyperLinkHelper;
import org.eclipse.papyrus.infra.hyperlink.messages.Messages;
import org.eclipse.papyrus.infra.hyperlink.object.HyperLinkObject;
import org.eclipse.papyrus.infra.hyperlink.ui.AbstractHyperLinkTab;
import org.eclipse.papyrus.infra.hyperlink.util.HyperLinkContentProvider;
import org.eclipse.papyrus.infra.hyperlink.util.HyperLinkLabelProvider;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.plugin.AbstractUIPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultHyperLinkTab
extends AbstractHyperLinkTab {
    protected TableViewer availableHyperLinkViewer;
    protected Button defaultHRight;
    protected Button defaultHleft;
    protected Button defaultHup;
    protected Button defaultHdown;
    protected TableViewer defaultHyperLinkViewer;
    protected List<HyperLinkObject> defaultHyperLinkObject = new ArrayList<HyperLinkObject>();
    protected List<HyperLinkObject> availableHyperLinkObject = new ArrayList<HyperLinkObject>();
    protected Composite defaultHyperlinkComposite;

    public DefaultHyperLinkTab() {
    }

    public DefaultHyperLinkTab(String tabId, AbstractHyperLinkHelper helper) {
        super(tabId, helper);
    }

    public List<HyperLinkObject> getDefaultHyperLinkObject() {
        return this.defaultHyperLinkObject;
    }

    @Override
    public void init(CTabFolder cTabFolder, List<HyperLinkObject> hyperlinkObjects, EObject element) {
        super.init(cTabFolder, hyperlinkObjects, element);
        CTabItem tbtmDefaultsHyperlinks = new CTabItem(cTabFolder, 0);
        tbtmDefaultsHyperlinks.setText(Messages.DefaultHyperLinkTab_DefaultHyperlinks);
        this.defaultHyperlinkComposite = new Composite((Composite)cTabFolder, 0);
        this.defaultHyperlinkComposite.setBackground(Display.getCurrent().getSystemColor(1));
        tbtmDefaultsHyperlinks.setControl((Control)this.defaultHyperlinkComposite);
        Label lblHyperlinks = new Label(this.defaultHyperlinkComposite, 0);
        lblHyperlinks.setBackground(Display.getCurrent().getSystemColor(1));
        lblHyperlinks.setForeground(Display.getCurrent().getSystemColor(2));
        lblHyperlinks.setBounds(23, 10, 71, 13);
        lblHyperlinks.setText(Messages.DefaultHyperLinkTab_HyperLinks);
        Label lblDefaultHyperlinksby = new Label(this.defaultHyperlinkComposite, 0);
        lblDefaultHyperlinksby.setBackground(Display.getCurrent().getSystemColor(1));
        lblDefaultHyperlinksby.setBounds(366, 10, 186, 13);
        lblDefaultHyperlinksby.setText(Messages.DefaultHyperLinkTab_DefaultHyperLinks);
        Table availableHyperLink = new Table(this.defaultHyperlinkComposite, 67584);
        availableHyperLink.setBounds(30, 29, 250, 177);
        this.defaultHRight = new Button(this.defaultHyperlinkComposite, 0);
        this.defaultHRight.setBounds(availableHyperLink.getBounds().x + availableHyperLink.getBounds().width + 20, availableHyperLink.getBounds().y + availableHyperLink.getBounds().height / 2 - 30, 30, 23);
        this.defaultHRight.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                if (DefaultHyperLinkTab.this.availableHyperLinkViewer.getSelection() != null && DefaultHyperLinkTab.this.availableHyperLinkViewer.getSelection() instanceof IStructuredSelection) {
                    HyperLinkObject hyperlinkObjectToMove = (HyperLinkObject)((IStructuredSelection)DefaultHyperLinkTab.this.availableHyperLinkViewer.getSelection()).getFirstElement();
                    hyperlinkObjectToMove.setIsDefault(true);
                    DefaultHyperLinkTab.this.availableHyperLinkObject.remove(hyperlinkObjectToMove);
                    DefaultHyperLinkTab.this.defaultHyperLinkObject.add(hyperlinkObjectToMove);
                    DefaultHyperLinkTab.this.refresh();
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.defaultHleft = new Button(this.defaultHyperlinkComposite, 0);
        this.defaultHleft.setBounds(availableHyperLink.getBounds().x + availableHyperLink.getBounds().width + 20, availableHyperLink.getBounds().y + availableHyperLink.getBounds().height / 2, 30, 23);
        this.defaultHleft.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                if (DefaultHyperLinkTab.this.defaultHyperLinkViewer.getSelection() != null && DefaultHyperLinkTab.this.defaultHyperLinkViewer.getSelection() instanceof IStructuredSelection) {
                    HyperLinkObject hyperlinkObjectToMove = (HyperLinkObject)((IStructuredSelection)DefaultHyperLinkTab.this.defaultHyperLinkViewer.getSelection()).getFirstElement();
                    hyperlinkObjectToMove.setIsDefault(false);
                    DefaultHyperLinkTab.this.defaultHyperLinkObject.remove(hyperlinkObjectToMove);
                    DefaultHyperLinkTab.this.availableHyperLinkObject.add(hyperlinkObjectToMove);
                    DefaultHyperLinkTab.this.refresh();
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        Table defaultHyperLink = new Table(this.defaultHyperlinkComposite, 67584);
        defaultHyperLink.setBounds(this.defaultHRight.getBounds().x + this.defaultHRight.getBounds().width + 20, 29, 250, 177);
        this.defaultHup = new Button(this.defaultHyperlinkComposite, 0);
        this.defaultHup.setBounds(defaultHyperLink.getBounds().x + defaultHyperLink.getBounds().width + 20, defaultHyperLink.getBounds().y + defaultHyperLink.getBounds().height / 2 - 30, 34, 23);
        this.defaultHup.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                HyperLinkObject hyperlinkObjectToMove;
                int index;
                if (DefaultHyperLinkTab.this.defaultHyperLinkViewer.getSelection() != null && DefaultHyperLinkTab.this.defaultHyperLinkViewer.getSelection() instanceof IStructuredSelection && (index = DefaultHyperLinkTab.this.defaultHyperLinkObject.indexOf(hyperlinkObjectToMove = (HyperLinkObject)((IStructuredSelection)DefaultHyperLinkTab.this.defaultHyperLinkViewer.getSelection()).getFirstElement())) > 0) {
                    DefaultHyperLinkTab.this.defaultHyperLinkObject.remove(hyperlinkObjectToMove);
                    DefaultHyperLinkTab.this.defaultHyperLinkObject.add(index - 1, hyperlinkObjectToMove);
                    DefaultHyperLinkTab.this.refresh();
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.defaultHdown = new Button(this.defaultHyperlinkComposite, 0);
        this.defaultHdown.setBounds(defaultHyperLink.getBounds().x + defaultHyperLink.getBounds().width + 20, defaultHyperLink.getBounds().y + defaultHyperLink.getBounds().height / 2, 34, 23);
        this.defaultHdown.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                HyperLinkObject hyperlinkObjectToMove;
                int index;
                if (DefaultHyperLinkTab.this.defaultHyperLinkViewer.getSelection() != null && DefaultHyperLinkTab.this.defaultHyperLinkViewer.getSelection() instanceof IStructuredSelection && (index = DefaultHyperLinkTab.this.defaultHyperLinkObject.indexOf(hyperlinkObjectToMove = (HyperLinkObject)((IStructuredSelection)DefaultHyperLinkTab.this.defaultHyperLinkViewer.getSelection()).getFirstElement())) < DefaultHyperLinkTab.this.defaultHyperLinkObject.size() - 1) {
                    DefaultHyperLinkTab.this.defaultHyperLinkObject.remove(hyperlinkObjectToMove);
                    DefaultHyperLinkTab.this.defaultHyperLinkObject.add(index + 1, hyperlinkObjectToMove);
                    DefaultHyperLinkTab.this.refresh();
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.defaultHdown.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.uml.diagram.common", (String)"/icons/obj16/ArrowDown_16x16.gif").createImage());
        this.defaultHup.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.uml.diagram.common", (String)"/icons/obj16/ArrowUp_16x16.gif").createImage());
        this.defaultHleft.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.uml.diagram.common", (String)"/icons/obj16/ArrowLeft_16x16.gif").createImage());
        this.defaultHRight.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.uml.diagram.common", (String)"/icons/obj16/ArrowRight_16x16.gif").createImage());
        IPageIconsRegistry editorRegistry = null;
        IMultiDiagramEditor papyrusEditor = EditorUtils.getMultiDiagramEditor();
        try {
            editorRegistry = (IPageIconsRegistry)papyrusEditor.getServicesRegistry().getService(IPageIconsRegistry.class);
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        this.availableHyperLinkViewer = new TableViewer(availableHyperLink);
        this.availableHyperLinkViewer.setLabelProvider((IBaseLabelProvider)new HyperLinkLabelProvider(editorRegistry));
        this.availableHyperLinkViewer.setContentProvider((IContentProvider)new HyperLinkContentProvider());
        this.availableHyperLinkViewer.setInput(hyperlinkObjects);
        this.defaultHyperLinkViewer = new TableViewer(defaultHyperLink);
        this.defaultHyperLinkViewer.setLabelProvider((IBaseLabelProvider)new HyperLinkLabelProvider(editorRegistry));
        this.defaultHyperLinkViewer.setContentProvider((IContentProvider)new HyperLinkContentProvider());
    }

    protected Composite getMainComposite() {
        return this.defaultHyperlinkComposite;
    }

    protected void refresh() {
        this.availableHyperLinkViewer.setInput(this.availableHyperLinkObject);
        this.defaultHyperLinkViewer.setInput(this.defaultHyperLinkObject);
    }

    @Override
    public void setInput(List<HyperLinkObject> hyperLinkObjectList) {
        this.defaultHyperLinkObject.clear();
        this.availableHyperLinkObject.clear();
        for (HyperLinkObject hyperlinkObject : hyperLinkObjectList) {
            if (hyperlinkObject.getIsDefault()) {
                this.defaultHyperLinkObject.add(hyperlinkObject);
                continue;
            }
            this.availableHyperLinkObject.add(hyperlinkObject);
        }
        this.refresh();
    }
}

