/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.hyperlink.ui;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.papyrus.infra.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.editorsfactory.IPageIconsRegistry;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.utils.EditorUtils;
import org.eclipse.papyrus.infra.hyperlink.Activator;
import org.eclipse.papyrus.infra.hyperlink.helper.AbstractHyperLinkHelper;
import org.eclipse.papyrus.infra.hyperlink.messages.Messages;
import org.eclipse.papyrus.infra.hyperlink.object.HyperLinkObject;
import org.eclipse.papyrus.infra.hyperlink.ui.AbstractHyperLinkTab;
import org.eclipse.papyrus.infra.hyperlink.util.HyperLinkContentProvider;
import org.eclipse.papyrus.infra.hyperlink.util.HyperLinkLabelProvider;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.plugin.AbstractUIPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HyperLinkTab
extends AbstractHyperLinkTab {
    protected CTabItem hyperlinksTab;
    protected Table hyperLinkListTable;
    protected Button newHyperLinkbutton;
    protected Button modifyHyperLinkButton;
    protected Button removeHyperLinkButton;
    protected Button upHyperLinkButton;
    protected Button downHyperLinkButton;
    protected TableViewer tableViewer;
    private HyperLinkContentProvider contentProvider;

    public HyperLinkTab() {
    }

    public HyperLinkTab(String tabId, AbstractHyperLinkHelper helper) {
        super(tabId, helper);
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    @Override
    public List<HyperLinkObject> getHyperlinkObjects() {
        return this.hyperlinkObjects;
    }

    public void setHyperlinkObjects(List<HyperLinkObject> hyperlinkObjects) {
        this.hyperlinkObjects = hyperlinkObjects;
    }

    @Override
    public void init(CTabFolder cTabFolder, List<HyperLinkObject> hyperlinkObjects, EObject element) {
        super.init(cTabFolder, hyperlinkObjects, element);
        this.contentProvider = new HyperLinkContentProvider();
        CTabItem cTabItem2 = new CTabItem(cTabFolder, 0);
        cTabItem2.setText(String.valueOf(this.hyperLinkHelper.getNameofManagedHyperLink()) + Messages.HyperLinkTab_hyperLinks);
        Composite diagramComposite = new Composite((Composite)cTabFolder, 0);
        cTabItem2.setControl((Control)diagramComposite);
        GridData gridData4 = new GridData();
        gridData4.horizontalAlignment = 4;
        gridData4.verticalAlignment = 2;
        GridData gridData3 = new GridData();
        gridData3.horizontalAlignment = 4;
        gridData3.verticalAlignment = 2;
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 4;
        gridData2.verticalAlignment = 2;
        GridData gridData1 = new GridData();
        gridData1.verticalAlignment = 4;
        gridData1.grabExcessHorizontalSpace = true;
        gridData1.grabExcessVerticalSpace = true;
        gridData1.verticalSpan = 6;
        gridData1.horizontalAlignment = 4;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = false;
        diagramComposite.setBackground(Display.getCurrent().getSystemColor(1));
        diagramComposite.setLayout((Layout)gridLayout);
        CLabel listLabel = new CLabel(diagramComposite, 32);
        listLabel.setText(String.valueOf(Messages.HyperLinkTab_Listof) + this.hyperLinkHelper.getNameofManagedHyperLink() + Messages.HyperLinkTab_Hyperlink);
        listLabel.setEnabled(false);
        listLabel.setBackground(Display.getCurrent().getSystemColor(1));
        new Label(diagramComposite, 0);
        this.hyperLinkListTable = new Table(diagramComposite, 2050);
        this.tableViewer = new TableViewer(this.hyperLinkListTable);
        this.newHyperLinkbutton = new Button(diagramComposite, 0);
        this.newHyperLinkbutton.setText("");
        this.newHyperLinkbutton.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.uml.diagram.common", (String)"/icons/obj16/Add_16x16.gif").createImage());
        this.newHyperLinkbutton.setLayoutData((Object)gridData4);
        this.hyperLinkListTable.setHeaderVisible(false);
        this.hyperLinkListTable.setToolTipText(String.valueOf(Messages.HyperLinkTab_SetOf) + this.hyperLinkHelper.getNameofManagedHyperLink() + Messages.HyperLinkTab_Hyperlinks);
        this.hyperLinkListTable.setLayoutData((Object)gridData1);
        this.hyperLinkListTable.setLinesVisible(false);
        this.modifyHyperLinkButton = new Button(diagramComposite, 0);
        this.modifyHyperLinkButton.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.uml.diagram.common", (String)"/icons/obj16/Modify.gif").createImage());
        this.removeHyperLinkButton = new Button(diagramComposite, 0);
        this.removeHyperLinkButton.setText("");
        this.removeHyperLinkButton.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.uml.diagram.common", (String)"/icons/obj16/Delete_16x16.gif").createImage());
        this.upHyperLinkButton = new Button(diagramComposite, 0);
        this.upHyperLinkButton.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.uml.diagram.common", (String)"/icons/obj16/ArrowUp_16x16.gif").createImage());
        this.upHyperLinkButton.setLayoutData((Object)gridData2);
        this.downHyperLinkButton = new Button(diagramComposite, 0);
        this.downHyperLinkButton.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.uml.diagram.common", (String)"/icons/obj16/ArrowDown_16x16.gif").createImage());
        this.downHyperLinkButton.setLayoutData((Object)gridData3);
        this.addListeners();
        this.tableViewer.setContentProvider((IContentProvider)this.contentProvider);
        IPageIconsRegistry editorRegistry = null;
        IMultiDiagramEditor papyrusEditor = EditorUtils.getMultiDiagramEditor();
        try {
            editorRegistry = (IPageIconsRegistry)papyrusEditor.getServicesRegistry().getService(IPageIconsRegistry.class);
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
        }
        this.hyperlinkObjects = this.hyperLinkHelper.getFilteredObject(hyperlinkObjects);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new HyperLinkLabelProvider(editorRegistry));
        this.getTableViewer().setInput((Object)this.hyperlinkObjects);
    }

    protected void addListeners() {
        this.getRemoveHyperLinkButton().addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                if (HyperLinkTab.this.getTableViewer().getTable().getSelection().length != 0) {
                    for (Object object : (IStructuredSelection)HyperLinkTab.this.getTableViewer().getSelection()) {
                        HyperLinkTab.this.getHyperlinkObjects().remove(object);
                        HyperLinkTab.this.getTableViewer().setInput(HyperLinkTab.this.getHyperlinkObjects());
                    }
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.getUpHyperLinkButton().addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                if (HyperLinkTab.this.getTableViewer().getTable().getSelection().length != 0) {
                    Object elt = ((IStructuredSelection)HyperLinkTab.this.getTableViewer().getSelection()).getFirstElement();
                    if (HyperLinkTab.this.getHyperlinkObjects().indexOf(elt) == 0) {
                        return;
                    }
                    for (HyperLinkObject currentHyperLinkDoc : (IStructuredSelection)HyperLinkTab.this.getTableViewer().getSelection()) {
                        int index = HyperLinkTab.this.getHyperlinkObjects().indexOf(currentHyperLinkDoc);
                        HyperLinkTab.this.getHyperlinkObjects().remove(currentHyperLinkDoc);
                        HyperLinkTab.this.getHyperlinkObjects().add(index - 1, currentHyperLinkDoc);
                        HyperLinkTab.this.getTableViewer().setInput(HyperLinkTab.this.getHyperlinkObjects());
                    }
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.getDownHyperLinkButton().addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                if (HyperLinkTab.this.getTableViewer().getTable().getSelection().length != 0) {
                    Object[] block = ((IStructuredSelection)HyperLinkTab.this.getTableViewer().getSelection()).toArray();
                    if (HyperLinkTab.this.getHyperlinkObjects().indexOf(block[block.length - 1]) == HyperLinkTab.this.getHyperlinkObjects().size() - 1) {
                        return;
                    }
                    int i = block.length - 1;
                    while (i >= 0) {
                        HyperLinkObject currentobject = (HyperLinkObject)block[i];
                        int index = HyperLinkTab.this.getHyperlinkObjects().indexOf(currentobject);
                        HyperLinkTab.this.getHyperlinkObjects().remove(currentobject);
                        HyperLinkTab.this.getHyperlinkObjects().add(index + 1, currentobject);
                        HyperLinkTab.this.getTableViewer().setInput(HyperLinkTab.this.getHyperlinkObjects());
                        --i;
                    }
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.getNewHyperLinkbutton().addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                HyperLinkTab.this.hyperLinkHelper.executeNewMousePressed(HyperLinkTab.this.getHyperlinkObjects(), null);
                HyperLinkTab.this.setInput(HyperLinkTab.this.getHyperlinkObjects());
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.getModifyHyperLinkButton().addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                if (HyperLinkTab.this.getTableViewer().getTable().getSelection().length != 0) {
                    HyperLinkObject hyperLinkObject = (HyperLinkObject)((IStructuredSelection)HyperLinkTab.this.getTableViewer().getSelection()).getFirstElement();
                    HyperLinkTab.this.hyperLinkHelper.executeEditMousePressed(HyperLinkTab.this.getHyperlinkObjects(), hyperLinkObject, HyperLinkTab.this.element);
                    HyperLinkTab.this.setInput(HyperLinkTab.this.getHyperlinkObjects());
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
    }

    private Button getNewHyperLinkbutton() {
        return this.newHyperLinkbutton;
    }

    private Button getModifyHyperLinkButton() {
        return this.modifyHyperLinkButton;
    }

    private Button getRemoveHyperLinkButton() {
        return this.removeHyperLinkButton;
    }

    private Button getUpHyperLinkButton() {
        return this.upHyperLinkButton;
    }

    private Button getDownHyperLinkButton() {
        return this.downHyperLinkButton;
    }

    @Override
    public void setInput(List<HyperLinkObject> hyperlinkObjects) {
        this.hyperlinkObjects = this.hyperLinkHelper.getFilteredObject(hyperlinkObjects);
        this.getTableViewer().setInput((Object)this.hyperlinkObjects);
    }
}

