/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.onefile.model.impl;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.papyrus.infra.onefile.model.IPapyrusFile;
import org.eclipse.papyrus.infra.onefile.model.ISubResourceFile;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class SubResourceFile
implements ISubResourceFile {
    private IPapyrusFile parent;
    private final IFile subResource;

    public SubResourceFile(IPapyrusFile papy, IFile r) {
        this.parent = papy;
        this.subResource = r;
    }

    public IProject getProject() {
        return this.subResource.getProject();
    }

    public String toString() {
        String fileExtension = this.subResource.getFileExtension();
        return fileExtension != null ? fileExtension : this.subResource.getName();
    }

    public IFile getFile() {
        return this.subResource;
    }

    public Image getImage() {
        Image image = JFaceResources.getImage((String)this.getFile().getFileExtension());
        if (image == null) {
            ImageDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(this.getFile().getName());
            JFaceResources.getImageRegistry().put(this.getFile().getFileExtension(), desc);
        }
        return JFaceResources.getImage((String)this.getFile().getFileExtension());
    }

    public String getText() {
        return this.toString();
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }
}

