/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.onefile.providers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.papyrus.infra.onefile.model.IPapyrusFile;
import org.eclipse.papyrus.infra.onefile.utils.OneFileUtils;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.CopyResourceAction;
import org.eclipse.ui.actions.DeleteResourceAction;
import org.eclipse.ui.actions.MoveResourceAction;
import org.eclipse.ui.actions.RefreshAction;
import org.eclipse.ui.actions.RenameResourceAction;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;

public class PapyrusModelActionProvider
extends CommonActionProvider {
    private boolean fInViewPart = false;
    private ICommonViewerWorkbenchSite workbenchSite;
    private Action openAction;
    private Action deleteAction;
    private Action copyAction;
    private Action renameAction;
    private Action refreshAction;
    private Action moveAction;

    protected boolean filterAction(IAction action) {
        return super.filterAction(action);
    }

    public void fillActionBars(IActionBars actionBars) {
        if (this.fInViewPart) {
            actionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", (IAction)this.openAction);
            actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.deleteAction);
            actionBars.setGlobalActionHandler(ActionFactory.RENAME.getId(), (IAction)this.renameAction);
            actionBars.setGlobalActionHandler(ActionFactory.MOVE.getId(), (IAction)this.moveAction);
            actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyAction);
            actionBars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)this.refreshAction);
        }
        super.fillActionBars(actionBars);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        this.appendToGroup(menu, (IAction)this.openAction, "group.open");
        this.appendToGroup(menu, (IAction)this.deleteAction, "group.edit");
        this.appendToGroup(menu, (IAction)this.moveAction, "group.edit");
        this.appendToGroup(menu, (IAction)this.copyAction, "group.edit");
        this.appendToGroup(menu, (IAction)this.renameAction, "group.edit");
        this.appendToGroup(menu, (IAction)this.refreshAction, "group.edit");
    }

    private void appendToGroup(IMenuManager menu, IAction action, String id) {
        if (action != null && action.isEnabled()) {
            menu.appendToGroup(id, action);
        }
    }

    public void init(ICommonActionExtensionSite site) {
        if (site.getViewSite() instanceof ICommonViewerWorkbenchSite) {
            this.workbenchSite = (ICommonViewerWorkbenchSite)site.getViewSite();
        }
        if (this.workbenchSite != null) {
            if (this.workbenchSite.getPart() != null && this.workbenchSite.getPart() instanceof IViewPart) {
                this.fInViewPart = true;
            }
            this.makeActions();
        }
    }

    private void makeActions() {
        IWorkbenchPartSite provider = this.workbenchSite.getSite();
        final ActionHelper helper = new ActionHelper();
        this.openAction = new Action(){

            public void run() {
                if (this.getIFile() != null) {
                    try {
                        IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)this.getIFile(), (boolean)true);
                    }
                    catch (WorkbenchException workbenchException) {
                        // empty catch block
                    }
                }
            }

            public IFile getIFile() {
                return helper.getIFile(PapyrusModelActionProvider.this.getContext());
            }

            public boolean isEnabled() {
                return this.getIFile() != null;
            }

            public String getText() {
                return IDEWorkbenchMessages.OpenFileAction_text;
            }
        };
        this.deleteAction = new DeleteResourceAction((IShellProvider)provider){

            public boolean isEnabled() {
                return this.getSelectedResources() != null && this.getSelectedResources().size() > 0 && OneFileUtils.isDi((IResource)this.getSelectedResources().get(0));
            }

            public IStructuredSelection getStructuredSelection() {
                return helper.getOneStructuredSelection(PapyrusModelActionProvider.this.getContext());
            }

            protected List getSelectedResources() {
                return helper.getOneSelectedResources(PapyrusModelActionProvider.this.getContext());
            }
        };
        this.moveAction = new MoveResourceAction((IShellProvider)provider){

            public IStructuredSelection getStructuredSelection() {
                return helper.getStructuredSelection(PapyrusModelActionProvider.this.getContext());
            }

            protected List getSelectedResources() {
                return helper.getSelectedResources(PapyrusModelActionProvider.this.getContext());
            }
        };
        this.copyAction = new CopyResourceAction((IShellProvider)provider){

            public IStructuredSelection getStructuredSelection() {
                return helper.getStructuredSelection(PapyrusModelActionProvider.this.getContext());
            }

            protected List getSelectedResources() {
                return helper.getSelectedResources(PapyrusModelActionProvider.this.getContext());
            }
        };
        this.renameAction = new RenameResourceAction((IShellProvider)provider){

            public IStructuredSelection getStructuredSelection() {
                IStructuredSelection selec = helper.getOneStructuredSelection(PapyrusModelActionProvider.this.getContext());
                return selec != null ? selec : super.getStructuredSelection();
            }

            protected List getSelectedResources() {
                return helper.getOneSelectedResources(PapyrusModelActionProvider.this.getContext());
            }
        };
        this.refreshAction = new RefreshAction((IShellProvider)provider){

            public void run() {
                super.run();
            }
        };
        this.makeAction(this.openAction, "org.eclipse.ui.navigator.Open", "IMG_TOOL_COPY", "IMG_TOOL_COPY_DISABLED");
        this.makeAction(this.deleteAction, "org.eclipse.ui.edit.delete", "IMG_TOOL_DELETE", "IMG_TOOL_DELETE_DISABLED");
        this.makeAction(this.moveAction, ActionFactory.MOVE.getId(), null, null);
        this.makeAction(this.copyAction, "org.eclipse.ui.edit.cut", "IMG_TOOL_CUT", "IMG_TOOL_CUT_DISABLED");
        this.makeAction(this.copyAction, "org.eclipse.ui.edit.copy", "IMG_TOOL_COPY", "IMG_TOOL_COPY_DISABLED");
        this.makeAction(this.refreshAction, ActionFactory.REFRESH.getCommandId(), null, null);
    }

    protected void makeAction(Action action, String id, String imgTool, String imgToolDisabled) {
        if (action != null) {
            ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
            if (id != null) {
                action.setId(id);
                action.setActionDefinitionId(id);
            }
            if (imgTool != null) {
                action.setImageDescriptor(images.getImageDescriptor(imgTool));
            }
            if (imgToolDisabled != null) {
                action.setDisabledImageDescriptor(images.getImageDescriptor(imgToolDisabled));
            }
        }
    }

    public static class ActionHelper {
        public IStructuredSelection getStructuredSelection(ActionContext context) {
            return new StructuredSelection(this.getSelectedResources(context));
        }

        public List getOneSelectedResources(ActionContext context) {
            List selectedResources = this.getSelectedResources(context);
            if (selectedResources.size() > 0) {
                Iterator i = selectedResources.iterator();
                while (i.hasNext()) {
                    IFile file;
                    Object o = i.next();
                    if (!(o instanceof IFile) || OneFileUtils.isDi((IResource)(file = (IFile)o))) continue;
                    i.remove();
                }
                return selectedResources;
            }
            return Collections.EMPTY_LIST;
        }

        public IStructuredSelection getOneStructuredSelection(ActionContext context) {
            List selectedResources = this.getOneSelectedResources(context);
            if (selectedResources.size() > 0) {
                return new StructuredSelection(selectedResources);
            }
            return null;
        }

        protected List getSelectedResources(ActionContext context) {
            ISelection selec = context.getSelection();
            ArrayList<IResource> resources = new ArrayList<IResource>();
            if (selec instanceof IStructuredSelection) {
                IStructuredSelection struc = (IStructuredSelection)selec;
                for (Object o : struc) {
                    if (!(o instanceof IPapyrusFile)) continue;
                    IPapyrusFile papy = (IPapyrusFile)o;
                    resources.addAll(Arrays.asList(papy.getAssociatedResources()));
                }
            }
            return resources;
        }

        public IFile getIFile(ActionContext context) {
            ISelection selec = context.getSelection();
            if (selec instanceof IStructuredSelection) {
                IStructuredSelection struc = (IStructuredSelection)selec;
                Object firstElement = struc.getFirstElement();
                if (firstElement instanceof IFile) {
                    IFile file = (IFile)firstElement;
                    return file;
                }
                if (firstElement instanceof IPapyrusFile) {
                    return ((IPapyrusFile)firstElement).getMainFile();
                }
            }
            return null;
        }
    }
}

