/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.controlmode.action;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.emf.edit.ui.action.ControlAction;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.commands.CheckedOperationHistory;
import org.eclipse.papyrus.infra.core.resource.AbstractBaseModel;
import org.eclipse.papyrus.infra.core.resource.IModel;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.ModelUtils;
import org.eclipse.papyrus.infra.core.utils.EditorUtils;
import org.eclipse.papyrus.infra.services.controlmode.commands.ControlCommand;
import org.eclipse.papyrus.infra.services.controlmode.commands.IControlCondition;
import org.eclipse.papyrus.infra.services.controlmode.ui.ControlResourceDialog;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.NotificationRunnable;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.Type;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.builders.IContext;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.builders.NotificationBuilder;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PapyrusControlAction
extends ControlAction {
    private static final String CONTROL_CONDITION_EXTENSION_POINT_ID = "org.eclipse.papyrus.infra.services.controlmode.customControlCommand";
    private static final String CONTROL_CONDITION_ATTRIBUTE_EXTENSION_POINT = "controlCondition";
    private static final String CONTROL_CONDITION_ELEMENT_EXTENSION_POINT = "enableControlCommand";
    private static List<IControlCondition> commands;

    public PapyrusControlAction(EditingDomain domain) {
        super(domain);
        this.setDescription(EMFEditUIPlugin.INSTANCE.getString("_UI_Control_menu_item_description"));
        this.setToolTipText("Split the model into an external model");
        commands = this.getCommandConditionsExtensions();
    }

    public boolean isEnabled() {
        boolean enableControl = true;
        for (IControlCondition cond : commands) {
            enableControl &= cond.enableControl(this.eObject);
        }
        return enableControl && this.getEditingDomain().isControllable((Object)this.eObject) && !AdapterFactoryEditingDomain.isControlled((Object)this.eObject);
    }

    private boolean getDiagram(EObject eObject) {
        Resource notationResource;
        Resource modelResource = eObject.eResource();
        if (modelResource != null && (notationResource = modelResource.getResourceSet().getResource(modelResource.getURI().trimFileExtension().appendFileExtension("notation"), true)) != null) {
            for (EObject o : notationResource.getContents()) {
                EObject element;
                if (!(o instanceof Diagram) || (element = ((Diagram)o).getElement()) == null || !element.equals(eObject) && !EcoreUtil.isAncestor((EObject)this.eObject, (EObject)element)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean updateSelection(IStructuredSelection selection) {
        boolean result = false;
        this.selection = selection;
        if (selection.size() == 1) {
            Object object = AdapterFactoryEditingDomain.unwrap((Object)selection.getFirstElement());
            if (object instanceof IAdaptable) {
                object = (EObject)((IAdaptable)object).getAdapter(EObject.class);
            }
            this.eObject = (result = this.domain.isControllable(object)) ? (EObject)object : null;
        }
        return result;
    }

    public void run() {
        ModelSet modelSet = ModelUtils.getModelSet();
        if (modelSet != null) {
            IModel umlModel = modelSet.getModel("org.eclipse.papyrus.infra.core.resource.uml.UmlModel");
            boolean enableControl = false;
            if (this.eObject != null && umlModel instanceof AbstractBaseModel) {
                enableControl = ((AbstractBaseModel)umlModel).getResource().equals(this.eObject.eResource());
            }
            if (!enableControl) {
                NotificationBuilder.createAsyncPopup((String)("You must perform control action from the resource:\n" + this.eObject.eResource().getURI().trimFileExtension().toString() + " for this element")).setType(Type.INFO).run();
                return;
            }
            if (!this.getDiagram(this.eObject)) {
                NotificationBuilder.createAsyncPopup((String)"The selected package must contain a diagram to perform control action").setType(Type.INFO).run();
                return;
            }
            Resource controlledModel = this.getControlledResource();
            if (controlledModel == null) {
                return;
            }
            try {
                ControlCommand transactionalCommand = new ControlCommand(EditorUtils.getTransactionalEditingDomain(), controlledModel, this.eObject, "Control", null);
                IStatus status = CheckedOperationHistory.getInstance().execute((IUndoableOperation)transactionalCommand, (IProgressMonitor)new NullProgressMonitor(), null);
                if (status.isOK()) {
                    this.notifySave();
                } else {
                    NotificationBuilder.createErrorPopup((String)status.getMessage()).setTitle("Unable to control").run();
                }
            }
            catch (ExecutionException e) {
                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)EMFEditUIPlugin.INSTANCE.getString("_UI_InvalidURI_label"), (String)EMFEditUIPlugin.INSTANCE.getString("_WARN_CannotCreateResource"));
                EMFEditUIPlugin.INSTANCE.log((Object)e);
            }
        }
    }

    protected void notifySave() {
        new NotificationBuilder().setMessage("Your element has been controlled.\nYou need to save your model to see modifications in your workspace.\nDo you want to save ?").addAction(new NotificationRunnable(){

            public void run(IContext context) {
                try {
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().doSave((IProgressMonitor)new NullProgressMonitor());
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            public String getLabel() {
                return "Save";
            }
        }).setTemporary(true).setAsynchronous(true).setType(Type.INFO).setDelay(2000L).run();
    }

    private Resource getControlledResource() {
        ControlResourceDialog dialog = new ControlResourceDialog(Display.getDefault().getActiveShell(), this.getEditingDomain(), this.eObject.eResource(), this.getElementName(this.eObject));
        int returnCode = dialog.open();
        Resource resource = null;
        if (!(returnCode != 0 || (resource = dialog.getControlResource()) != null && resource.getURI().isPlatformResource())) {
            MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)EMFEditUIPlugin.INSTANCE.getString("_UI_InvalidURI_label"), (String)EMFEditUIPlugin.INSTANCE.getString("_WARN_CannotCreateResource"));
            resource = null;
        }
        return resource;
    }

    private String getElementName(EObject eObject) {
        Object value;
        EStructuralFeature nameFeature = this.getLabelFeature(eObject.eClass());
        if (nameFeature != null && (value = eObject.eGet(nameFeature)) != null) {
            return value.toString();
        }
        return "Unknown";
    }

    protected EStructuralFeature getLabelFeature(EClass eClass) {
        EAttribute result = null;
        for (EAttribute eAttribute : eClass.getEAllAttributes()) {
            if (eAttribute.isMany() || eAttribute.getEType().getInstanceClass() == FeatureMap.Entry.class) continue;
            if ("name".equalsIgnoreCase(eAttribute.getName())) {
                result = eAttribute;
                break;
            }
            if (eAttribute.getEAttributeType().getInstanceClass() != String.class || result == null || result.getEAttributeType().getInstanceClass() == String.class) continue;
            result = eAttribute;
        }
        return result;
    }

    private List<IControlCondition> getCommandConditionsExtensions() {
        IConfigurationElement[] extensions;
        LinkedList<IControlCondition> commands = new LinkedList<IControlCondition>();
        IConfigurationElement[] iConfigurationElementArray = extensions = Platform.getExtensionRegistry().getConfigurationElementsFor(CONTROL_CONDITION_EXTENSION_POINT_ID);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            if (CONTROL_CONDITION_ELEMENT_EXTENSION_POINT.equals(e.getName())) {
                try {
                    IControlCondition controlCondition = (IControlCondition)e.createExecutableExtension(CONTROL_CONDITION_ATTRIBUTE_EXTENSION_POINT);
                    commands.add(controlCondition);
                }
                catch (CoreException exception) {
                    exception.printStackTrace();
                }
            }
            ++n2;
        }
        return commands;
    }
}

