/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.table.common.factory;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.facet.infra.browser.custom.AttributeView;
import org.eclipse.emf.facet.infra.browser.custom.CustomViewFeature;
import org.eclipse.emf.facet.infra.browser.custom.MetamodelView;
import org.eclipse.emf.facet.infra.browser.custom.ReferenceView;
import org.eclipse.emf.facet.infra.browser.custom.StaticFeatureValue;
import org.eclipse.emf.facet.infra.browser.custom.TypeView;
import org.eclipse.emf.facet.infra.facet.Facet;
import org.eclipse.emf.facet.widgets.celleditors.internal.DefaultCommandFactory;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Column;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Row;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance;
import org.eclipse.emf.facet.widgets.nattable.internal.painter.Customization;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyReferenceRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.table.common.Activator;

public class PapyrusCommandFactory
extends DefaultCommandFactory {
    public boolean handles(EditingDomain editingDomain) {
        return editingDomain instanceof TransactionalEditingDomain;
    }

    protected boolean testArgs(Object owner, Object feature) {
        if (feature != null && feature instanceof EStructuralFeature) {
            if (this.isEMFFacetElement(owner)) {
                return false;
            }
            if (owner instanceof EObject) {
                return true;
            }
        }
        return false;
    }

    private boolean isEMFFacetElement(Object owner) {
        if (owner instanceof TableInstance) {
            return true;
        }
        if (owner instanceof MetamodelView) {
            return true;
        }
        if (owner instanceof Row) {
            return true;
        }
        if (owner instanceof Column) {
            return true;
        }
        if (owner instanceof Facet) {
            return true;
        }
        if (owner instanceof Customization) {
            return true;
        }
        if (owner instanceof TypeView) {
            return true;
        }
        if (owner instanceof ReferenceView) {
            return true;
        }
        if (owner instanceof AttributeView) {
            return true;
        }
        if (owner instanceof CustomViewFeature) {
            return true;
        }
        if (owner instanceof StaticFeatureValue) {
            return true;
        }
        String className = owner.getClass().getCanonicalName();
        if (className.contains("org.eclipse.emf.facet")) {
            String message = "the type " + className + " should be included in the test";
            Activator.getDefault();
            Activator.log.info(message);
            return true;
        }
        return false;
    }

    public Command createAddCommand(EditingDomain editingDomain, Object owner, Object feature, Object value) {
        EObject current;
        Object values;
        if (this.isEMFFacetElement(owner)) {
            return super.createAddCommand(editingDomain, owner, feature, value);
        }
        IElementEditService elementEditService = ElementEditServiceUtils.getCommandProvider((Object)owner);
        if (this.testArgs(owner, feature) && elementEditService != null && (values = (current = (EObject)owner).eGet((EStructuralFeature)feature)) instanceof List) {
            ArrayList<Object> newList = new ArrayList<Object>();
            newList.addAll((List)values);
            newList.add(value);
            SetRequest request = new SetRequest((TransactionalEditingDomain)editingDomain, current, (EStructuralFeature)feature, newList);
            ICommand command = elementEditService.getEditCommand((IEditCommandRequest)request);
            if (command.canExecute()) {
                return new GMFtoEMFCommandWrapper(command);
            }
        }
        return UnexecutableCommand.INSTANCE;
    }

    public Command createDeleteCommand(EditingDomain editingDomain, Object elementToDestroy) {
        DestroyElementRequest request;
        ICommand command;
        if (this.isEMFFacetElement(elementToDestroy)) {
            return super.createDeleteCommand(editingDomain, elementToDestroy);
        }
        IElementEditService elementEditService = ElementEditServiceUtils.getCommandProvider((Object)elementToDestroy);
        if (this.testArgs(elementToDestroy, null) && elementEditService != null && (command = elementEditService.getEditCommand((IEditCommandRequest)(request = new DestroyElementRequest((TransactionalEditingDomain)editingDomain, (EObject)elementToDestroy, false)))).canExecute()) {
            return new GMFtoEMFCommandWrapper(command);
        }
        return UnexecutableCommand.INSTANCE;
    }

    public Command createMoveCommand(EditingDomain editingDomain, Object owner, Object feature, Object value, int index) {
        EObject current;
        Object values;
        if (this.isEMFFacetElement(owner)) {
            return super.createMoveCommand(editingDomain, owner, feature, value, index);
        }
        IElementEditService elementEditService = ElementEditServiceUtils.getCommandProvider((Object)owner);
        if (this.testArgs(owner, feature) && elementEditService != null && (values = (current = (EObject)owner).eGet((EStructuralFeature)feature)) instanceof List) {
            ArrayList<Object> newList = new ArrayList<Object>();
            newList.addAll((List)values);
            int currentIndex = ((List)values).indexOf(value);
            newList.remove(currentIndex);
            newList.add(index, value);
            SetRequest request = new SetRequest((TransactionalEditingDomain)editingDomain, (EObject)owner, (EStructuralFeature)feature, newList);
            ICommand command = elementEditService.getEditCommand((IEditCommandRequest)request);
            if (command.canExecute()) {
                return new GMFtoEMFCommandWrapper(command);
            }
        }
        return UnexecutableCommand.INSTANCE;
    }

    public Command createRemoveCommand(EditingDomain editingDomain, Object owner, Object feature, Object value) {
        DestroyReferenceRequest request;
        ICommand command;
        if (this.isEMFFacetElement(owner)) {
            return super.createRemoveCommand(editingDomain, owner, feature, value);
        }
        IElementEditService elementEditService = ElementEditServiceUtils.getCommandProvider((Object)owner);
        if (this.testArgs(owner, feature) && elementEditService != null && (command = elementEditService.getEditCommand((IEditCommandRequest)(request = new DestroyReferenceRequest((TransactionalEditingDomain)editingDomain, (EObject)owner, (EReference)feature, (EObject)value, false)))).canExecute()) {
            return new GMFtoEMFCommandWrapper(command);
        }
        return UnexecutableCommand.INSTANCE;
    }

    public Command createSetCommand(EditingDomain editingDomain, Object owner, Object feature, Object value) {
        SetRequest request;
        ICommand command;
        if (this.isEMFFacetElement(owner)) {
            return super.createSetCommand(editingDomain, owner, feature, value);
        }
        IElementEditService elementEditService = ElementEditServiceUtils.getCommandProvider((Object)owner);
        if (this.testArgs(owner, feature) && elementEditService != null && (command = elementEditService.getEditCommand((IEditCommandRequest)(request = new SetRequest((TransactionalEditingDomain)editingDomain, (EObject)owner, (EStructuralFeature)feature, value)))).canExecute()) {
            return new GMFtoEMFCommandWrapper(command);
        }
        return UnexecutableCommand.INSTANCE;
    }

    public Command createSetCommand(EditingDomain editingDomain, Object owner, Object feature, Object value, int index) {
        EObject current;
        Object values;
        if (this.isEMFFacetElement(owner)) {
            return super.createSetCommand(null, owner, feature, value, index);
        }
        IElementEditService elementEditService = ElementEditServiceUtils.getCommandProvider((Object)owner);
        if (this.testArgs(owner, feature) && elementEditService != null && (values = (current = (EObject)owner).eGet((EStructuralFeature)feature)) instanceof List) {
            ArrayList<Object> newList = new ArrayList<Object>();
            newList.addAll((List)values);
            newList.set(index, value);
            SetRequest request = new SetRequest((TransactionalEditingDomain)editingDomain, (EObject)owner, (EStructuralFeature)feature, newList);
            ICommand command = elementEditService.getEditCommand((IEditCommandRequest)request);
            if (command.canExecute()) {
                return new GMFtoEMFCommandWrapper(command);
            }
        }
        return UnexecutableCommand.INSTANCE;
    }
}

