/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.resources.refactoring;

import java.util.ArrayList;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.DeleteParticipant;
import org.eclipse.ltk.core.refactoring.resource.DeleteResourceChange;
import org.eclipse.papyrus.infra.ui.resources.refactoring.ModelParticipantHelpers;

public class DeleteModelParticipant
extends DeleteParticipant {
    private static final String NAME = "Papyrus Model Deletion";
    private Set<IResource> filesToRemove;

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        ArrayList<InternalDeleteResourceChange> changes = new ArrayList<InternalDeleteResourceChange>(this.filesToRemove.size());
        for (IResource file : this.filesToRemove) {
            if (!file.exists()) continue;
            changes.add(new InternalDeleteResourceChange(file.getFullPath(), true));
        }
        if (changes.isEmpty()) {
            return new NullChange();
        }
        return new CompositeChange(this.getName(), changes.toArray(new Change[changes.size()]));
    }

    public String getName() {
        return NAME;
    }

    protected boolean initialize(Object element) {
        if (!(element instanceof IFile)) {
            return false;
        }
        IFile file = (IFile)element;
        this.filesToRemove = ModelParticipantHelpers.getRelatedFiles(file);
        return this.filesToRemove.size() > 0;
    }

    private class InternalDeleteResourceChange
    extends DeleteResourceChange {
        public InternalDeleteResourceChange(IPath resourcePath, boolean forceOutOfSync) {
            super(resourcePath, forceOutOfSync);
        }

        public Change perform(IProgressMonitor pm) throws CoreException {
            IResource resource = this.getModifiedResource();
            if (resource == null || !resource.exists()) {
                return new NullChange();
            }
            return super.perform(pm);
        }
    }
}

