/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.toolbox.notification.builders;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.IBuilder;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.ICompositeCreator;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.INotification;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.NotificationRunnable;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.PapyrusToolkit;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.Type;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.builders.AsyncNotifierBuilder;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.builders.IContext;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.builders.PopupBuilder;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.builders.PropertyWrapper;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormToolkit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotificationBuilder {
    private FormToolkit toolkit = PapyrusToolkit.INSTANCE;
    protected Map<String, Object> parameters = new HashMap<String, Object>();
    protected static Map<Class<? extends IBuilder>, IBuilder> builders = NotificationBuilder.getBuilders();
    static String ASYNCHRONOUS = "asynchronous";
    static String MESSAGE = "message";
    static String COMPOSITE = "composite";
    static String ACTION = "default_action";
    static String DELAY = "delay";
    static String TEMPORARY = "temporary";
    static String TITLE = "title";
    static String HTML = "html";
    static String TYPE = "type";
    static String IMAGE = "image";
    protected Class<? extends IBuilder> builderClass;

    private static Map<Class<? extends IBuilder>, IBuilder> getBuilders() {
        IConfigurationElement[] elements;
        HashMap<Class<? extends IBuilder>, IBuilder> result = new HashMap<Class<? extends IBuilder>, IBuilder>();
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.papyrus.infra.widgets.toolbox.papyrusNotificationBuilder");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                IBuilder instance = (IBuilder)e.createExecutableExtension("builder");
                result.put(instance.getClass(), instance);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            ++n2;
        }
        return result;
    }

    public NotificationBuilder setMessage(String message) {
        this.parameters.put(MESSAGE, message);
        return this;
    }

    public NotificationBuilder setAsynchronous(boolean asynchronous) {
        this.parameters.put(ASYNCHRONOUS, asynchronous);
        return this;
    }

    public NotificationBuilder addAction(NotificationRunnable runnable) {
        LinkedList<NotificationRunnable> runnables = (LinkedList<NotificationRunnable>)this.parameters.get(ACTION);
        if (runnables == null) {
            runnables = new LinkedList<NotificationRunnable>();
            this.parameters.put(ACTION, runnables);
        }
        runnables.add(runnable);
        return this;
    }

    public NotificationBuilder setComposite(ICompositeCreator creator) {
        this.parameters.put(COMPOSITE, creator);
        return this;
    }

    public NotificationBuilder setDelay(long delayMs) {
        this.parameters.put(DELAY, delayMs);
        return this;
    }

    public NotificationBuilder setTemporary(boolean temporary) {
        this.parameters.put(TEMPORARY, temporary);
        return this;
    }

    public NotificationBuilder setTitle(String title) {
        this.parameters.put(TITLE, title);
        return this;
    }

    public NotificationBuilder setHTML(boolean useHTML) {
        this.parameters.put(HTML, useHTML);
        return this;
    }

    public NotificationBuilder setType(Type type) {
        this.parameters.put(TYPE, (Object)type);
        return this;
    }

    public NotificationBuilder setImage(Image image) {
        this.parameters.put(IMAGE, image);
        return this;
    }

    public NotificationBuilder setBuilderClass(Class<? extends IBuilder> builderClass) {
        this.builderClass = builderClass;
        return this;
    }

    public NotificationBuilder setParameter(String name, Object value) {
        this.parameters.put(name, value);
        return this;
    }

    public INotification run() {
        HashSet<Object> copy = null;
        if (this.builderClass != null) {
            copy = new HashSet<IBuilder>();
            try {
                copy.add(this.builderClass.newInstance());
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
        } else {
            copy = new HashSet<IBuilder>(builders.values());
        }
        Iterator i = copy.iterator();
        block3: while (i.hasNext()) {
            IBuilder b = (IBuilder)i.next();
            for (String string : this.parameters.keySet()) {
                if (b.accept(string, this.parameters.get(string))) continue;
                i.remove();
                continue block3;
            }
        }
        INotification result = null;
        PropertyWrapper wrapper = new PropertyWrapper(this.parameters);
        if (copy.size() >= 1) {
            result = ((IBuilder)copy.iterator().next()).build(wrapper, this.toolkit);
        } else if (copy.isEmpty()) {
            result = builders.get(PopupBuilder.class).build(wrapper, this.toolkit);
        }
        return result;
    }

    public static NotificationBuilder createInformationBuilder() {
        NotificationBuilder builder = new NotificationBuilder();
        return builder;
    }

    public static NotificationBuilder createAsyncPopup(String text) {
        return new NotificationBuilder().setAsynchronous(true).setBuilderClass(AsyncNotifierBuilder.class).setTemporary(true).setMessage(text);
    }

    public static NotificationBuilder createAsyncPopup(String title, String text) {
        return new NotificationBuilder().setAsynchronous(true).setBuilderClass(AsyncNotifierBuilder.class).setTemporary(true).setMessage(text).setTitle(title);
    }

    public static NotificationBuilder createInfoPopup(String text) {
        return new NotificationBuilder().setAsynchronous(false).setBuilderClass(PopupBuilder.class).setTemporary(false).setMessage(text).setType(Type.INFO);
    }

    public static NotificationBuilder createWarningPopup(String text) {
        return new NotificationBuilder().setAsynchronous(false).setBuilderClass(PopupBuilder.class).setTemporary(false).setMessage(text).setType(Type.WARNING);
    }

    public static NotificationBuilder createQuestionPopup(String text) {
        return new NotificationBuilder().setAsynchronous(false).setBuilderClass(PopupBuilder.class).setTemporary(false).setMessage(text).setType(Type.QUESTION);
    }

    public static NotificationBuilder createErrorPopup(String text) {
        return new NotificationBuilder().setAsynchronous(false).setBuilderClass(PopupBuilder.class).setTemporary(false).setMessage(text).setType(Type.ERROR);
    }

    public static NotificationBuilder createYesNo(String message, final Runnable yes, final Runnable no) {
        return new NotificationBuilder().setType(Type.QUESTION).setAsynchronous(true).setTemporary(false).setMessage(message).addAction(new NotificationRunnable(){

            public void run(IContext context) {
                if (yes != null) {
                    context.put("action_id", 64);
                    yes.run();
                }
            }

            public String getLabel() {
                return "Yes";
            }
        }).addAction(new NotificationRunnable(){

            public void run(IContext context) {
                if (no != null) {
                    context.put("action_id", 128);
                    no.run();
                }
            }

            public String getLabel() {
                return "No";
            }
        });
    }

    public static NotificationBuilder createYesNo(String message) {
        return new NotificationBuilder().setType(Type.QUESTION).setAsynchronous(false).setTemporary(false).setMessage(message).addAction(new NotificationRunnable(){

            public void run(IContext context) {
                context.put("action_id", 64);
            }

            public String getLabel() {
                return "Yes";
            }
        }).addAction(new NotificationRunnable(){

            public void run(IContext context) {
                context.put("action_id", 128);
            }

            public String getLabel() {
                return "No";
            }
        });
    }

    public static NotificationBuilder createYesNo(String message, final NotificationRunnable yes, final NotificationRunnable no) {
        return new NotificationBuilder().setType(Type.QUESTION).setAsynchronous(true).setTemporary(false).setMessage(message).addAction(new NotificationRunnable(){

            public void run(IContext context) {
                if (yes != null) {
                    context.put("action_id", 64);
                    yes.run(context);
                }
            }

            public String getLabel() {
                return "Yes";
            }
        }).addAction(new NotificationRunnable(){

            public void run(IContext context) {
                if (no != null) {
                    context.put("action_id", 128);
                    no.run(context);
                }
            }

            public String getLabel() {
                return "No";
            }
        });
    }

    public static Image getSWTImage(final int imageID, Shell shell) {
        Display display;
        if (shell == null || shell.isDisposed()) {
            display = Display.getCurrent();
            Assert.isNotNull((Object)display, (String)"The dialog should be created in UI thread");
        } else {
            display = shell.getDisplay();
        }
        final Image[] image = new Image[1];
        display.syncExec(new Runnable(){

            public void run() {
                image[0] = display.getSystemImage(imageID);
            }
        });
        return image[0];
    }
}

