/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.toolbox.notification.dialogs;

import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.INotification;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.NotificationRunnable;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.builders.IContext;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.dialogs.AbstractNotificationPopup;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PapyrusAsyncNotificationPopup
extends AbstractNotificationPopup {
    protected String text;
    protected String title;
    protected IContext context = new IContext.Context();
    protected Collection<NotificationRunnable> runnables = new LinkedList<NotificationRunnable>();

    public PapyrusAsyncNotificationPopup(Display display, FormToolkit toolkit) {
        super(display, toolkit);
    }

    @Override
    protected void createContentArea(Composite parent) {
        super.createContentArea(parent);
        this.doCreateClient(parent);
        this.doCreateActionSection(parent);
    }

    protected void doCreateActionSection(Composite parent) {
        Composite compo = this.toolkit.createComposite(parent);
        compo.setLayoutData((Object)new GridData(3, 3, true, false, 1, 1));
        compo.setLayout((Layout)new FillLayout(256));
        this.createRunnables(compo);
    }

    protected void createRunnables(Composite compo) {
        if (!this.runnables.isEmpty()) {
            boolean first = true;
            for (final NotificationRunnable r : this.runnables) {
                if (!first) {
                    this.toolkit.createLabel(compo, " ");
                }
                Hyperlink h = this.toolkit.createHyperlink(compo, r.getLabel() == null ? "run" : r.getLabel(), 0);
                h.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                    public void linkActivated(HyperlinkEvent e) {
                        PapyrusAsyncNotificationPopup.this.run(r);
                    }
                });
                first = false;
            }
        }
    }

    protected void setCompositeCreated(Composite c) {
        this.context.put("composite_created_please_check_IContext_Constant", c);
    }

    public void setINotification(INotification notification) {
        this.context.put("notification_object_please_check_IContext_Constant", notification);
    }

    protected void run(NotificationRunnable r) {
        if (r != null) {
            r.run(this.context);
        }
    }

    protected void doCreateClient(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(this.text);
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void addRunnable(NotificationRunnable runnable) {
        this.runnables.add(runnable);
    }

    public void addAllRunnable(Collection<NotificationRunnable> runnable) {
        this.runnables.addAll(runnable);
    }

    @Override
    protected String getPopupShellTitle() {
        if (this.title == null) {
            return super.getPopupShellTitle();
        }
        return this.title;
    }
}

