/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.databinding;

import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.papyrus.infra.tools.databinding.AggregatedObservable;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;

public class GrayedCheckboxObservableValue
extends AbstractObservableValue
implements SelectionListener {
    private Button checkbox;
    private Boolean currentValue;
    private AggregatedObservable aggregated;

    public GrayedCheckboxObservableValue(Button checkbox, AggregatedObservable aggregated) {
        this.checkbox = checkbox;
        this.checkbox.addSelectionListener((SelectionListener)this);
        this.aggregated = aggregated;
    }

    public Object getValueType() {
        return Object.class;
    }

    protected Boolean doGetValue() {
        return this.checkbox.getSelection();
    }

    protected void doSetValue(Object value) {
        if (this.aggregated.hasDifferentValues()) {
            this.checkbox.setSelection(true);
            this.checkbox.setGrayed(true);
            return;
        }
        this.checkbox.setGrayed(false);
        if (value instanceof Boolean) {
            Boolean booleanValue = (Boolean)value;
            this.checkbox.setSelection(booleanValue.booleanValue());
            this.currentValue = booleanValue;
        } else if (value == null) {
            this.checkbox.setSelection(false);
        }
    }

    public void dispose() {
        this.checkbox.removeSelectionListener((SelectionListener)this);
        super.dispose();
    }

    public void widgetSelected(SelectionEvent e) {
        Boolean newValue;
        final Boolean oldValue = this.currentValue;
        this.currentValue = newValue = Boolean.valueOf(this.checkbox.getSelection());
        this.checkbox.setGrayed(false);
        this.fireValueChange(new ValueDiff(){

            public Object getOldValue() {
                return oldValue;
            }

            public Object getNewValue() {
                return newValue;
            }
        });
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

