/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.editors;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.infra.widgets.creation.ReferenceValueFactory;
import org.eclipse.papyrus.infra.widgets.databinding.CLabelObservableValue;
import org.eclipse.papyrus.infra.widgets.databinding.ReferenceDialogObservableValue;
import org.eclipse.papyrus.infra.widgets.editors.AbstractValueEditor;
import org.eclipse.papyrus.infra.widgets.editors.ITreeSelectorDialog;
import org.eclipse.papyrus.infra.widgets.editors.TreeSelectorDialog;
import org.eclipse.papyrus.infra.widgets.messages.Messages;
import org.eclipse.papyrus.infra.widgets.providers.EncapsulatedContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IAdaptableContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceDialog
extends AbstractValueEditor
implements SelectionListener {
    protected final CLabel currentValueLabel;
    protected Button browseValuesButton;
    protected Button createInstanceButton;
    protected Button editInstanceButton;
    protected Button unsetButton;
    protected ILabelProvider labelProvider;
    protected IStaticContentProvider contentProvider;
    protected final ITreeSelectorDialog dialog;
    protected Object value;
    protected ReferenceValueFactory valueFactory;
    protected boolean readOnly;
    private boolean directCreation;

    public ReferenceDialog(Composite parent, int style) {
        super(parent, style);
        this.currentValueLabel = factory.createCLabel((Composite)this, null, factory.getBorderStyle() | style);
        this.currentValueLabel.setLayoutData((Object)this.getDefaultLayoutData());
        this.currentValueLabel.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                ReferenceDialog.this.editAction();
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.dialog = this.createDialog(parent.getShell());
        this.createButtons();
        this.updateControls();
    }

    protected ITreeSelectorDialog createDialog(Shell shell) {
        return new TreeSelectorDialog(shell);
    }

    protected void createButtons() {
        ((GridLayout)this.getLayout()).numColumns += 4;
        this.browseValuesButton = factory.createButton((Composite)this, null, 8);
        this.browseValuesButton.setImage(Activator.getDefault().getImage("/icons/browse_12x12.gif"));
        this.browseValuesButton.setToolTipText(Messages.ReferenceDialog_EditValue);
        this.browseValuesButton.addSelectionListener((SelectionListener)this);
        this.createInstanceButton = factory.createButton((Composite)this, null, 8);
        this.createInstanceButton.setImage(Activator.getDefault().getImage("/icons/Add_12x12.gif"));
        this.createInstanceButton.setToolTipText(Messages.ReferenceDialog_CreateANewObject);
        this.createInstanceButton.addSelectionListener((SelectionListener)this);
        this.editInstanceButton = factory.createButton((Composite)this, null, 8);
        this.editInstanceButton.setImage(Activator.getDefault().getImage("/icons/Edit_12x12.gif"));
        this.editInstanceButton.setToolTipText(Messages.ReferenceDialog_EditTheCurrentValue);
        this.editInstanceButton.addSelectionListener((SelectionListener)this);
        this.unsetButton = factory.createButton((Composite)this, null, 8);
        this.unsetButton.setImage(Activator.getDefault().getImage("/icons/Delete_12x12.gif"));
        this.unsetButton.setToolTipText(Messages.ReferenceDialog_UnsetValue);
        this.unsetButton.addSelectionListener((SelectionListener)this);
    }

    protected void browseAction() {
        this.setInitialSelection(Collections.singletonList(this.getValue()));
        int result = this.dialog.open();
        if (result == 0) {
            Object[] newValue = this.dialog.getResult();
            if (newValue.length == 0) {
                this.setValue(null);
            } else {
                Object value = newValue[0];
                if (this.contentProvider instanceof IAdaptableContentProvider) {
                    value = ((IAdaptableContentProvider)((Object)this.contentProvider)).getAdaptedValue(value);
                }
                this.setValue(value);
            }
        }
    }

    protected void createAction() {
        if (this.valueFactory != null && this.valueFactory.canCreateObject()) {
            Object value = this.valueFactory.createObject((Control)this.createInstanceButton);
            if (value == null) {
                return;
            }
            Collection<Object> validatedObjects = this.valueFactory.validateObjects(Collections.singleton(value));
            if (!validatedObjects.isEmpty()) {
                this.setValue(validatedObjects.iterator().next());
            }
        }
    }

    protected void editAction() {
        Object currentValue = this.getValue();
        if (currentValue != null && this.valueFactory != null && this.valueFactory.canEdit()) {
            Object newValue = this.valueFactory.edit((Control)this.editInstanceButton, this.getValue());
            if (newValue != currentValue) {
                this.setValue(newValue);
            }
            this.updateLabel();
        }
    }

    protected void unsetAction() {
        this.setValue(null);
    }

    protected void updateLabel() {
        if (this.binding != null) {
            this.binding.updateModelToTarget();
        } else {
            this.currentValueLabel.setImage(this.labelProvider.getImage(this.getValue()));
            this.currentValueLabel.setText(this.labelProvider.getText(this.getValue()));
        }
    }

    public void setContentProvider(IStaticContentProvider provider) {
        this.dialog.setContentProvider(new EncapsulatedContentProvider(provider));
        if (this.getValue() != null) {
            this.setInitialSelection(Collections.singletonList(this.getValue()));
        }
        this.contentProvider = provider;
    }

    public void setLabelProvider(ILabelProvider provider) {
        if (provider == null) {
            this.setLabelProvider((ILabelProvider)new LabelProvider());
            return;
        }
        this.dialog.setLabelProvider(provider);
        this.labelProvider = provider;
        if (this.widgetObservable != null) {
            ((CLabelObservableValue)this.widgetObservable).setLabelProvider(this.labelProvider);
        }
        this.updateLabel();
    }

    @Override
    public void setLabel(String label) {
        super.setLabel(label);
        this.dialog.setTitle(label);
    }

    @Override
    public Object getValue() {
        if (this.modelProperty != null) {
            return this.modelProperty.getValue();
        }
        return this.value;
    }

    @Override
    public Object getEditableType() {
        return Object.class;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        this.updateControls();
    }

    @Override
    public boolean isReadOnly() {
        return !this.currentValueLabel.isEnabled();
    }

    @Override
    protected void doBinding() {
        super.doBinding();
    }

    protected void setInitialSelection(List<?> initialValues) {
        this.dialog.setInitialElementSelections(initialValues);
    }

    public void widgetDisposed(DisposeEvent e) {
        this.dispose();
    }

    @Override
    public void setModelObservable(IObservableValue modelProperty) {
        this.setWidgetObservable((IObservableValue)new ReferenceDialogObservableValue(this, this.currentValueLabel, modelProperty, this.labelProvider));
        super.setModelObservable(modelProperty);
        this.updateControls();
    }

    @Override
    public void setToolTipText(String text) {
        super.setLabelToolTipText(text);
        this.currentValueLabel.setToolTipText(text);
    }

    public void setValueFactory(ReferenceValueFactory factory) {
        this.valueFactory = factory;
        this.updateControls();
    }

    public void widgetSelected(SelectionEvent e) {
        Widget widget = e.widget;
        if (widget == this.browseValuesButton) {
            this.browseAction();
        } else if (widget == this.createInstanceButton) {
            this.createAction();
        } else if (widget == this.editInstanceButton) {
            this.editAction();
        } else if (widget == this.unsetButton) {
            this.unsetAction();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    protected void updateControls() {
        boolean exclude = this.valueFactory == null || !this.valueFactory.canCreateObject();
        this.setExclusion((Control)this.editInstanceButton, exclude);
        this.setExclusion((Control)this.createInstanceButton, exclude);
        this.setExclusion((Control)this.browseValuesButton, this.directCreation);
        this.browseValuesButton.setEnabled(!this.readOnly);
        if (!exclude) {
            this.editInstanceButton.setEnabled(this.valueFactory != null && this.valueFactory.canEdit() && this.getValue() != null);
            this.createInstanceButton.setEnabled(this.valueFactory != null && this.valueFactory.canCreateObject() && !this.readOnly);
        }
        boolean enabled = !this.readOnly;
        enabled = enabled && this.getValue() != null;
        this.unsetButton.setEnabled(enabled);
    }

    public void update() {
        super.update();
        this.updateControls();
    }

    public void setDirectCreation(boolean directCreation) {
        this.directCreation = directCreation;
        this.updateControls();
    }

    public void setValue(Object value) {
        this.value = value;
        if (this.modelProperty != null) {
            this.modelProperty.setValue(value);
        }
        this.updateControls();
        this.updateLabel();
        this.commit();
    }

    public void setInput(Object input) {
        this.dialog.setInput(input);
    }
}

