/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.editors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.infra.widgets.editors.IElementSelector;
import org.eclipse.papyrus.infra.widgets.messages.Messages;
import org.eclipse.papyrus.infra.widgets.providers.CollectionContentProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectionEditor
extends Composite
implements SelectionListener {
    protected final List<Object> initialSelection;
    private IElementSelector selector;
    protected Composite selectorSection;
    protected Composite messageSection;
    protected Composite createAdditionalButtonSection;
    protected Composite rightButtonsSection;
    protected ListViewer selectedElementsViewer;
    protected org.eclipse.swt.widgets.List selectedElements;
    private Button add;
    private Button remove;
    private Button addAll;
    private Button removeAll;
    private Button up;
    private Button down;
    private ILabelProvider labelProvider;
    protected final Collection<Object> currentSelection;
    private SelectionListener additionalButtonSelectionListener;
    private String message;
    private boolean withAdditionalButton = false;
    private String additionalButtonLabel = null;
    private Button additionalButton;
    protected Composite buttonSection;

    public SelectionEditor(Composite parent, IElementSelector selector, ILabelProvider labelProvider, List<Object> initialSelection) {
        super(parent, 0);
        this.selector = selector;
        this.labelProvider = labelProvider;
        this.initialSelection = new ArrayList<Object>();
        for (Object current : initialSelection) {
            this.initialSelection.add(current);
        }
        this.currentSelection = initialSelection;
    }

    public void create() {
        SelectionEditor parent = this;
        GridLayout layout = new GridLayout(1, true);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        parent.setLayout((Layout)layout);
        this.createMessageSection(parent);
        this.createBody(parent);
        this.createCreateButtonSection(parent);
    }

    protected void createBody(Composite parent) {
        Composite par = new Composite(parent, 0);
        this.createSelectorSection(par);
        this.createControlsSection(par);
        this.createListSection(par);
        this.createRightButtonsSection(par);
        GridLayout layout = new GridLayout();
        layout.makeColumnsEqualWidth = false;
        layout.numColumns = 4;
        par.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, true);
        par.setLayoutData((Object)data);
    }

    protected void createMessageSection(Composite parent) {
        this.messageSection = new Composite(parent, 0);
        Label label = new Label(this.messageSection, 0);
        label.setText(this.message);
        this.messageSection.setLayout((Layout)new FillLayout(256));
    }

    protected void createCreateButtonSection(Composite parent) {
        if (this.withAdditionalButton) {
            this.buttonSection = new Composite(parent, 0);
            this.additionalButton = new Button(this.buttonSection, 8);
            if (this.additionalButtonLabel != null) {
                this.additionalButton.setText(this.additionalButtonLabel);
            }
            this.buttonSection.setLayout((Layout)new FillLayout());
            this.additionalButton.addSelectionListener(this.additionalButtonSelectionListener);
        }
    }

    protected void createSelectorSection(Composite parent) {
        this.selectorSection = new Composite(parent, 0);
        this.selectorSection.setLayout((Layout)new FillLayout());
        GridData data = new GridData(4, 4, true, true);
        data.widthHint = 400;
        this.selectorSection.setLayoutData((Object)data);
        this.selector.createControls(this.selectorSection);
    }

    protected void createControlsSection(Composite parent) {
        this.buttonSection = new Composite(parent, 0);
        this.buttonSection.setLayout((Layout)new GridLayout(1, true));
        this.add = new Button(this.buttonSection, 8);
        this.add.setImage(Activator.getDefault().getImage("/icons/arrow_right.gif"));
        this.add.addSelectionListener((SelectionListener)this);
        this.add.setToolTipText(Messages.MultipleValueSelectorDialog_AddSelectedElements);
        this.remove = new Button(this.buttonSection, 8);
        this.remove.setImage(Activator.getDefault().getImage("/icons/arrow_left.gif"));
        this.remove.addSelectionListener((SelectionListener)this);
        this.remove.setToolTipText(Messages.MultipleValueEditor_RemoveSelectedElements);
        this.addAll = new Button(this.buttonSection, 8);
        this.addAll.setImage(Activator.getDefault().getImage("/icons/arrow_double.gif"));
        this.addAll.addSelectionListener((SelectionListener)this);
        this.addAll.setToolTipText(Messages.MultipleValueSelectorDialog_AddAllElements);
        this.removeAll = new Button(this.buttonSection, 8);
        this.removeAll.setImage(Activator.getDefault().getImage("/icons/arrow_left_double.gif"));
        this.removeAll.addSelectionListener((SelectionListener)this);
        this.removeAll.setToolTipText(Messages.MultipleValueSelectorDialog_RemoveAllElements);
    }

    protected void createListSection(Composite parent) {
        Composite listSection = new Composite(parent, 0);
        this.selectedElements = new org.eclipse.swt.widgets.List(listSection, 2818);
        GridData data = new GridData(4, 4, true, true);
        data.widthHint = 400;
        listSection.setLayout((Layout)new FillLayout());
        listSection.setLayoutData((Object)data);
        this.selectedElementsViewer = new ListViewer(this.selectedElements);
        this.selectedElementsViewer.setContentProvider((IContentProvider)CollectionContentProvider.instance);
        if (this.labelProvider != null) {
            this.selectedElementsViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        }
        this.selectedElementsViewer.setInput(this.currentSelection);
        this.selector.setSelectedElements(this.currentSelection.toArray());
    }

    protected void createRightButtonsSection(Composite parent) {
        this.rightButtonsSection = new Composite(parent, 0);
        this.rightButtonsSection.setLayout((Layout)new GridLayout(1, true));
        this.up = new Button(this.rightButtonsSection, 8);
        this.up.setImage(Activator.getDefault().getImage("/icons/Up_12x12.gif"));
        this.up.addSelectionListener((SelectionListener)this);
        this.up.setToolTipText(Messages.MultipleValueEditor_MoveSelectedElementsUp);
        this.down = new Button(this.rightButtonsSection, 8);
        this.down.setImage(Activator.getDefault().getImage("/icons/Down_12x12.gif"));
        this.down.addSelectionListener((SelectionListener)this);
        this.down.setToolTipText(Messages.MultipleValueEditor_MoveSelectedElementsDown);
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.add) {
            this.addAction();
        } else if (e.widget == this.remove) {
            this.removeAction();
        } else if (e.widget == this.addAll) {
            this.addAllAction();
        } else if (e.widget == this.removeAll) {
            this.removeAllAction();
        } else if (e.widget == this.up) {
            this.upAction();
        } else if (e.widget == this.down) {
            this.downAction();
        }
    }

    protected void addAction() {
        Object[] elements = this.selector.getSelectedElements();
        this.addElements(elements);
    }

    protected void upAction() {
        IStructuredSelection selection = (IStructuredSelection)this.selectedElementsViewer.getSelection();
        LinkedList<Object> list = new LinkedList<Object>(this.currentSelection);
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            int oldIndex = list.indexOf(o);
            if (oldIndex > 0) {
                this.move(list, oldIndex, oldIndex - 1);
            }
            ++n2;
        }
        this.currentSelection.clear();
        this.currentSelection.addAll(list);
        StructuredSelection selectionCopy = new StructuredSelection(selection.toArray());
        this.selectedElementsViewer.setSelection((ISelection)selectionCopy);
        this.selectedElementsViewer.refresh();
    }

    protected void downAction() {
        IStructuredSelection selection = (IStructuredSelection)this.selectedElementsViewer.getSelection();
        LinkedList<Object> list = new LinkedList<Object>(this.currentSelection);
        int maxIndex = list.size() - 1;
        Object[] selectionArray = selection.toArray();
        int i = selectionArray.length - 1;
        while (i >= 0) {
            Object o = selectionArray[i];
            int oldIndex = list.indexOf(o);
            if (oldIndex < maxIndex) {
                this.move(list, oldIndex, oldIndex + 1);
            }
            --i;
        }
        this.currentSelection.clear();
        this.currentSelection.addAll(list);
        StructuredSelection selectionCopy = new StructuredSelection(selection.toArray());
        this.selectedElementsViewer.setSelection((ISelection)selectionCopy);
        this.selectedElementsViewer.refresh();
    }

    protected void move(List<Object> list, int oldIndex, int newIndex) {
        int size = list.size();
        if (oldIndex < 0 || oldIndex >= size) {
            throw new IndexOutOfBoundsException("oldIndex: " + oldIndex + ", size:" + size);
        }
        if (newIndex < 0 || newIndex >= size) {
            throw new IndexOutOfBoundsException("newIndex: " + newIndex + ", size:" + size);
        }
        Object element = list.remove(oldIndex);
        list.add(newIndex, element);
    }

    protected void removeAction() {
        IStructuredSelection selection = (IStructuredSelection)this.selectedElementsViewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            this.currentSelection.remove(element);
            ++n2;
        }
        this.selector.setSelectedElements(this.currentSelection.toArray());
        this.selectedElementsViewer.setSelection(null);
        this.selectedElementsViewer.refresh();
    }

    protected void removeAllAction() {
        this.currentSelection.clear();
        this.selector.setSelectedElements(new Object[0]);
        this.selectedElementsViewer.setSelection(null);
        this.selectedElementsViewer.refresh();
    }

    protected void addAllAction() {
        Object[] elements = this.selector.getAllElements();
        this.addElements(elements);
    }

    protected void addElements(Object[] elements) {
        if (elements != null) {
            this.currentSelection.addAll(Arrays.asList(elements));
            this.selectedElementsViewer.refresh();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void setAdditionalButton(boolean withAdditionalButton, String messageButton, SelectionListener listener) {
        this.withAdditionalButton = withAdditionalButton;
        this.additionalButtonLabel = messageButton;
        this.additionalButtonSelectionListener = listener;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public Collection<?> getSelectedElements() {
        return this.currentSelection;
    }

    public List<Object> getElementToRemove() {
        ArrayList<Object> removedObject = new ArrayList<Object>();
        for (Object current : this.initialSelection) {
            if (this.getSelectedElements().contains(current)) continue;
            removedObject.add(current);
        }
        return removedObject;
    }

    public List<Object> getElementToAdd() {
        ArrayList<Object> addedObject = new ArrayList<Object>();
        for (Object current : this.getSelectedElements()) {
            if (this.initialSelection.contains(current)) continue;
            addedObject.add(current);
        }
        return addedObject;
    }
}

