/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.common.edit.part;

import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.gmf.diagram.common.figure.SelectableBorderedNodeFigure;
import org.eclipse.papyrus.sysml.diagram.common.edit.part.BlockLabelNameEditPart;
import org.eclipse.papyrus.sysml.diagram.common.edit.part.FlowPortAffixedNodeEditPart;
import org.eclipse.papyrus.sysml.diagram.common.edit.part.StructureCompartmentEditPart;
import org.eclipse.papyrus.sysml.diagram.common.edit.policy.BlockCompositeSemanticEditPolicy;
import org.eclipse.papyrus.sysml.diagram.common.figure.BlockCompositeFigure;
import org.eclipse.papyrus.uml.diagram.common.edit.part.AbstractElementEditPart;
import org.eclipse.papyrus.uml.diagram.common.edit.part.PortAffixedNodeEditPart;
import org.eclipse.papyrus.uml.diagram.common.edit.policy.EncapsulatedClassifierResizableShapeEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.edit.policy.StructuredClassifierCreationEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.AffixedNodeAlignmentEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.AppliedStereotypeNodeLabelDisplayEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.BorderItemResizableEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.HyperLinkPopupBarEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.NavigationEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.QualifiedNameDisplayEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.ShowHideClassifierContentsEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.ShowHideCompartmentEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.locator.PortPositionLocator;

public class BlockCompositeEditPart
extends AbstractElementEditPart {
    public BlockCompositeEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new BlockCompositeSemanticEditPolicy());
        this.installEditPolicy("CreationPolicy", (EditPolicy)new StructuredClassifierCreationEditPolicy());
        this.installEditPolicy("Show/Hide Compartment Policy", (EditPolicy)new ShowHideCompartmentEditPolicy());
        this.installEditPolicy("Show/Hide Classifier Contents Policy", (EditPolicy)new ShowHideClassifierContentsEditPolicy());
        this.installEditPolicy("Qualified_name_editpolicy", (EditPolicy)new QualifiedNameDisplayEditPolicy());
        this.installEditPolicy("AppliedStereotypeLabelDisplayEditPolicy", (EditPolicy)new AppliedStereotypeNodeLabelDisplayEditPolicy());
        this.installEditPolicy("PopupBarEditPolicy", (EditPolicy)new HyperLinkPopupBarEditPolicy());
        this.installEditPolicy("NavigationEditPolicy", (EditPolicy)new NavigationEditPolicy());
        this.installEditPolicy("affixed node alignment editpolicy", (EditPolicy)new AffixedNodeAlignmentEditPolicy());
        this.installEditPolicy("PrimaryDrag Policy", (EditPolicy)new EncapsulatedClassifierResizableShapeEditPolicy());
    }

    protected LayoutEditPolicy createLayoutEditPolicy() {
        LayoutEditPolicy lep = new LayoutEditPolicy(){

            protected EditPolicy createChildEditPolicy(EditPart child) {
                if (child instanceof IBorderItemEditPart) {
                    return new BorderItemResizableEditPolicy();
                }
                EditPolicy result = child.getEditPolicy((Object)"PrimaryDrag Policy");
                if (result == null) {
                    result = new NonResizableEditPolicy();
                }
                return result;
            }

            protected Command getMoveChildrenCommand(Request request) {
                return null;
            }

            protected Command getCreateCommand(CreateRequest request) {
                return null;
            }
        };
        return lep;
    }

    protected boolean addFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof BlockLabelNameEditPart) {
            ((BlockLabelNameEditPart)childEditPart).setLabel(this.getPrimaryShape().getNameLabel());
            return true;
        }
        if (childEditPart instanceof FlowPortAffixedNodeEditPart) {
            PortPositionLocator locator = new PortPositionLocator(this.getMainFigure(), 0);
            this.getBorderedFigure().getBorderItemContainer().add(((FlowPortAffixedNodeEditPart)childEditPart).getFigure(), (Object)locator);
            return true;
        }
        if (childEditPart instanceof PortAffixedNodeEditPart) {
            PortPositionLocator locator = new PortPositionLocator(this.getMainFigure(), 0);
            this.getBorderedFigure().getBorderItemContainer().add(((PortAffixedNodeEditPart)childEditPart).getFigure(), (Object)locator);
            return true;
        }
        if (childEditPart instanceof StructureCompartmentEditPart) {
            IFigure pane = this.getPrimaryShape().getStructureCompartmentFigure();
            this.setupContentPane(pane);
            pane.add(((StructureCompartmentEditPart)childEditPart).getFigure());
            return true;
        }
        return false;
    }

    protected boolean removeFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof BlockLabelNameEditPart) {
            return true;
        }
        if (childEditPart instanceof FlowPortAffixedNodeEditPart) {
            this.getBorderedFigure().getBorderItemContainer().remove(((FlowPortAffixedNodeEditPart)childEditPart).getFigure());
            return true;
        }
        if (childEditPart instanceof PortAffixedNodeEditPart) {
            this.getBorderedFigure().getBorderItemContainer().remove(((PortAffixedNodeEditPart)childEditPart).getFigure());
            return true;
        }
        if (childEditPart instanceof StructureCompartmentEditPart) {
            IFigure pane = this.getPrimaryShape().getStructureCompartmentFigure();
            this.setupContentPane(pane);
            pane.remove(((StructureCompartmentEditPart)childEditPart).getFigure());
            return true;
        }
        return false;
    }

    protected IFigure getContentPaneFor(IGraphicalEditPart editPart) {
        if (editPart instanceof StructureCompartmentEditPart) {
            return this.getPrimaryShape().getStructureCompartmentFigure();
        }
        if (editPart instanceof IBorderItemEditPart) {
            return this.getBorderedFigure().getBorderItemContainer();
        }
        return this.getContentPane();
    }

    protected NodeFigure createNodeFigure() {
        return new SelectableBorderedNodeFigure((IFigure)this.createMainFigure());
    }

    protected IFigure createNodeShape() {
        this.primaryShape = new BlockCompositeFigure();
        return this.primaryShape;
    }

    public BlockCompositeFigure getPrimaryShape() {
        return (BlockCompositeFigure)this.primaryShape;
    }

    public EditPart getPrimaryChildEditPart() {
        return this.getChildBySemanticHint("label_sysml_block_name");
    }
}

