/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.common.parser;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.sysml.portandflows.FlowProperty;
import org.eclipse.papyrus.sysml.portandflows.PortandflowsPackage;
import org.eclipse.papyrus.uml.diagram.common.parser.PropertyLabelParser;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.util.UMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlowPropertyLabelParser
extends PropertyLabelParser {
    protected static final String DIRECTION_FORMAT = "%s %s";

    @Override
    public String getPrintString(IAdaptable element, int flags) {
        Property property;
        FlowProperty flowProperty;
        if (flags == 0) {
            return "<empty label>";
        }
        String result = super.getPrintString(element, flags);
        EObject eObject = (EObject)element.getAdapter(EObject.class);
        if (eObject != null && eObject instanceof Property && (flowProperty = (FlowProperty)UMLUtil.getStereotypeApplication((Element)(property = (Property)eObject), FlowProperty.class)) != null && (flags & 0x100) == 256) {
            String direction;
            switch (flowProperty.getDirection().getValue()) {
                case 0: {
                    direction = "in";
                    break;
                }
                case 1: {
                    direction = "out";
                    break;
                }
                case 2: {
                    direction = "inout";
                    break;
                }
                default: {
                    direction = "inout";
                }
            }
            result = String.format(DIRECTION_FORMAT, direction, result);
        }
        return result;
    }

    @Override
    public boolean isAffectingEvent(Object event, int flags) {
        Object feature;
        if (event instanceof Notification && (feature = ((Notification)event).getFeature()) instanceof EStructuralFeature) {
            return PortandflowsPackage.eINSTANCE.getFlowProperty_Direction().equals(feature) || super.isAffectingEvent(event, flags);
        }
        return false;
    }

    @Override
    public List<EObject> getSemanticElementsBeingParsed(EObject element) {
        Property semElement;
        FlowProperty flowProperty;
        List<EObject> semanticElementsBeingParsed = super.getSemanticElementsBeingParsed(element);
        if (element != null && element instanceof Property && (flowProperty = (FlowProperty)UMLUtil.getStereotypeApplication((Element)(semElement = (Property)element), FlowProperty.class)) != null) {
            semanticElementsBeingParsed.add((EObject)flowProperty);
        }
        return semanticElementsBeingParsed;
    }

    @Override
    public Map<Integer, String> getMasks() {
        HashMap<Integer, String> masks = new HashMap<Integer, String>(10);
        masks.put(256, "Direction");
        masks.put(2, "Visibility");
        masks.put(4, "Is Derived");
        masks.put(8, "Name");
        masks.put(16, "Type");
        masks.put(0x200000, "Show <Undefined> type");
        masks.put(32, "Multiplicity");
        masks.put(0x100000, "Show default multiplicity");
        masks.put(64, "Default Value");
        masks.put(128, "Modifiers");
        return masks;
    }
}

