/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.common.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.sysml.blocks.BlocksPackage;
import org.eclipse.papyrus.sysml.blocks.Dimension;
import org.eclipse.papyrus.sysml.blocks.Unit;
import org.eclipse.papyrus.uml.diagram.common.parser.NamedElementLabelParser;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.util.UMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnitLabelParser
extends NamedElementLabelParser {
    protected static final String NAME_FORMAT = "%s";
    protected static final String DIMENSION_FORMAT = "%s {%s}";

    @Override
    public String getPrintString(IAdaptable element, int flags) {
        if (flags == 0) {
            return "<empty label>";
        }
        String result = "";
        EObject eObject = (EObject)element.getAdapter(EObject.class);
        if (eObject != null && eObject instanceof InstanceSpecification) {
            InstanceSpecification iSpec = (InstanceSpecification)eObject;
            Unit unit = (Unit)UMLUtil.getStereotypeApplication((Element)iSpec, Unit.class);
            if ((flags & 8) == 8 && iSpec.isSetName()) {
                String name = iSpec.getName();
                result = String.format(NAME_FORMAT, name);
            }
            if ((flags & 0x800) == 2048) {
                Dimension dim;
                String dimensionName = "<Undefined>";
                if (unit != null && unit.getDimension() != null && (dim = unit.getDimension()).getBase_InstanceSpecification() != null && dim.getBase_InstanceSpecification().isSetName()) {
                    dimensionName = dim.getBase_InstanceSpecification().getName();
                }
                result = String.format(DIMENSION_FORMAT, result, dimensionName);
            }
        }
        return result;
    }

    @Override
    public boolean isAffectingEvent(Object event, int flags) {
        Object feature;
        if (event instanceof Notification && (feature = ((Notification)event).getFeature()) instanceof EStructuralFeature) {
            return BlocksPackage.eINSTANCE.getUnit_Dimension().equals(feature) || super.isAffectingEvent(event, flags);
        }
        return false;
    }

    @Override
    public List<EObject> getSemanticElementsBeingParsed(EObject element) {
        ArrayList<EObject> semanticElementsBeingParsed = new ArrayList<EObject>();
        if (element != null && element instanceof InstanceSpecification) {
            InstanceSpecification semElement = (InstanceSpecification)element;
            semanticElementsBeingParsed.add((EObject)semElement);
            Unit unit = (Unit)UMLUtil.getStereotypeApplication((Element)semElement, Unit.class);
            if (unit != null) {
                semanticElementsBeingParsed.add((EObject)unit);
            }
        }
        return semanticElementsBeingParsed;
    }

    @Override
    public Map<Integer, String> getMasks() {
        HashMap<Integer, String> masks = new HashMap<Integer, String>(2);
        masks.put(8, "Name");
        masks.put(2048, "Dimension");
        return masks;
    }
}

