/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.common.utils;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.papyrus.infra.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.core.resource.uml.UmlModel;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.utils.EditorUtils;
import org.eclipse.papyrus.infra.core.utils.ServiceUtilsForActionHandlers;
import org.eclipse.papyrus.sysml.blocks.BlocksPackage;
import org.eclipse.papyrus.sysml.diagram.common.Activator;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.util.UMLUtil;

public class SysMLSelectionTester
extends PropertyTester {
    public static final String IS_SYSML_MODEL = "isSysMLModel";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        IMultiDiagramEditor editor = EditorUtils.getMultiDiagramEditor();
        if (editor == null) {
            return false;
        }
        Boolean currentValue = null;
        if (IS_SYSML_MODEL.equals(property)) {
            currentValue = this.testSysMLModelNature(receiver);
            return currentValue == expectedValue;
        }
        return false;
    }

    protected boolean testSysMLModelNature(Object receiver) {
        Profile sysml;
        boolean isSysMLModel = false;
        EObject root = this.getRoot();
        if (root instanceof Package && ((Package)root).isProfileApplied(sysml = UMLUtil.getProfile((EPackage)BlocksPackage.eINSTANCE, (EObject)root))) {
            isSysMLModel = true;
        }
        return isSysMLModel;
    }

    private EObject getRoot() {
        EObject root = null;
        try {
            ServiceUtilsForActionHandlers serviceUtils = ServiceUtilsForActionHandlers.getInstance();
            UmlModel openedModel = (UmlModel)serviceUtils.getModelSet().getModel("org.eclipse.papyrus.infra.core.resource.uml.UmlModel");
            if (openedModel != null) {
                root = openedModel.lookupRoot();
            }
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
        }
        catch (NotFoundException e) {
            Activator.log.error((Throwable)e);
        }
        return root;
    }
}

