/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.internalblock.edit.policy;

import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientReferenceRelationshipRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.gmf.diagram.common.provider.IGraphicalTypeRegistry;
import org.eclipse.papyrus.sysml.diagram.common.edit.policy.BlockPropertyCompositeSemanticEditPolicy;
import org.eclipse.papyrus.sysml.diagram.internalblock.provider.CustomGraphicalTypeRegistry;
import org.eclipse.papyrus.sysml.diagram.internalblock.provider.ElementTypes;
import org.eclipse.papyrus.sysml.diagram.internalblock.provider.GraphicalTypeRegistry;
import org.eclipse.papyrus.uml.diagram.composite.edit.commands.CommentAnnotatedElementCreateCommand;
import org.eclipse.papyrus.uml.diagram.composite.edit.commands.CommentAnnotatedElementReorientCommand;
import org.eclipse.papyrus.uml.diagram.composite.edit.commands.ConstraintConstrainedElementCreateCommand;
import org.eclipse.papyrus.uml.diagram.composite.edit.commands.ConstraintConstrainedElementReorientCommand;

public class CustomBlockPropertyCompositeSemanticEditPolicy
extends BlockPropertyCompositeSemanticEditPolicy {
    private IGraphicalTypeRegistry registry = new CustomGraphicalTypeRegistry();
    private IGraphicalTypeRegistry inheritedRegistry = new GraphicalTypeRegistry();

    protected Command getCreateRelationshipCommand(CreateRelationshipRequest req) {
        if (ElementTypes.COMMENT_ANNOTATED_ELEMENT == req.getElementType()) {
            return this.getGEFWrapper((ICommand)new CommentAnnotatedElementCreateCommand(req, req.getSource(), req.getTarget()));
        }
        if (ElementTypes.CONSTRAINT_CONSTRAINED_ELEMENT == req.getElementType()) {
            return this.getGEFWrapper((ICommand)new ConstraintConstrainedElementCreateCommand(req, req.getSource(), req.getTarget()));
        }
        String newEdgeGraphicalType = this.registry.getEdgeGraphicalType(req.getElementType());
        if (this.inheritedRegistry.isKnownEdgeType(newEdgeGraphicalType)) {
            return UnexecutableCommand.INSTANCE;
        }
        if (!this.registry.isKnownEdgeType(newEdgeGraphicalType)) {
            return UnexecutableCommand.INSTANCE;
        }
        return super.getCreateRelationshipCommand(req);
    }

    protected Command getReorientReferenceRelationshipCommand(ReorientReferenceRelationshipRequest req) {
        String reconnectedViewType;
        View reconnectedView = (View)req.getParameter("graphical_edge");
        String string = reconnectedViewType = reconnectedView != null ? reconnectedView.getType() : "undefined_type";
        if (ElementTypes.COMMENT_ANNOTATED_ELEMENT.getSemanticHint().equals(reconnectedViewType)) {
            return this.getGEFWrapper((ICommand)new CommentAnnotatedElementReorientCommand(req));
        }
        if (ElementTypes.CONSTRAINT_CONSTRAINED_ELEMENT.getSemanticHint().equals(reconnectedViewType)) {
            return this.getGEFWrapper((ICommand)new ConstraintConstrainedElementReorientCommand(req));
        }
        return super.getReorientReferenceRelationshipCommand(req);
    }
}

