/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.internalblock.edit.policy;

import java.util.ArrayList;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.papyrus.infra.gmfdiag.common.commands.SelectAndExecuteCommand;
import org.eclipse.papyrus.sysml.diagram.internalblock.edit.policy.CustomDragDropEditPolicy;
import org.eclipse.papyrus.sysml.diagram.internalblock.utils.BlockDropHelper;
import org.eclipse.papyrus.sysml.diagram.internalblock.utils.PartDropHelper;
import org.eclipse.papyrus.sysml.service.types.element.SysMLElementTypes;
import org.eclipse.papyrus.uml.service.types.element.UMLElementTypes;
import org.eclipse.ui.PlatformUI;

public class CustomBlockPropertyStructureCompartmentEditPartDropEditPolicy
extends CustomDragDropEditPolicy {
    public Command getDropObjectsCommand(DropObjectsRequest dropRequest) {
        BlockDropHelper helper = new BlockDropHelper(this.getEditingDomain());
        if (dropRequest.getObjects().size() == 1) {
            Command dropAsTypedProperty;
            Command dropAsTypedValue;
            Command dropAsTypedActorPart;
            Command dropAsTypedReference;
            Command dropAsTypedPart;
            ArrayList<Command> commandChoice = new ArrayList<Command>();
            PartDropHelper partDropHelper = new PartDropHelper(this.getEditingDomain());
            Command dropPartOnPart = partDropHelper.getDropPartOnPart(dropRequest, (GraphicalEditPart)this.getHost());
            if (dropPartOnPart != null && dropPartOnPart.canExecute()) {
                commandChoice.add(dropPartOnPart);
            }
            if ((dropAsTypedPart = helper.getDropAsStructureItemOnPart(dropRequest, (GraphicalEditPart)this.getHost(), (IElementType)SysMLElementTypes.PART_PROPERTY)) != null && dropAsTypedPart.canExecute()) {
                commandChoice.add(dropAsTypedPart);
            }
            if ((dropAsTypedReference = helper.getDropAsStructureItemOnPart(dropRequest, (GraphicalEditPart)this.getHost(), (IElementType)SysMLElementTypes.REFERENCE_PROPERTY)) != null && dropAsTypedReference.canExecute()) {
                commandChoice.add(dropAsTypedReference);
            }
            if ((dropAsTypedActorPart = helper.getDropAsStructureItemOnPart(dropRequest, (GraphicalEditPart)this.getHost(), (IElementType)SysMLElementTypes.ACTOR_PART_PROPERTY)) != null && dropAsTypedActorPart.canExecute()) {
                commandChoice.add(dropAsTypedActorPart);
            }
            if ((dropAsTypedValue = helper.getDropAsStructureItemOnPart(dropRequest, (GraphicalEditPart)this.getHost(), (IElementType)SysMLElementTypes.VALUE_PROPERTY)) != null && dropAsTypedValue.canExecute()) {
                commandChoice.add(dropAsTypedValue);
            }
            if ((dropAsTypedProperty = helper.getDropAsStructureItemOnPart(dropRequest, (GraphicalEditPart)this.getHost(), (IElementType)UMLElementTypes.PROPERTY)) != null && dropAsTypedProperty.canExecute()) {
                commandChoice.add(dropAsTypedProperty);
            }
            Command defaultDropCommand = super.getDropObjectsCommand(dropRequest);
            defaultDropCommand.setLabel("Default drop (Show dropped object in diagram)");
            if (defaultDropCommand != null && defaultDropCommand.canExecute()) {
                commandChoice.add(defaultDropCommand);
            }
            if (commandChoice.size() > 1) {
                SelectAndExecuteCommand selectCommand = new SelectAndExecuteCommand("Select drop action for ", PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), commandChoice);
                return new ICommandProxy((ICommand)selectCommand);
            }
            if (commandChoice.size() == 1) {
                return (Command)commandChoice.get(0);
            }
            return UnexecutableCommand.INSTANCE;
        }
        return super.getDropObjectsCommand(dropRequest);
    }
}

