/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.modelexplorer.handler;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.sysml.modelexplorer.filter.CommandFilter;
import org.eclipse.papyrus.sysml.modelexplorer.handler.AbstractCommandHandler;
import org.eclipse.papyrus.views.modelexplorer.ICommandContext;
import org.eclipse.papyrus.views.modelexplorer.ICommandFilter;
import org.eclipse.papyrus.views.modelexplorer.ModelExplorerPageBookView;
import org.eclipse.papyrus.views.modelexplorer.ModelExplorerView;
import org.eclipse.papyrus.views.modelexplorer.NavigatorUtils;

public abstract class CreateCommandHandler
extends AbstractCommandHandler {
    protected ICommandFilter filter = new CommandFilter();
    private Command createCommand;

    protected abstract IElementType getElementTypeToCreate();

    protected Command buildCommand() {
        ICommandContext commandContext = this.getCommandContext();
        if (commandContext == null) {
            return UnexecutableCommand.INSTANCE;
        }
        EObject container = commandContext.getContainer();
        EReference reference = commandContext.getReference();
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)container);
        if (provider == null) {
            return UnexecutableCommand.INSTANCE;
        }
        CreateElementRequest createRequest = null;
        createRequest = reference == null ? new CreateElementRequest(container, this.getElementTypeToCreate()) : new CreateElementRequest(container, this.getElementTypeToCreate(), reference);
        ICommand createGMFCommand = provider.getEditCommand((IEditCommandRequest)createRequest);
        GMFtoEMFCommandWrapper emfCommand = new GMFtoEMFCommandWrapper(createGMFCommand);
        return emfCommand;
    }

    protected Command getCommand() {
        if (this.createCommand == null) {
            this.createCommand = this.buildCommand();
        }
        return this.createCommand;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Collection results;
        Object result = super.execute(event);
        EObject newElement = null;
        if (result instanceof Collection && !(results = (Collection)result).isEmpty() && results.toArray()[0] instanceof EObject) {
            newElement = (EObject)results.toArray()[0];
        }
        ModelExplorerView modelExplorerView = null;
        ModelExplorerPageBookView bookViewPart = (ModelExplorerPageBookView)NavigatorUtils.findViewPart((String)"org.eclipse.papyrus.views.modelexplorer.modelexplorer");
        if (bookViewPart != null) {
            modelExplorerView = (ModelExplorerView)bookViewPart.getActiveView();
        }
        if (modelExplorerView != null && newElement != null) {
            ArrayList<EObject> semanticElementList = new ArrayList<EObject>();
            semanticElementList.add(newElement);
            modelExplorerView.revealSemanticElement(semanticElementList);
        }
        return result;
    }

    public boolean isVisible() {
        if (!this.filter.getVisibleCommands().contains(this.getElementTypeToCreate())) {
            return false;
        }
        return super.isVisible();
    }

    public boolean isEnabled() {
        this.createCommand = this.buildCommand();
        if (!this.filter.getVisibleCommands().contains(this.getElementTypeToCreate())) {
            return false;
        }
        return super.isEnabled();
    }
}

