/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.alf.ui.contentassist;

import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.papyrus.uml.alf.alf.SuffixExpression;
import org.eclipse.papyrus.uml.alf.scoping.AlfPartialScope;
import org.eclipse.papyrus.uml.alf.scoping.AlfScopeProvider;
import org.eclipse.papyrus.uml.alf.ui.contentassist.AbstractAlfProposalProvider;
import org.eclipse.papyrus.uml.alf.validation.typing.ErrorTypeFacade;
import org.eclipse.papyrus.uml.alf.validation.typing.SignatureFacadeFactory;
import org.eclipse.papyrus.uml.alf.validation.typing.TypeExpression;
import org.eclipse.papyrus.uml.alf.validation.typing.TypeFacade;
import org.eclipse.papyrus.uml.alf.validation.typing.TypeUtils;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Property;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.gmf.glue.contentassist.CompletionProposalUtils;
import org.eclipse.xtext.gmf.glue.contentassist.CustomCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;

public class AlfProposalProvider
extends AbstractAlfProposalProvider {
    public void completeLocalNameDeclarationStatement_Type(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        AlfPartialScope scope = AlfScopeProvider.scopingTool.getVisibleClassifiers(model);
        new AlfCompletionProposalUtils().classifierProposals(scope, context, acceptor);
        super.completeLocalNameDeclarationStatement_Type(model, assignment, context, acceptor);
    }

    public void completeOperationCallExpression_OperationName(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        TypeExpression typeOfModel = null;
        typeOfModel = model instanceof SuffixExpression ? (context.getPrefix().equals("") ? new TypeUtils().getTypeOfCandidateExpression(model) : new TypeUtils((SuffixExpression)model).getTypeOfCandidateExpression(model.eContainer())) : new TypeUtils().getTypeOfCandidateExpression(model);
        if (typeOfModel == null || typeOfModel.getTypeFacade() instanceof ErrorTypeFacade) {
            super.completeOperationCallExpression_OperationName(model, assignment, context, acceptor);
        } else {
            new AlfCompletionProposalUtils().operationProposals(typeOfModel.getTypeFacade(), context, acceptor);
            super.completeOperationCallExpression_OperationName(model, assignment, context, acceptor);
        }
    }

    public void completePropertyCallExpression_PropertyName(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        TypeExpression typeOfModel = null;
        typeOfModel = model instanceof SuffixExpression ? (context.getPrefix().equals("") ? new TypeUtils().getTypeOfCandidateExpression(model) : new TypeUtils((SuffixExpression)model).getTypeOfCandidateExpression(model.eContainer())) : new TypeUtils().getTypeOfCandidateExpression(model);
        if (typeOfModel == null || typeOfModel.getTypeFacade() instanceof ErrorTypeFacade) {
            super.completePropertyCallExpression_PropertyName(model, assignment, context, acceptor);
        } else {
            new AlfCompletionProposalUtils().propertyProposals(typeOfModel.getTypeFacade(), context, acceptor);
            super.completePropertyCallExpression_PropertyName(model, assignment, context, acceptor);
        }
    }

    private class AlfCompletionProposalUtils {
        private AlfCompletionProposalUtils() {
        }

        public void classifierProposals(AlfPartialScope scope, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
            for (List scopingLevel : scope.getScopeDetails()) {
                String completionString = "";
                String displayString = "";
                HashMap<String, CustomCompletionProposal> completionProposals = new HashMap<String, CustomCompletionProposal>();
                CustomCompletionProposal proposal = null;
                for (EObject visibleClassifier : scopingLevel) {
                    completionString = scope.getElementName(visibleClassifier);
                    displayString = completionString;
                    if (!completionString.startsWith(context.getPrefix())) continue;
                    completionString = completionString.substring(context.getPrefix().length());
                    if (completionProposals.get(displayString) != null) continue;
                    completionProposals.put(displayString, proposal);
                    proposal = CompletionProposalUtils.createCompletionProposal((String)completionString, (String)displayString, (ContentAssistContext)context);
                    acceptor.accept((ICompletionProposal)proposal);
                }
            }
        }

        public void operationProposals(TypeFacade f, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
            Classifier c = f.extractActualType();
            String completionString = "";
            String displayString = "";
            HashMap<String, CustomCompletionProposal> completionProposals = new HashMap<String, CustomCompletionProposal>();
            CustomCompletionProposal proposal = null;
            for (Operation o : c.getAllOperations()) {
                completionString = SignatureFacadeFactory.eInstance.createSignatureFacade((EObject)o).getLabel();
                displayString = completionString;
                if (!completionString.startsWith(context.getPrefix())) continue;
                completionString = completionString.substring(context.getPrefix().length());
                if (completionProposals.get(displayString) != null) continue;
                completionProposals.put(displayString, proposal);
                proposal = CompletionProposalUtils.createCompletionProposal((String)completionString, (String)displayString, (ContentAssistContext)context);
                acceptor.accept((ICompletionProposal)proposal);
            }
        }

        public void propertyProposals(TypeFacade f, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
            Classifier c = f.extractActualType();
            String completionString = "";
            String displayString = "";
            HashMap<String, CustomCompletionProposal> completionProposals = new HashMap<String, CustomCompletionProposal>();
            CustomCompletionProposal proposal = null;
            for (Property p : c.getAllAttributes()) {
                displayString = String.valueOf(p.getName()) + " : " + (p.getType() == null ? "any" : p.getType().getName());
                completionString = p.getName();
                if (!completionString.startsWith(context.getPrefix())) continue;
                completionString = completionString.substring(context.getPrefix().length());
                if (completionProposals.get(displayString) != null) continue;
                completionProposals.put(displayString, proposal);
                proposal = CompletionProposalUtils.createCompletionProposal((String)completionString, (String)displayString, (ContentAssistContext)context);
                acceptor.accept((ICompletionProposal)proposal);
            }
        }
    }
}

