/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.alf.alf;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SelectOrRejectOperator implements Enumerator
{
    SELECT(0, "SELECT", "select"),
    REJECT(1, "REJECT", "reject");

    public static final int SELECT_VALUE = 0;
    public static final int REJECT_VALUE = 1;
    private static final SelectOrRejectOperator[] VALUES_ARRAY;
    public static final List<SelectOrRejectOperator> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new SelectOrRejectOperator[]{SELECT, REJECT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static SelectOrRejectOperator get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SelectOrRejectOperator result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SelectOrRejectOperator getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SelectOrRejectOperator result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SelectOrRejectOperator get(int value) {
        switch (value) {
            case 0: {
                return SELECT;
            }
            case 1: {
                return REJECT;
            }
        }
        return null;
    }

    private SelectOrRejectOperator(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

