/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.alf.scoping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.uml.alf.alf.AcceptClause;
import org.eclipse.papyrus.uml.alf.alf.AcceptStatement;
import org.eclipse.papyrus.uml.alf.alf.DocumentedStatement;
import org.eclipse.papyrus.uml.alf.alf.InvocationOrAssignementOrDeclarationStatement;
import org.eclipse.papyrus.uml.alf.alf.LocalNameDeclarationStatement;
import org.eclipse.papyrus.uml.alf.alf.LoopVariableDefinition;
import org.eclipse.papyrus.uml.alf.alf.SequenceExpansionExpression;
import org.eclipse.papyrus.uml.alf.alf.Statement;
import org.eclipse.papyrus.uml.alf.scoping.AlfPartialScope;
import org.eclipse.papyrus.uml.alf.scoping.AlfScopeProvider;
import org.eclipse.papyrus.uml.alf.validation.AlfJavaValidator;
import org.eclipse.papyrus.uml.alf.validation.typing.TypeExpression;
import org.eclipse.papyrus.uml.alf.validation.typing.TypeUtils;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Feature;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Reception;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.VisibilityKind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AlfScopingTool {
    protected static List<EObject> removeDuplicateClassifiers(List<EObject> list) {
        ArrayList<Object> intermediateFilteredList = new ArrayList<Object>();
        HashMap<String, Classifier> classifiers = new HashMap<String, Classifier>();
        HashMap<String, Classifier> elementImports = new HashMap<String, Classifier>();
        for (EObject o : list) {
            if (o instanceof Classifier) {
                Classifier c = (Classifier)o;
                if (classifiers.get(c.getQualifiedName()) != null) continue;
                classifiers.put(c.getQualifiedName(), c);
                intermediateFilteredList.add(c);
                continue;
            }
            if (!(o instanceof ElementImport)) continue;
            ElementImport e = (ElementImport)o;
            Classifier c = (Classifier)e.getImportedElement();
            if (elementImports.get(e.getAlias()) == null) {
                elementImports.put(e.getAlias(), c);
                intermediateFilteredList.add(e);
                continue;
            }
            Classifier alreadyInTheList = (Classifier)elementImports.get(e.getAlias());
            if (alreadyInTheList.getQualifiedName().equals(c.getQualifiedName())) continue;
            intermediateFilteredList.add(e);
        }
        ArrayList<EObject> filteredList = new ArrayList<EObject>();
        int i = 0;
        while (i < intermediateFilteredList.size()) {
            String classifierName = intermediateFilteredList.get(i) instanceof Classifier ? ((Classifier)intermediateFilteredList.get(i)).getName() : ((ElementImport)intermediateFilteredList.get(i)).getAlias();
            String classifierQualifiedName = intermediateFilteredList.get(i) instanceof Classifier ? ((Classifier)intermediateFilteredList.get(i)).getQualifiedName() : ((Classifier)((ElementImport)intermediateFilteredList.get(i)).getImportedElement()).getQualifiedName();
            boolean duplicateFound = false;
            int j = i + 1;
            while (j < intermediateFilteredList.size() && !duplicateFound) {
                String cddDuplicateClassifierName;
                String string = cddDuplicateClassifierName = intermediateFilteredList.get(j) instanceof Classifier ? ((Classifier)intermediateFilteredList.get(j)).getName() : ((ElementImport)intermediateFilteredList.get(j)).getAlias();
                if (cddDuplicateClassifierName.equals(classifierName)) {
                    String cddDuplicateClassifierQualifiedName;
                    String string2 = cddDuplicateClassifierQualifiedName = intermediateFilteredList.get(j) instanceof Classifier ? ((Classifier)intermediateFilteredList.get(j)).getQualifiedName() : ((Classifier)((ElementImport)intermediateFilteredList.get(j)).getImportedElement()).getQualifiedName();
                    if (cddDuplicateClassifierQualifiedName.equals(classifierQualifiedName)) {
                        duplicateFound = true;
                    }
                }
                ++j;
            }
            if (!duplicateFound) {
                filteredList.add((EObject)intermediateFilteredList.get(i));
            }
            ++i;
        }
        return filteredList;
    }

    public abstract AlfPartialScope getVisibleVariablesOrParametersOrProperties(EObject var1);

    public AlfPartialScope getVisibleOperationsOrBehaviors(EObject context) {
        OperationAndBehaviorNameStrategy nameStrategy = new OperationAndBehaviorNameStrategy();
        OperationAndBehaviorBuildScopeStrategy buildScopeStrategy = new OperationAndBehaviorBuildScopeStrategy();
        return new AlfPartialScope(nameStrategy, buildScopeStrategy, context);
    }

    public AlfPartialScope getVisibleBehaviors(EObject context) {
        BehaviorsNameStrategy nameStrategy = new BehaviorsNameStrategy();
        BehaviorsBuildScopeStrategy buildScopeStrategy = new BehaviorsBuildScopeStrategy();
        return new AlfPartialScope(nameStrategy, buildScopeStrategy, context);
    }

    public AlfPartialScope getVisibleClassifiers(EObject context) {
        ClassifiersNameStrategy nameStrategy = new ClassifiersNameStrategy();
        ClassifiersBuildScopeStrategy buildScopeStrategy = new ClassifiersBuildScopeStrategy();
        return new AlfPartialScope(nameStrategy, buildScopeStrategy, context);
    }

    public AlfPartialScope getVisiblePackages(EObject context) {
        if (context instanceof Package) {
            PackageNameStrategy nameStrategy = new PackageNameStrategy();
            PackagesBuildScopeStrategy buildScopeStrategy = new PackagesBuildScopeStrategy();
            return new AlfPartialScope(nameStrategy, buildScopeStrategy, context);
        }
        PackageNameStrategy nameStrategy = new PackageNameStrategy();
        PackagesBuildScopeStrategy buildScopeStrategy = new PackagesBuildScopeStrategy();
        return new AlfPartialScope(nameStrategy, buildScopeStrategy, context);
    }

    public boolean isAReturnStatementExpected(EObject context) {
        return false;
    }

    public TypeExpression getExpectedReturnType(EObject context) {
        return null;
    }

    public AlfPartialScope getVisibleSignalReceptions(EObject context) {
        ReceptionsNameStrategy nameStrategy = new ReceptionsNameStrategy();
        ReceptionsBuildScopeStrategy buildScopeStrategy = new ReceptionsBuildScopeStrategy();
        return new AlfPartialScope(nameStrategy, buildScopeStrategy, context);
    }

    public AlfPartialScope getVisibleEnumerationLiterals(EObject context) {
        EnumerationLiteralNameStrategy nameStrategy = new EnumerationLiteralNameStrategy();
        EnumerationLiteralBuildScopeStrategy buildScopeStrategy = new EnumerationLiteralBuildScopeStrategy();
        return new AlfPartialScope(nameStrategy, buildScopeStrategy, context);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class BehaviorsBuildScopeStrategy
    implements AlfPartialScope.IBuildScopeStrategy {
        protected BehaviorsBuildScopeStrategy() {
        }

        @Override
        public List<List<EObject>> buildScope(EObject contextElement) {
            ElementImport eImport;
            ArrayList<List<EObject>> nestedScopes = new ArrayList<List<EObject>>();
            List<Object> nestedList = new ArrayList<EObject>();
            Package potentialContextPackage = null;
            if (contextElement instanceof Package) {
                potentialContextPackage = (Package)contextElement;
            } else if (contextElement instanceof ElementImport && (eImport = (ElementImport)contextElement).getImportedElement() instanceof Package) {
                potentialContextPackage = (Package)eImport.getImportedElement();
            }
            if (potentialContextPackage != null) {
                nestedScopes.add(this.processPublicallyImportedBehaviors(potentialContextPackage));
                return nestedScopes;
            }
            Classifier contextClassifier = AlfJavaValidator.getContextClassifier();
            for (PackageImport i : contextClassifier.getPackageImports()) {
                Package importedPackage = i.getImportedPackage();
                nestedList.addAll(this.processPublicallyImportedBehaviors(importedPackage));
            }
            for (PackageImport i : contextClassifier.getElementImports()) {
                PackageableElement e = i.getImportedElement();
                if (!(e instanceof Classifier)) continue;
                if (i.getAlias() != null) {
                    nestedList.add((EObject)i);
                    continue;
                }
                nestedList.add(e);
            }
            nestedList = AlfScopingTool.removeDuplicateClassifiers(nestedList);
            nestedScopes.add(nestedList);
            nestedList = new ArrayList();
            if (AlfJavaValidator.getAlfStandardLibrary() != null) {
                List<EObject> importedClassifiers = this.processPublicallyImportedBehaviors(AlfJavaValidator.getAlfStandardLibrary());
                importedClassifiers = AlfScopingTool.removeDuplicateClassifiers(importedClassifiers);
                nestedList.addAll(importedClassifiers);
                nestedScopes.add(nestedList);
            }
            return nestedScopes;
        }

        private List<EObject> processPublicallyImportedBehaviors(Package p) {
            ArrayList<EObject> importedBehaviors = new ArrayList<EObject>();
            for (NamedElement n : p.getOwnedMembers()) {
                if (n instanceof Behavior) {
                    if (((Behavior)n).getVisibility() == VisibilityKind.PRIVATE_LITERAL) continue;
                    importedBehaviors.add((EObject)n);
                    continue;
                }
                if (!(n instanceof Package)) continue;
                importedBehaviors.addAll(this.processPublicallyImportedBehaviors((Package)n));
            }
            for (ElementImport eImport : p.getElementImports()) {
                PackageableElement element;
                if (eImport.getVisibility() == VisibilityKind.PRIVATE_LITERAL || !((element = eImport.getImportedElement()) instanceof Behavior)) continue;
                if (eImport.getAlias() != null) {
                    importedBehaviors.add((EObject)eImport);
                    continue;
                }
                importedBehaviors.add((EObject)element);
            }
            for (PackageImport pImport : p.getPackageImports()) {
                if (pImport.getVisibility() == VisibilityKind.PRIVATE_LITERAL) continue;
                importedBehaviors.addAll(this.processPublicallyImportedBehaviors(pImport.getImportedPackage()));
            }
            return importedBehaviors;
        }
    }

    protected class BehaviorsNameStrategy
    implements AlfPartialScope.IGetNameStrategy {
        protected BehaviorsNameStrategy() {
        }

        public String getName(EObject element) {
            if (element instanceof Behavior) {
                return ((Behavior)element).getName();
            }
            if (element instanceof ElementImport) {
                ElementImport imported = (ElementImport)element;
                return imported.getAlias() != null ? imported.getAlias() : ((Behavior)imported.getImportedElement()).getName();
            }
            return "Unexpected element kind...";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ClassifiersBuildScopeStrategy
    implements AlfPartialScope.IBuildScopeStrategy {
        protected ClassifiersBuildScopeStrategy() {
        }

        @Override
        public List<List<EObject>> buildScope(EObject contextElement) {
            ElementImport eImport;
            ArrayList<List<EObject>> nestedScopes = new ArrayList<List<EObject>>();
            List<Object> nestedList = new ArrayList<EObject>();
            Package potentialContextPackage = null;
            if (contextElement instanceof Package) {
                potentialContextPackage = (Package)contextElement;
            } else if (contextElement instanceof ElementImport && (eImport = (ElementImport)contextElement).getImportedElement() instanceof Package) {
                potentialContextPackage = (Package)eImport.getImportedElement();
            }
            if (potentialContextPackage != null) {
                List<EObject> importedClassifiers = this.processPublicallyImportedClassifiers(potentialContextPackage);
                importedClassifiers = AlfScopingTool.removeDuplicateClassifiers(importedClassifiers);
                nestedScopes.add(importedClassifiers);
                return nestedScopes;
            }
            Classifier contextClassifier = AlfJavaValidator.getContextClassifier();
            nestedList.add(contextClassifier);
            for (PackageImport i : contextClassifier.getPackageImports()) {
                Package importedPackage = i.getImportedPackage();
                nestedList.addAll(this.processPublicallyImportedClassifiers(importedPackage));
            }
            for (PackageImport i : contextClassifier.getElementImports()) {
                PackageableElement e = i.getImportedElement();
                if (!(e instanceof Classifier)) continue;
                if (i.getAlias() != null) {
                    nestedList.add((EObject)i);
                    continue;
                }
                nestedList.add(e);
            }
            nestedList = AlfScopingTool.removeDuplicateClassifiers(nestedList);
            nestedScopes.add(nestedList);
            nestedList = new ArrayList();
            if (AlfJavaValidator.getAlfStandardLibrary() != null) {
                List<EObject> importedClassifiers = this.processPublicallyImportedClassifiers(AlfJavaValidator.getAlfStandardLibrary());
                importedClassifiers.add((EObject)TypeUtils._Collection.extractActualType());
                importedClassifiers.add((EObject)TypeUtils._Set.extractActualType());
                importedClassifiers.add((EObject)TypeUtils._Bag.extractActualType());
                importedClassifiers.add((EObject)TypeUtils._Queue.extractActualType());
                importedClassifiers.add((EObject)TypeUtils._OrderedSet.extractActualType());
                importedClassifiers.add((EObject)TypeUtils._List.extractActualType());
                importedClassifiers.add((EObject)TypeUtils._Deque.extractActualType());
                importedClassifiers.add((EObject)TypeUtils._Map.extractActualType());
                nestedList.addAll(AlfScopingTool.removeDuplicateClassifiers(importedClassifiers));
                nestedScopes.add(nestedList);
            }
            nestedList = new ArrayList();
            Namespace namespaceOfContextClassifier = contextClassifier.getNamespace();
            for (Element e : namespaceOfContextClassifier.getOwnedElements()) {
                if (!(e instanceof Classifier) || e == contextClassifier) continue;
                nestedList.add(e);
            }
            nestedScopes.add(nestedList);
            return nestedScopes;
        }

        private List<EObject> processPublicallyImportedClassifiers(Package p) {
            ArrayList<EObject> importedClassifiers = new ArrayList<EObject>();
            for (NamedElement n : p.getOwnedMembers()) {
                if (!(n instanceof Classifier) || ((Classifier)n).getVisibility() == VisibilityKind.PRIVATE_LITERAL) continue;
                importedClassifiers.add((EObject)n);
            }
            for (ElementImport eImport : p.getElementImports()) {
                PackageableElement element;
                if (eImport.getVisibility() == VisibilityKind.PRIVATE_LITERAL || !((element = eImport.getImportedElement()) instanceof Classifier)) continue;
                if (eImport.getAlias() != null) {
                    importedClassifiers.add((EObject)eImport);
                    continue;
                }
                importedClassifiers.add((EObject)element);
            }
            for (PackageImport pImport : p.getPackageImports()) {
                if (pImport.getVisibility() == VisibilityKind.PRIVATE_LITERAL) continue;
                importedClassifiers.addAll(this.processPublicallyImportedClassifiers(pImport.getImportedPackage()));
            }
            return importedClassifiers;
        }
    }

    protected class ClassifiersNameStrategy
    implements AlfPartialScope.IGetNameStrategy {
        protected ClassifiersNameStrategy() {
        }

        public String getName(EObject element) {
            if (element instanceof Classifier) {
                return ((Classifier)element).getName();
            }
            if (element instanceof ElementImport) {
                ElementImport imported = (ElementImport)element;
                return imported.getAlias() != null ? imported.getAlias() : ((Classifier)imported.getImportedElement()).getName();
            }
            return "Unexpected element kind...";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class EnumerationLiteralBuildScopeStrategy
    implements AlfPartialScope.IBuildScopeStrategy {
        protected EnumerationLiteralBuildScopeStrategy() {
        }

        @Override
        public List<List<EObject>> buildScope(EObject contextElement) {
            ArrayList<List<EObject>> nestedScopes = new ArrayList<List<EObject>>();
            ArrayList<EnumerationLiteral> nestedList = new ArrayList<EnumerationLiteral>();
            if (!(contextElement instanceof Enumeration)) {
                nestedScopes.add(nestedList);
                return nestedScopes;
            }
            Enumeration contextEnumeration = (Enumeration)contextElement;
            nestedList.addAll((Collection<EnumerationLiteral>)contextEnumeration.getOwnedLiterals());
            nestedScopes.add(nestedList);
            ArrayList currentGenerals = new ArrayList();
            currentGenerals.addAll(contextEnumeration.getGenerals());
            while (!currentGenerals.isEmpty()) {
                ArrayList nextGenerals = new ArrayList();
                nestedList = new ArrayList();
                for (Classifier general : currentGenerals) {
                    nextGenerals.addAll(general.getGenerals());
                    if (!(general instanceof Enumeration)) continue;
                    for (EnumerationLiteral enumLiteral : ((Enumeration)general).getOwnedLiterals()) {
                        nestedList.add(enumLiteral);
                    }
                }
                nestedScopes.add(nestedList);
                currentGenerals = nextGenerals;
            }
            return nestedScopes;
        }
    }

    protected class EnumerationLiteralNameStrategy
    implements AlfPartialScope.IGetNameStrategy {
        protected EnumerationLiteralNameStrategy() {
        }

        public String getName(EObject element) {
            if (element instanceof EnumerationLiteral) {
                return ((EnumerationLiteral)element).getName();
            }
            return "Unexpected element kind...";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class OperationAndBehaviorBuildScopeStrategy
    implements AlfPartialScope.IBuildScopeStrategy {
        protected OperationAndBehaviorBuildScopeStrategy() {
        }

        @Override
        public List<List<EObject>> buildScope(EObject contextElement) {
            ElementImport eImport;
            ArrayList<List<EObject>> nestedScopes = new ArrayList<List<EObject>>();
            ArrayList<Object> nestedList = new ArrayList<Object>();
            Package potentialContextPackage = null;
            if (contextElement instanceof Package) {
                potentialContextPackage = (Package)contextElement;
            } else if (contextElement instanceof ElementImport && (eImport = (ElementImport)contextElement).getImportedElement() instanceof Package) {
                potentialContextPackage = (Package)eImport.getImportedElement();
            }
            if (potentialContextPackage != null) {
                AlfPartialScope behaviorScope = AlfScopeProvider.scopingTool.getVisibleBehaviors(contextElement);
                for (List<EObject> scope : behaviorScope.getScopeDetails()) {
                    nestedScopes.add(scope);
                }
                return nestedScopes;
            }
            Classifier contextClassifier = contextElement instanceof Classifier ? (Classifier)contextElement : (contextElement instanceof ElementImport && ((ElementImport)contextElement).getImportedElement() instanceof Classifier ? (Classifier)((ElementImport)contextElement).getImportedElement() : AlfJavaValidator.getContextClassifier());
            nestedList.addAll((Collection<Object>)contextClassifier.getOperations());
            if (contextClassifier instanceof Class) {
                nestedList.addAll((Collection<Object>)((Class)contextClassifier).getOwnedReceptions());
            }
            nestedScopes.add(nestedList);
            ArrayList currentGenerals = new ArrayList();
            currentGenerals.addAll(contextClassifier.getGenerals());
            while (!currentGenerals.isEmpty()) {
                ArrayList nextGenerals = new ArrayList();
                nestedList = new ArrayList();
                for (Classifier general : currentGenerals) {
                    nextGenerals.addAll(general.getGenerals());
                    for (Operation o : general.getOperations()) {
                        nestedList.add(o);
                    }
                    if (!(general instanceof Class)) continue;
                    for (Reception r : ((Class)general).getOwnedReceptions()) {
                        nestedList.add(r);
                    }
                }
                nestedScopes.add(nestedList);
                currentGenerals = nextGenerals;
            }
            if (!(contextElement instanceof Classifier || contextElement instanceof ElementImport && ((ElementImport)contextElement).getImportedElement() instanceof Classifier)) {
                AlfPartialScope behaviorScope = AlfScopeProvider.scopingTool.getVisibleBehaviors(contextElement);
                for (List<EObject> scope : behaviorScope.getScopeDetails()) {
                    nestedScopes.add(scope);
                }
            }
            return nestedScopes;
        }
    }

    protected class OperationAndBehaviorNameStrategy
    implements AlfPartialScope.IGetNameStrategy {
        protected OperationAndBehaviorNameStrategy() {
        }

        public String getName(EObject element) {
            if (element instanceof Operation) {
                return ((Operation)element).getName();
            }
            if (element instanceof Behavior) {
                return ((Behavior)element).getName();
            }
            if (element instanceof ElementImport) {
                ElementImport eImport = (ElementImport)element;
                if (eImport.getAlias() != null) {
                    return eImport.getAlias();
                }
                return ((Behavior)eImport.getImportedElement()).getName();
            }
            if (element instanceof Reception) {
                return ((Reception)element).getName();
            }
            return "Unexpected element kind...";
        }
    }

    protected class PackageNameStrategy
    implements AlfPartialScope.IGetNameStrategy {
        protected PackageNameStrategy() {
        }

        public String getName(EObject element) {
            if (element instanceof Namespace) {
                return ((Namespace)element).getName();
            }
            if (element instanceof ElementImport) {
                ElementImport eImport = (ElementImport)element;
                return eImport.getAlias() != null ? eImport.getAlias() : eImport.getImportedElement().getName();
            }
            return "Unexpected element kind...";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class PackagesBuildScopeStrategy
    implements AlfPartialScope.IBuildScopeStrategy {
        protected PackagesBuildScopeStrategy() {
        }

        @Override
        public List<List<EObject>> buildScope(EObject contextElement) {
            ArrayList<List<EObject>> nestedScopes = new ArrayList<List<EObject>>();
            ArrayList<Object> nestedList = new ArrayList<Object>();
            if (contextElement instanceof Package) {
                nestedScopes.add(this.processPublicallyImportedPackages((Namespace)((Package)contextElement)));
                return nestedScopes;
            }
            Package root = (Package)AlfJavaValidator.getModel();
            Classifier contextClassifier = AlfJavaValidator.getContextClassifier();
            nestedList.addAll(this.processPublicallyImportedPackages((Namespace)contextClassifier));
            nestedScopes.add(nestedList);
            nestedList = new ArrayList();
            if (AlfJavaValidator.getAlfStandardLibrary() != null) {
                nestedList.add(AlfJavaValidator.getAlfStandardLibrary());
                nestedList.addAll(this.processPublicallyImportedPackages((Namespace)AlfJavaValidator.getAlfStandardLibrary()));
                nestedScopes.add(nestedList);
            }
            nestedList = new ArrayList();
            nestedList.add(root);
            nestedScopes.add(nestedList);
            return nestedScopes;
        }

        protected List<EObject> processPublicallyImportedPackages(Namespace namespace) {
            ArrayList<EObject> importedPackages = new ArrayList<EObject>();
            for (NamedElement ownedMember : namespace.getOwnedMembers()) {
                if (ownedMember.getVisibility() == VisibilityKind.PRIVATE_LITERAL || !(ownedMember instanceof Package)) continue;
                importedPackages.add((EObject)ownedMember);
            }
            for (ElementImport eImport : namespace.getElementImports()) {
                PackageableElement importedElement;
                if (eImport.getVisibility() == VisibilityKind.PRIVATE_LITERAL || !((importedElement = eImport.getImportedElement()) instanceof Package)) continue;
                if (eImport.getAlias() != null) {
                    importedPackages.add((EObject)eImport);
                    continue;
                }
                importedPackages.add((EObject)importedElement);
            }
            for (PackageImport pImport : namespace.getPackageImports()) {
                if (pImport.getVisibility() == VisibilityKind.PRIVATE_LITERAL) continue;
                importedPackages.addAll(this.processPublicallyImportedPackages((Namespace)pImport.getImportedPackage()));
            }
            return importedPackages;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ReceptionsBuildScopeStrategy
    implements AlfPartialScope.IBuildScopeStrategy {
        protected ReceptionsBuildScopeStrategy() {
        }

        @Override
        public List<List<EObject>> buildScope(EObject contextElement) {
            ArrayList<List<EObject>> nestedScopes = new ArrayList<List<EObject>>();
            ArrayList<Signal> nestedList = new ArrayList<Signal>();
            Classifier contextClassifier = AlfJavaValidator.getContextClassifier();
            if (!(contextClassifier instanceof Class)) {
                nestedScopes.add(nestedList);
                return nestedScopes;
            }
            for (Feature f : contextClassifier.allFeatures()) {
                if (!(f instanceof Reception) || ((Reception)f).getSignal() == null) continue;
                nestedList.add(((Reception)f).getSignal());
            }
            nestedScopes.add(nestedList);
            return nestedScopes;
        }
    }

    protected class ReceptionsNameStrategy
    implements AlfPartialScope.IGetNameStrategy {
        protected ReceptionsNameStrategy() {
        }

        public String getName(EObject element) {
            if (element instanceof Signal) {
                return ((Signal)element).getName();
            }
            return "Unexpected element kind...";
        }
    }

    protected class VariableOrParameterOrPropertyNameStrategy
    implements AlfPartialScope.IGetNameStrategy {
        protected VariableOrParameterOrPropertyNameStrategy() {
        }

        public String getName(EObject element) {
            if (element instanceof Property) {
                return ((Property)element).getName();
            }
            if (element instanceof LocalNameDeclarationStatement) {
                return ((LocalNameDeclarationStatement)element).getVarName();
            }
            if (element instanceof InvocationOrAssignementOrDeclarationStatement) {
                InvocationOrAssignementOrDeclarationStatement statement = (InvocationOrAssignementOrDeclarationStatement)element;
                return statement.getVariableDeclarationCompletion() != null ? statement.getVariableDeclarationCompletion().getVariableName() : "";
            }
            if (element instanceof LoopVariableDefinition) {
                return ((LoopVariableDefinition)element).getName();
            }
            if (element instanceof AcceptClause) {
                return ((AcceptClause)element).getName();
            }
            if (element instanceof AcceptStatement) {
                return ((AcceptStatement)element).getClause().getName();
            }
            if (element instanceof SequenceExpansionExpression) {
                SequenceExpansionExpression expression = (SequenceExpansionExpression)element;
                return expression.getName() != null ? expression.getName() : "";
            }
            return "unexpected kind ...";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class VariableOrPropertyOrParameterBuildScopeStrategy
    implements AlfPartialScope.IBuildScopeStrategy {
        protected VariableOrPropertyOrParameterBuildScopeStrategy() {
        }

        @Override
        public abstract List<List<EObject>> buildScope(EObject var1);

        public boolean containsALocalNameDeclaration(DocumentedStatement previousDocumentStatement) {
            Statement cddDclStatement;
            Statement statement = previousDocumentStatement.getStatement();
            if (statement instanceof LocalNameDeclarationStatement) {
                return true;
            }
            if (statement instanceof InvocationOrAssignementOrDeclarationStatement && (cddDclStatement = (InvocationOrAssignementOrDeclarationStatement)statement).getVariableDeclarationCompletion() != null) {
                return true;
            }
            return statement instanceof AcceptStatement && (cddDclStatement = (AcceptStatement)statement).getSimpleAccept() != null && cddDclStatement.getClause().getName() != null;
        }
    }
}

