/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.alf.validation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.uml.alf.validation.typing.SignatureFacade;
import org.eclipse.papyrus.uml.alf.validation.typing.SignatureFacadeFactory;
import org.eclipse.papyrus.uml.alf.validation.typing.TypeExpressionFactory;
import org.eclipse.papyrus.uml.alf.validation.typing.TypeFacade;
import org.eclipse.papyrus.uml.alf.validation.typing.TypeFacadeFactory;
import org.eclipse.papyrus.uml.alf.validation.typing.TypeUtils;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PredefinedBehaviorsAndTypesUtils {
    private Map<String, List<SignatureFacade>> behaviorMap = new HashMap<String, List<SignatureFacade>>();
    private Map<String, TypeFacade> typeMap = new HashMap<String, TypeFacade>();
    private List<Behavior> behaviorInsertedAsElementImport = new ArrayList<Behavior>();
    private List<Classifier> classifierInsertedAsElementImport = new ArrayList<Classifier>();

    public void init(Package library) {
        this.behaviorMap = new HashMap<String, List<SignatureFacade>>();
        this.typeMap = new HashMap<String, TypeFacade>();
        this.behaviorInsertedAsElementImport = new ArrayList<Behavior>();
        this.classifierInsertedAsElementImport = new ArrayList<Classifier>();
        TypeUtils.predefinedCollectionFunctions = new HashMap<String, SignatureFacade>();
        this.localInit(library);
        TypeUtils._bitString = this.typeMap.get("BitString");
        TypeUtils._boolean = this.typeMap.get("Boolean");
        TypeUtils._integer = this.typeMap.get("Integer");
        TypeUtils._natural = this.typeMap.get("Natural");
        TypeUtils._string = this.typeMap.get("String");
        TypeUtils._undefined = new TypeFacade();
        TypeUtils._unlimited = this.typeMap.get("UnlimitedNatural");
        TypeUtils._nullExpression = TypeExpressionFactory.eInstance.createTypeExpression(TypeUtils._undefined);
        TypeUtils._Collection = this.typeMap.get("Collection");
        TypeUtils._Set = this.typeMap.get("Set");
        TypeUtils._Bag = this.typeMap.get("Bag");
        TypeUtils._Queue = this.typeMap.get("Queue");
        TypeUtils._OrderedSet = this.typeMap.get("OrderedSet");
        TypeUtils._List = this.typeMap.get("List");
        TypeUtils._Deque = this.typeMap.get("Deque");
        TypeUtils._Map = this.typeMap.get("Map");
        TypeUtils._Entry = this.typeMap.get("Entry");
    }

    private void localInit(Package library) {
        if (library.getQualifiedName().equals("Alf::Library::CollectionFunctions")) {
            this.initCollectionFunctions(library);
        }
        for (NamedElement n : library.getOwnedMembers()) {
            if (n instanceof Behavior) {
                this.insertSignatureFacade(SignatureFacadeFactory.eInstance.createSignatureFacade((EObject)n));
                continue;
            }
            if (n instanceof Classifier) {
                this.insertTypeFacade(TypeFacadeFactory.eInstance.createTypeFacade((EObject)n));
                continue;
            }
            if (!(n instanceof Package)) continue;
            this.localInit((Package)n);
        }
        for (ElementImport eImport : library.getElementImports()) {
            if (eImport.getImportedElement() instanceof Behavior) {
                this.insertSignatureFacade(new SignatureFacade((EObject)eImport));
                this.behaviorInsertedAsElementImport.add((Behavior)eImport.getImportedElement());
                continue;
            }
            if (eImport.getImportedElement() instanceof Classifier) {
                this.insertTypeFacade(TypeFacadeFactory.eInstance.createTypeFacade((EObject)eImport));
                this.classifierInsertedAsElementImport.add((Classifier)eImport.getImportedElement());
                continue;
            }
            if (!(eImport.getImportedElement() instanceof Package)) continue;
            this.localInit((Package)eImport.getImportedElement());
        }
        for (PackageImport pImport : library.getPackageImports()) {
            this.localInit(pImport.getImportedPackage());
        }
        TypeUtils._Collection = this.typeMap.get("Collection");
        TypeUtils._Set = this.typeMap.get("Set");
        TypeUtils._Bag = this.typeMap.get("Bag");
        TypeUtils._Queue = this.typeMap.get("Queue");
        TypeUtils._OrderedSet = this.typeMap.get("OrderedSet");
        TypeUtils._List = this.typeMap.get("List");
        TypeUtils._Deque = this.typeMap.get("Deque");
        TypeUtils._Map = this.typeMap.get("Map");
        TypeUtils._Entry = this.typeMap.get("Entry");
    }

    private void initCollectionFunctions(Package library) {
        SignatureFacade s;
        for (NamedElement element : library.getOwnedMembers()) {
            if (!(element instanceof Behavior)) continue;
            s = SignatureFacadeFactory.eInstance.createSignatureFacade((EObject)element);
            TypeUtils.predefinedCollectionFunctions.put(s.getName(), s);
        }
        for (ElementImport eImport : library.getElementImports()) {
            if (!(eImport.getImportedElement() instanceof Behavior)) continue;
            s = SignatureFacadeFactory.eInstance.createSignatureFacade((EObject)eImport);
            TypeUtils.predefinedCollectionFunctions.put(eImport.getAlias() == null || eImport.getAlias().length() == 0 ? s.getName() : eImport.getAlias(), s);
        }
    }

    public List<SignatureFacade> getSignatures(String name) {
        return this.behaviorMap.get(name);
    }

    public TypeFacade getClassifier(String name) {
        return this.typeMap.get(name);
    }

    private void insertSignatureFacade(SignatureFacade s) {
        for (Behavior b : this.behaviorInsertedAsElementImport) {
            if (!s.equals(b)) continue;
            return;
        }
        List<SignatureFacade> l = this.behaviorMap.get(s.getName());
        if (l == null) {
            l = new ArrayList<SignatureFacade>();
            this.behaviorMap.put(s.getName(), l);
        }
        l.add(s);
    }

    private void insertTypeFacade(TypeFacade t) {
        for (Classifier c : this.classifierInsertedAsElementImport) {
            if (!t.equals(c)) continue;
            return;
        }
        if (this.typeMap.get(t.getLabel()) == null) {
            this.typeMap.put(t.getLabel(), t);
        }
    }
}

