/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.appearance.commands;

import java.util.StringTokenizer;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.emf.commands.CreateEAnnotationCommand;
import org.eclipse.papyrus.uml.appearance.helper.AppliedStereotypeHelper;

public class RemoveAppliedStereotypeToDisplayCommand
extends CreateEAnnotationCommand {
    private String stereotypeList;
    private String appliedStereotypePresentationKind;

    public RemoveAppliedStereotypeToDisplayCommand(TransactionalEditingDomain domain, EModelElement object, String stereotypeList, String appliedStereotypepresentationKind) {
        super(domain, object, "Stereotype_Annotation");
        this.stereotypeList = stereotypeList;
        this.appliedStereotypePresentationKind = appliedStereotypepresentationKind;
    }

    protected void doExecute() {
        String stereoList = AppliedStereotypeHelper.getStereotypesToDisplay(this.getObject());
        StringTokenizer appliedStereotypeToken = new StringTokenizer(this.stereotypeList, ",");
        while (appliedStereotypeToken.hasMoreElements()) {
            String token = appliedStereotypeToken.nextToken();
            stereoList = stereoList.replaceAll("," + token.trim(), "");
            stereoList = stereoList.replaceAll(token.trim(), "");
        }
        String stereoListQN = AppliedStereotypeHelper.getStereotypesQNToDisplay(this.getObject());
        appliedStereotypeToken = new StringTokenizer(this.stereotypeList, ",");
        while (appliedStereotypeToken.hasMoreElements()) {
            String token = appliedStereotypeToken.nextToken();
            stereoListQN = stereoListQN.replaceAll("," + token.trim(), "");
            stereoListQN = stereoListQN.replaceAll(token.trim(), "");
        }
        EAnnotation oldAnnotation = this.getObject().getEAnnotation("Stereotype_Annotation");
        if (oldAnnotation == null) {
            oldAnnotation = this.createEAnnotation();
            this.attachEannotation(oldAnnotation, this.getObject());
        }
        this.replaceEntry(oldAnnotation, "StereotypeWithQualifiedNameList", stereoListQN);
        this.replaceEntry(oldAnnotation, "StereotypeList", stereoList);
        this.replaceEntry(oldAnnotation, "Stereotype_Presentation_Kind", this.appliedStereotypePresentationKind);
        this.replaceEntry(oldAnnotation, "PropStereoDisplay", AppliedStereotypeHelper.getAppliedStereotypesPropertiesToDisplay(this.getObject()));
        this.replaceEntry(oldAnnotation, "StereotypePropertyLocation", AppliedStereotypeHelper.getAppliedStereotypesPropertiesLocalization(this.getObject()));
        this.replaceEannotation(this.getObject().getEAnnotation("Stereotype_Annotation"), this.getObject());
    }
}

