/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.controlmode.profile.helpers;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.ProfileApplication;

public class ProfileApplicationHelper {
    public static final String DUPLICATED_PROFILE = "duplicatedProfile";

    public static void duplicateProfileApplication(Package _package, Profile profile) {
        if (profile != null && profile.getDefinition() != null && !ProfileApplicationHelper.isSameProfileApplied(_package, profile)) {
            _package.applyProfile(profile);
            ProfileApplication profileAppl = _package.getProfileApplication(profile);
            if (profileAppl != null) {
                ProfileApplicationHelper.markAsDuplicate(profileAppl);
            }
        }
    }

    public static void removeProfileApplicationDuplication(Package _package, Profile profile, boolean force) {
        ProfileApplication profileAppl;
        if (profile != null && profile.getDefinition() != null && ProfileApplicationHelper.isSameProfileApplied(_package, profile) && ProfileApplicationHelper.isDuplicatedProfileApplication(profileAppl = _package.getProfileApplication(profile)) && (force || ProfileApplicationHelper.getParentPackageWithProfile(_package, profile, false) == null)) {
            profileAppl.getEAnnotations().remove((Object)profileAppl.getEAnnotation(DUPLICATED_PROFILE));
            _package.unapplyProfile(profile);
        }
    }

    private static boolean isSameProfileApplied(Package _package, Profile profile) {
        for (Profile prof : _package.getAppliedProfiles()) {
            if (prof == null) break;
            if (prof.equals(profile)) {
                return true;
            }
            if (profile.getQualifiedName() == null || !profile.getQualifiedName().equals(prof.getQualifiedName())) continue;
            return true;
        }
        return false;
    }

    public static void relocateStereotypeApplications(Package pack, Resource target) {
        TreeIterator i = EcoreUtil.getAllProperContents((EObject)pack, (boolean)false);
        while (i.hasNext()) {
            Element element;
            EList stereotypeApplications;
            EObject current = (EObject)i.next();
            if (!(current instanceof Element) || (stereotypeApplications = (element = (Element)current).getStereotypeApplications()).isEmpty()) continue;
            for (EObject e : stereotypeApplications) {
                int size = target.getContents().size();
                target.getContents().add(size, (Object)e);
            }
        }
    }

    public static boolean isDuplicatedProfileApplication(ProfileApplication profileAppl) {
        return profileAppl.getEAnnotation(DUPLICATED_PROFILE) != null;
    }

    public static Package getParentPackageWithProfile(Package packageElement, Profile profile, boolean notControlledOnly) {
        if (profile != null && profile.getDefinition() != null) {
            Element parent = packageElement.getOwner();
            while (parent != null) {
                Package parentPackage;
                if (parent instanceof Package && ProfileApplicationHelper.isSameProfileApplied(parentPackage = (Package)parent, profile) && (!notControlledOnly || !AdapterFactoryEditingDomain.isControlled((Object)parentPackage))) {
                    return parentPackage;
                }
                parent = parent.getOwner();
            }
        }
        return null;
    }

    public static void markAsDuplicate(ProfileApplication profileAppl) {
        profileAppl.createEAnnotation(DUPLICATED_PROFILE);
    }
}

