/*****************************************************************************
 * Copyright (c) 2009 Atos Origin.
 *
 *    
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Atos Origin - Initial API and implementation
 *
 *****************************************************************************/
package org.eclipse.papyrus.uml.diagram.activity.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.papyrus.uml.diagram.activity.edit.dialogs.CreatePinsForObjectFlowDialog;
import org.eclipse.papyrus.uml.diagram.activity.edit.helpers.ObjectFlowEditHelper;
import org.eclipse.papyrus.uml.diagram.activity.edit.policies.UMLBaseItemSemanticEditPolicy;
import org.eclipse.papyrus.uml.diagram.activity.providers.ElementInitializers;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.ObjectFlow;
import org.eclipse.uml2.uml.UMLFactory;

/**
 * @generated
 */
public class ObjectFlowCreateCommand extends EditElementCommand {

	/**
	 * @generated NOT removed the final to allow pin creation
	 */
	private EObject source;

	/**
	 * @generated NOT removed the final to allow pin creation
	 */
	private EObject target;

	/**
	 * @generated
	 */
	protected Activity container;

	/**
	 * @generated
	 */
	public ObjectFlowCreateCommand(CreateRelationshipRequest request, EObject source, EObject target) {
		super(request.getLabel(), null, request);
		this.source = source;
		this.target = target;
		container = deduceContainer(source, target);
	}

	/**
	 * @generated
	 */
	public boolean canExecute() {
		if(source == null && target == null) {
			return false;
		}
		if(source != null && false == source instanceof ActivityNode) {
			return false;
		}
		if(target != null && false == target instanceof ActivityNode) {
			return false;
		}
		if(getSource() == null) {
			return true; // link creation is in progress; source is not defined yet
		}
		// target may be null here but it's possible to check constraint
		if(getContainer() == null) {
			return false;
		}
		return UMLBaseItemSemanticEditPolicy.getLinkConstraints().canCreateObjectFlow_4003(getContainer(), getSource(), getTarget());
	}

	/**
	 * @generated NOT handling addition of pins when creating an object flow on actions
	 */
	protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
		if(!canExecute()) {
			throw new ExecutionException("Invalid arguments in create link command"); //$NON-NLS-1$
		}
		// arrange source and target to add pins if there is an opaque action
		if(ObjectFlowEditHelper.insertPinForStartingNewObjectFlow(getSource()) || ObjectFlowEditHelper.insertPinForEndingNewObjectFlow(getTarget())) {
			CreatePinsForObjectFlowDialog dialog = new CreatePinsForObjectFlowDialog(Display.getDefault().getActiveShell(), getSource(), getTarget());
			if(IDialogConstants.OK_ID == dialog.open()) {
				// replace adequate source and target
				source = dialog.getSource();
				target = dialog.getTarget();
			} else {
				return CommandResult.newCancelledCommandResult();
			}
		}
		ObjectFlow newElement = UMLFactory.eINSTANCE.createObjectFlow();
		getContainer().getEdges().add(newElement);
		newElement.setSource(getSource());
		newElement.setTarget(getTarget());
		ElementInitializers.getInstance().init_ObjectFlow_4003(newElement);
		doConfigure(newElement, monitor, info);
		((CreateElementRequest)getRequest()).setNewElement(newElement);
		return CommandResult.newOKCommandResult(newElement);
	}

	/**
	 * @generated
	 */
	protected void doConfigure(ObjectFlow newElement, IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
		IElementType elementType = ((CreateElementRequest)getRequest()).getElementType();
		ConfigureRequest configureRequest = new ConfigureRequest(getEditingDomain(), newElement, elementType);
		configureRequest.setClientContext(((CreateElementRequest)getRequest()).getClientContext());
		configureRequest.addParameters(getRequest().getParameters());
		configureRequest.setParameter(CreateRelationshipRequest.SOURCE, getSource());
		configureRequest.setParameter(CreateRelationshipRequest.TARGET, getTarget());
		ICommand configureCommand = elementType.getEditCommand(configureRequest);
		if(configureCommand != null && configureCommand.canExecute()) {
			configureCommand.execute(monitor, info);
		}
	}

	/**
	 * @generated
	 */
	protected void setElementToEdit(EObject element) {
		throw new UnsupportedOperationException();
	}

	/**
	 * @generated
	 */
	protected ActivityNode getSource() {
		return (ActivityNode)source;
	}

	/**
	 * @generated
	 */
	protected ActivityNode getTarget() {
		return (ActivityNode)target;
	}

	/**
	 * @generated
	 */
	public Activity getContainer() {
		return container;
	}

	/**
	 * Default approach is to traverse ancestors of the source to find instance of container.
	 * Modify with appropriate logic.
	 * 
	 * @generated
	 */
	protected Activity deduceContainer(EObject source, EObject target) {
		// Find container element for the new link.
		// Climb up by containment hierarchy starting from the source
		// and return the first element that is instance of the container class.
		for(EObject element = source; element != null; element = element.eContainer()) {
			if(element instanceof Activity) {
				return (Activity)element;
			}
		}
		return null;
	}
}
