/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.edit.dialogs;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.uml.diagram.activity.edit.dialogs.CreateParameterDialog;
import org.eclipse.papyrus.uml.diagram.activity.part.Messages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.uml2.common.util.CacheAdapter;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;

public class WarningAndCreateParameterDialog
extends MessageDialog {
    private static final String CREATE_LABEL = Messages.CreateParameterDialog_Open;
    private static final String START_FORM = "<form>";
    private static final String END_FORM = "</form>";
    private static final String LIST_FORMAT = "<li>%s</li>";
    private static final String LT = "<";
    private static final String ESC_LT = "&lt;";
    private static final String GT = ">";
    private static final String ESC_GT = "&gt;";
    private NamedElement parameterOwner = null;
    private ParameterDirectionKind defaultDirection;
    private Parameter parameter = null;
    private ILabelProvider provider = null;

    public WarningAndCreateParameterDialog(Shell parentShell, String dialogTitle, String dialogMessage, NamedElement linkElement, ILabelProvider labelProvider, ParameterDirectionKind preferredDirection) {
        super(parentShell, dialogTitle, null, dialogMessage, 4, new String[]{CREATE_LABEL, IDialogConstants.CLOSE_LABEL}, 0);
        this.parameterOwner = linkElement;
        this.defaultDirection = preferredDirection;
        this.provider = labelProvider;
    }

    protected Control createCustomArea(Composite parent) {
        Control result = super.createCustomArea(parent);
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        FormText text = toolkit.createFormText(parent, false);
        text.setText(this.getImpactedElementsText(), true, false);
        text.setBackground(parent.getBackground());
        text.setLayoutData((Object)new GridData(1808));
        return result;
    }

    private String getImpactedElementsText() {
        StringBuffer completeText = new StringBuffer();
        completeText.append(START_FORM);
        StringBuffer impactText = new StringBuffer();
        Collection references = CacheAdapter.INSTANCE.getNonNavigableInverseReferences((EObject)this.parameterOwner);
        HashSet<EObject> impactedElements = new HashSet<EObject>();
        for (EStructuralFeature.Setting ref : references) {
            String qualifiedName;
            EObject referencing = ref.getEObject();
            if (referencing.eContainer() == null || referencing instanceof View || impactedElements.contains(referencing)) continue;
            impactedElements.add(referencing);
            String elementText = this.provider.getText((Object)referencing);
            elementText = elementText.replaceAll(LT, ESC_LT).replaceAll(GT, ESC_GT);
            if (referencing instanceof NamedElement && (qualifiedName = ((NamedElement)referencing).getQualifiedName()) != null && qualifiedName.length() != 0) {
                elementText = String.valueOf(elementText) + " (" + qualifiedName + ")";
            }
            impactText.append(String.format(LIST_FORMAT, elementText));
        }
        if (impactedElements.size() <= 1) {
            completeText.append(Messages.CreateParameterDialog_WarnNoImpact);
        } else {
            completeText.append(Messages.CreateParameterDialog_WarnImpact);
            completeText.append(impactText.toString());
        }
        completeText.append(END_FORM);
        return completeText.toString();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            CreateParameterDialog dialog = new CreateParameterDialog(this.getShell(), this.parameterOwner, this.defaultDirection);
            if (dialog.open() == 0) {
                this.parameter = dialog.getCreatedParameter();
                super.buttonPressed(buttonId);
            }
        } else {
            super.buttonPressed(buttonId);
        }
    }

    public Parameter getParameter() {
        return this.parameter;
    }
}

