/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.edit.policies;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CreateCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.LabelEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.ActionLocalPostconditionEditPart;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.ActionLocalPreconditionEditPart;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.ObjectFlowEditPart;
import org.eclipse.papyrus.uml.diagram.activity.helper.ActivityLinkMappingHelper;
import org.eclipse.papyrus.uml.diagram.activity.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.activity.providers.UMLElementTypes;
import org.eclipse.papyrus.uml.diagram.common.commands.CommonDeferredCreateConnectionViewCommand;
import org.eclipse.papyrus.uml.diagram.common.commands.SemanticAdapter;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.OldCommonDiagramDragDropEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.groups.core.utils.Utils;
import org.eclipse.papyrus.uml.diagram.common.helper.ILinkMappingHelper;
import org.eclipse.papyrus.uml.diagram.common.util.DiagramEditPartsUtil;
import org.eclipse.uml2.uml.Action;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ObjectFlow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomDiagramDragDropEditPolicy
extends OldCommonDiagramDragDropEditPolicy {
    private static final String LABEL = "DropLocalConditions";
    private static final Point LOCAL_CONDITIONS_TRANSLATION_POINT = new Point(160, 0);

    public CustomDiagramDragDropEditPolicy() {
        super((ILinkMappingHelper)ActivityLinkMappingHelper.getInstance());
    }

    protected Set<Integer> getDroppableElementVisualId() {
        HashSet<Integer> droppableElementsVisualID = new HashSet<Integer>();
        droppableElementsVisualID.add(3007);
        droppableElementsVisualID.add(3008);
        droppableElementsVisualID.add(3010);
        droppableElementsVisualID.add(3036);
        droppableElementsVisualID.add(3037);
        droppableElementsVisualID.add(3034);
        droppableElementsVisualID.add(3035);
        droppableElementsVisualID.add(3032);
        droppableElementsVisualID.add(3033);
        droppableElementsVisualID.add(3011);
        droppableElementsVisualID.add(3012);
        droppableElementsVisualID.add(4003);
        droppableElementsVisualID.add(4004);
        droppableElementsVisualID.add(3076);
        droppableElementsVisualID.add(3081);
        return droppableElementsVisualID;
    }

    public IElementType getUMLElementType(int elementID) {
        return UMLElementTypes.getElementType(elementID);
    }

    protected Command getDropCommand(ChangeBoundsRequest request) {
        if (Utils.isRequestGroupFrameworkConcerned((ChangeBoundsRequest)request)) {
            return null;
        }
        return super.getDropCommand(request);
    }

    public int getNodeVisualID(View containerView, EObject domainElement) {
        return UMLVisualIDRegistry.getNodeVisualID(containerView, domainElement);
    }

    public int getLinkWithClassVisualID(EObject domainElement) {
        return UMLVisualIDRegistry.getLinkWithClassVisualID(domainElement);
    }

    protected Command getSpecificDropCommand(DropObjectsRequest dropRequest, Element semanticElement, int nodeVISUALID, int linkVISUALID) {
        switch (nodeVISUALID) {
            case 3007: 
            case 3008: 
            case 3010: 
            case 3076: 
            case 3081: {
                return this.dropAction(dropRequest, semanticElement, nodeVISUALID);
            }
            case 3011: 
            case 3012: 
            case 3032: 
            case 3033: 
            case 3034: 
            case 3035: 
            case 3036: 
            case 3037: {
                return this.dropActionLocalCondition(dropRequest, semanticElement, nodeVISUALID);
            }
        }
        switch (linkVISUALID) {
            case 4003: 
            case 4004: {
                return this.dropActivityEdge(dropRequest, semanticElement, linkVISUALID);
            }
        }
        return super.getSpecificDropCommand(dropRequest, semanticElement, nodeVISUALID, linkVISUALID);
    }

    protected Command dropAction(DropObjectsRequest dropRequest, Element semanticElement, int nodeVISUALID) {
        Object cmd;
        CompoundCommand globalCmd = new CompoundCommand();
        if (globalCmd.isEmpty()) {
            cmd = this.getDefaultDropNodeCommand(nodeVISUALID, dropRequest.getLocation(), (EObject)semanticElement);
            globalCmd.add((Command)new ICommandProxy((ICommand)cmd));
        }
        cmd = new DropActionLocalConditionsAfterActionCommand(dropRequest, semanticElement);
        globalCmd.add((Command)cmd);
        return globalCmd;
    }

    protected Command dropActionLocalCondition(DropObjectsRequest dropRequest, Element semanticElement, int nodeVISUALID) {
        if (this.getHost() instanceof GraphicalEditPart) {
            Point location = dropRequest.getLocation().getCopy();
            ((GraphicalEditPart)this.getHost()).getContentPane().translateToRelative((Translatable)location);
            ((GraphicalEditPart)this.getHost()).getContentPane().translateFromParent((Translatable)location);
            location.translate(((GraphicalEditPart)this.getHost()).getContentPane().getClientArea().getLocation().getNegated());
            location.y += 100;
            EObject graphicalParent = ((GraphicalEditPart)this.getHost()).resolveSemanticElement();
            if (graphicalParent instanceof Activity) {
                Element linkSource = semanticElement.getOwner();
                Element linkTarget = semanticElement;
                for (Object targetView : DiagramEditPartsUtil.getEObjectViews((EObject)linkTarget)) {
                    EditPart targetEditpart;
                    if (!(targetView instanceof View) || !((targetEditpart = DiagramEditPartsUtil.getEditPartFromView((View)((View)targetView), (EditPart)this.getHost())) instanceof ActionLocalPreconditionEditPart) && !(targetEditpart instanceof ActionLocalPostconditionEditPart)) continue;
                    return UnexecutableCommand.INSTANCE;
                }
                if (3036 == nodeVISUALID || 3034 == nodeVISUALID || 3032 == nodeVISUALID || 3011 == nodeVISUALID) {
                    return new ICommandProxy((ICommand)this.dropBinaryLink(new CompositeCommand("drop Local Precondition link"), linkSource, linkTarget, 4001, location, semanticElement));
                }
                if (3037 == nodeVISUALID || 3035 == nodeVISUALID || 3033 == nodeVISUALID || 3012 == nodeVISUALID) {
                    return new ICommandProxy((ICommand)this.dropBinaryLink(new CompositeCommand("drop Local Postcondition link"), linkSource, linkTarget, 4002, location, semanticElement));
                }
            }
        }
        return UnexecutableCommand.INSTANCE;
    }

    public CompositeCommand dropObjectFlowSpecification(CompositeCommand cc, ObjectFlow source, Behavior target, int linkVISUALID, int specificationVISUALID, Point location, Element semanticLink) {
        ObjectFlowEditPart sourceEditPart = this.lookForEdgePart((EObject)source);
        Object targetEditPart = null;
        CreateConnectionViewRequest.ConnectionViewDescriptor linkdescriptor = new CreateConnectionViewRequest.ConnectionViewDescriptor((IAdaptable)this.getUMLElementType(linkVISUALID), ((IHintedType)this.getUMLElementType(linkVISUALID)).getSemanticHint(), this.getDiagramPreferencesHint());
        SemanticAdapter sourceAdapter = null;
        SemanticAdapter targetAdapter = null;
        if (sourceEditPart == null) {
            CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)new EObjectAdapter((EObject)source), Edge.class, null, -1, false, ((IGraphicalEditPart)this.getHost()).getDiagramPreferencesHint());
            CreateCommand nodeCreationCommand = new CreateCommand(((IGraphicalEditPart)this.getHost()).getEditingDomain(), descriptor, (View)this.getHost().getModel());
            cc.compose((IUndoableOperation)nodeCreationCommand);
            SetBoundsCommand setBoundsCommand = new SetBoundsCommand(this.getEditingDomain(), "move", (IAdaptable)nodeCreationCommand.getCommandResult().getReturnValue(), new Point(location.x, location.y + 100));
            cc.compose((IUndoableOperation)setBoundsCommand);
            sourceAdapter = (IAdaptable)nodeCreationCommand.getCommandResult().getReturnValue();
        } else {
            sourceAdapter = new SemanticAdapter(null, sourceEditPart.getModel());
        }
        if (targetEditPart == null) {
            String nodeSemanticHint = ((IHintedType)this.getUMLElementType(specificationVISUALID)).getSemanticHint();
            CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)new EObjectAdapter((EObject)target), Node.class, nodeSemanticHint, -1, false, ((IGraphicalEditPart)this.getHost()).getDiagramPreferencesHint());
            CreateCommand nodeCreationCommand = new CreateCommand(((IGraphicalEditPart)this.getHost()).getEditingDomain(), descriptor, (View)this.getHost().getModel());
            cc.compose((IUndoableOperation)nodeCreationCommand);
            SetBoundsCommand setBoundsCommand = new SetBoundsCommand(this.getEditingDomain(), "move", (IAdaptable)nodeCreationCommand.getCommandResult().getReturnValue(), new Point(location.x, location.y - 100));
            cc.compose((IUndoableOperation)setBoundsCommand);
            targetAdapter = (IAdaptable)nodeCreationCommand.getCommandResult().getReturnValue();
        } else {
            targetAdapter = new SemanticAdapter(null, targetEditPart.getModel());
        }
        CommonDeferredCreateConnectionViewCommand aLinkCommand = new CommonDeferredCreateConnectionViewCommand(this.getEditingDomain(), ((IHintedType)this.getUMLElementType(linkVISUALID)).getSemanticHint(), (IAdaptable)sourceAdapter, (IAdaptable)targetAdapter, this.getViewer(), this.getDiagramPreferencesHint(), linkdescriptor, null);
        aLinkCommand.setElement((EObject)semanticLink);
        cc.compose((IUndoableOperation)aLinkCommand);
        return cc;
    }

    private ObjectFlowEditPart lookForEdgePart(EObject semantic) {
        Collection editPartSet = this.getHost().getViewer().getEditPartRegistry().values();
        Iterator editPartIterator = editPartSet.iterator();
        ObjectFlowEditPart existedEditPart = null;
        while (editPartIterator.hasNext() && existedEditPart == null) {
            EditPart currentEditPart = (EditPart)editPartIterator.next();
            if (!(currentEditPart instanceof ObjectFlowEditPart) || !semantic.equals(((ObjectFlowEditPart)currentEditPart).resolveSemanticElement())) continue;
            existedEditPart = (ObjectFlowEditPart)currentEditPart;
        }
        return existedEditPart;
    }

    protected Command dropActivityEdge(DropObjectsRequest dropRequest, Element semanticLink, int linkVISUALID) {
        Collection<?> sources = ActivityLinkMappingHelper.getInstance().getSource(semanticLink);
        Collection<?> targets = ActivityLinkMappingHelper.getInstance().getTarget(semanticLink);
        if (sources.size() == 1 && targets.size() == 1) {
            ActivityNode source = (ActivityNode)sources.toArray()[0];
            ActivityNode target = (ActivityNode)targets.toArray()[0];
            return new ICommandProxy((ICommand)this.dropBinaryLink(new CompositeCommand("drop Activity Edge"), (Element)source, (Element)target, linkVISUALID, dropRequest.getLocation(), semanticLink));
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected boolean isEditPartTypeSuitableForEClass(Class<? extends GraphicalEditPart> editPartClass, EClass eClass) {
        return !LabelEditPart.class.isAssignableFrom(editPartClass);
    }

    private class DropActionLocalConditionsAfterActionCommand
    extends Command {
        private DropObjectsRequest request;
        private Element droppedAction;
        private List<Command> executedCommands;

        public DropActionLocalConditionsAfterActionCommand(DropObjectsRequest dropRequest, Element action) {
            super(CustomDiagramDragDropEditPolicy.LABEL);
            this.executedCommands = new LinkedList<Command>();
            this.request = dropRequest;
            this.droppedAction = action;
        }

        public boolean canExecute() {
            return true;
        }

        public void execute() {
            Object hostView = CustomDiagramDragDropEditPolicy.this.getHost().getModel();
            if (hostView instanceof View && this.droppedAction instanceof Action) {
                Command localCmd;
                int visual;
                Point initialLocation = this.request.getLocation().getCopy();
                for (Constraint pre : ((Action)this.droppedAction).getLocalPreconditions()) {
                    localCmd = CustomDiagramDragDropEditPolicy.this.dropActionLocalCondition(this.request, (Element)pre, visual = UMLVisualIDRegistry.getNodeVisualID((View)hostView, (EObject)pre));
                    if (localCmd == null || !localCmd.canExecute()) continue;
                    localCmd.execute();
                    this.executedCommands.add(localCmd);
                    this.request.getLocation().translate(LOCAL_CONDITIONS_TRANSLATION_POINT);
                }
                for (Constraint post : ((Action)this.droppedAction).getLocalPostconditions()) {
                    localCmd = CustomDiagramDragDropEditPolicy.this.dropActionLocalCondition(this.request, (Element)post, visual = UMLVisualIDRegistry.getNodeVisualID((View)hostView, (EObject)post));
                    if (localCmd == null || !localCmd.canExecute()) continue;
                    localCmd.execute();
                    this.executedCommands.add(localCmd);
                    this.request.getLocation().translate(LOCAL_CONDITIONS_TRANSLATION_POINT);
                }
                this.request.getLocation().setLocation(initialLocation);
            }
        }

        public void undo() {
            int i = this.executedCommands.size() - 1;
            while (i >= 0) {
                Command cmd = this.executedCommands.get(i);
                cmd.undo();
                --i;
            }
            this.executedCommands.clear();
        }
    }
}

