/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.parser.custom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.ui.services.parser.ISemanticParser;
import org.eclipse.papyrus.uml.diagram.activity.parsers.MessageFormatParser;
import org.eclipse.papyrus.uml.diagram.common.commands.SetValueSpecificationValueCommand;
import org.eclipse.papyrus.uml.tools.utils.ValueSpecificationUtil;
import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EdgeGuardParser
extends MessageFormatParser
implements ISemanticParser {
    private static final String GUARD_FORMAT = "[%s]";

    public EdgeGuardParser(EAttribute[] features, EAttribute[] editableFeatures) {
        super(features, editableFeatures);
    }

    public EdgeGuardParser(EAttribute[] features) {
        super(features);
    }

    public EdgeGuardParser() {
        super(new EAttribute[]{UMLPackage.eINSTANCE.getNamedElement_Name()});
    }

    protected EStructuralFeature getEStructuralFeature(Object notification) {
        Object feature;
        EStructuralFeature featureImpl = null;
        if (notification instanceof Notification && (feature = ((Notification)notification).getFeature()) instanceof EStructuralFeature) {
            featureImpl = (EStructuralFeature)feature;
        }
        return featureImpl;
    }

    @Override
    public boolean isAffectingEvent(Object event, int flags) {
        EStructuralFeature feature = this.getEStructuralFeature(event);
        return this.isValidFeature(feature);
    }

    @Override
    public String getEditString(IAdaptable adapter, int flags) {
        String value = this.getValueString(adapter, flags);
        if (value != null) {
            return value;
        }
        return "";
    }

    @Override
    public ICommand getParseCommand(IAdaptable adapter, String newString, int flags) {
        ActivityEdge edge;
        ValueSpecification valueSpec;
        Object obj = adapter.getAdapter(EObject.class);
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((Object)obj);
        if (editingDomain == null) {
            return UnexecutableCommand.INSTANCE;
        }
        if (obj instanceof ActivityEdge && (valueSpec = (edge = (ActivityEdge)obj).getGuard()) != null) {
            CompositeTransactionalCommand command = new CompositeTransactionalCommand(editingDomain, "Set Values");
            command.compose((IUndoableOperation)new CommandProxy((Command)new SetValueSpecificationValueCommand(valueSpec, newString)));
            return command;
        }
        return UnexecutableCommand.INSTANCE;
    }

    @Override
    public String getPrintString(IAdaptable element, int flags) {
        String label = this.getValueString(element, flags);
        label = label == null || label.length() == 0 ? " " : String.format(GUARD_FORMAT, label);
        return label;
    }

    private String getValueString(IAdaptable element, int flags) {
        String value;
        ActivityEdge edge;
        ValueSpecification valueSpec;
        Object obj = element.getAdapter(EObject.class);
        if (obj instanceof ActivityEdge && (valueSpec = (edge = (ActivityEdge)obj).getGuard()) != null && (value = ValueSpecificationUtil.getSpecificationValue((ValueSpecification)valueSpec)) != null) {
            return value;
        }
        return "";
    }

    public boolean areSemanticElementsAffected(EObject listener, Object notification) {
        EStructuralFeature feature = this.getEStructuralFeature(notification);
        return this.isValidFeature(feature);
    }

    public List<?> getSemanticElementsBeingParsed(EObject element) {
        ArrayList<Object> semanticElementsBeingParsed = new ArrayList<Object>();
        if (element instanceof ActivityEdge) {
            ActivityEdge edge = (ActivityEdge)element;
            semanticElementsBeingParsed.add(edge);
            if (edge.getGuard() != null) {
                semanticElementsBeingParsed.add(edge.getGuard());
            }
        }
        return semanticElementsBeingParsed;
    }

    private boolean isValidFeature(EStructuralFeature feature) {
        return UMLPackage.eINSTANCE.getActivityEdge_Guard().equals(feature) || ValueSpecification.class.isAssignableFrom(feature.getContainerClass());
    }
}

