/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.clazz.custom.command;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.clazz.custom.helper.MultiAssociationHelper;
import org.eclipse.papyrus.uml.diagram.clazz.edit.commands.AssociationBranchReorientCommand;
import org.eclipse.papyrus.uml.diagram.clazz.edit.policies.UMLBaseItemSemanticEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.helper.AssociationHelper;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;

public class CustomAssociationBranchReorientCommand
extends AssociationBranchReorientCommand {
    private EObject oldNamedElementEnd;
    private EObject newNamedElementEnd;
    protected View connection = null;

    public CustomAssociationBranchReorientCommand(ReorientRelationshipRequest request) {
        super(request);
        this.oldNamedElementEnd = request.getOldRelationshipEnd();
        this.newNamedElementEnd = request.getNewRelationshipEnd();
        this.connection = (View)request.getParameters().get("graphical_edge");
    }

    protected boolean canReorientSource() {
        return false;
    }

    protected boolean canReorientTarget() {
        if (!(this.oldNamedElementEnd instanceof Type) || !(this.newNamedElementEnd instanceof Type)) {
            return false;
        }
        if (this.getLink().getEndTypes().size() < 1) {
            return false;
        }
        Type source = (Type)this.getLink().getEndTypes().get(0);
        if (!(this.getLink().eContainer() instanceof Package)) {
            return false;
        }
        Package container = (Package)this.getLink().eContainer();
        return UMLBaseItemSemanticEditPolicy.getLinkConstraints().canExistAssociation_4019(container, this.getLink(), source, this.getNewTarget());
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        int i = 0;
        Property end = null;
        if (MultiAssociationHelper.getSemanticBranchEnd(this.connection) != null) {
            end = MultiAssociationHelper.getSemanticBranchEnd(this.connection);
            i = this.getLink().getMemberEnds().indexOf((Object)end);
        } else {
            end = (Property)this.getLink().getMemberEnds().get(i);
            while (!end.getType().equals(this.getOldTarget())) {
                end = (Property)this.getLink().getMemberEnds().get(++i);
            }
        }
        return AssociationHelper.reconnect((int)i, (Association)this.getLink(), (Type)this.getNewTarget());
    }
}

