/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.clazz.custom.policies;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IPrimaryEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.clazz.custom.helper.AssociationClassHelper;
import org.eclipse.papyrus.uml.diagram.clazz.custom.helper.ClassLinkMappingHelper;
import org.eclipse.papyrus.uml.diagram.clazz.custom.helper.ContainmentHelper;
import org.eclipse.papyrus.uml.diagram.clazz.custom.helper.InstanceSpecificationLinkHelper;
import org.eclipse.papyrus.uml.diagram.clazz.custom.helper.MultiAssociationHelper;
import org.eclipse.papyrus.uml.diagram.clazz.custom.helper.MultiDependencyHelper;
import org.eclipse.papyrus.uml.diagram.clazz.edit.parts.RedefinableTemplateSignatureEditPart;
import org.eclipse.papyrus.uml.diagram.clazz.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.clazz.providers.UMLElementTypes;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.OldCommonDiagramDragDropEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.helper.ILinkMappingHelper;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.AssociationClass;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.PackageableElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassDiagramDragDropEditPolicy
extends OldCommonDiagramDragDropEditPolicy {
    public static final String CONTAINED_CLASS_DROP_TO_COMPARTMENT = "ContainedClassDropToCompartment";

    public ClassDiagramDragDropEditPolicy() {
        super((ILinkMappingHelper)ClassLinkMappingHelper.getInstance());
    }

    protected Set<Integer> getDroppableElementVisualId() {
        HashSet<Integer> droppableElementsVisualID = new HashSet<Integer>();
        droppableElementsVisualID.add(2014);
        droppableElementsVisualID.add(4001);
        droppableElementsVisualID.add(2013);
        droppableElementsVisualID.add(2015);
        droppableElementsVisualID.add(3014);
        droppableElementsVisualID.add(3010);
        droppableElementsVisualID.add(3009);
        droppableElementsVisualID.add(3024);
        droppableElementsVisualID.add(2005);
        droppableElementsVisualID.add(2008);
        droppableElementsVisualID.add(2007);
        droppableElementsVisualID.add(2001);
        droppableElementsVisualID.add(4021);
        return droppableElementsVisualID;
    }

    protected Command getSpecificDropCommand(DropObjectsRequest dropRequest, Element semanticLink, int nodeVISUALID, int linkVISUALID) {
        if (nodeVISUALID == 3017) {
            return new ICommandProxy((ICommand)this.getDefaultDropNodeCommand(nodeVISUALID, dropRequest.getLocation(), (EObject)semanticLink));
        }
        if (nodeVISUALID == 2001 || linkVISUALID == 4021) {
            return this.dropInstanceSpecification(dropRequest, semanticLink, linkVISUALID);
        }
        if (linkVISUALID == 4004) {
            return this.dropAsNormalBinaryLink(dropRequest, semanticLink, linkVISUALID);
        }
        if (linkVISUALID == 4003) {
            return this.dropAsNormalBinaryLink(dropRequest, semanticLink, linkVISUALID);
        }
        if (linkVISUALID == 4001) {
            return this.dropAssociation(dropRequest, semanticLink, linkVISUALID);
        }
        switch (nodeVISUALID) {
            case 2014: {
                return this.dropDependency(dropRequest, semanticLink, nodeVISUALID);
            }
            case 2013: {
                return this.dropAssociationClass(dropRequest, semanticLink, nodeVISUALID);
            }
            case 2015: {
                return this.dropAssociation(dropRequest, semanticLink, nodeVISUALID);
            }
            case 3009: 
            case 3010: 
            case 3014: 
            case 3024: {
                return this.dropChildNodeWithContainmentLink(dropRequest, semanticLink, nodeVISUALID);
            }
            case 2005: 
            case 2007: 
            case 2008: {
                return this.dropTopLevelNodeWithContainmentLink(dropRequest, semanticLink, nodeVISUALID);
            }
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command dropInstanceSpecification(DropObjectsRequest dropRequest, Element semanticLink, int linkVISUALID) {
        if (semanticLink instanceof InstanceSpecification) {
            ArrayList<InstanceSpecification> endTypes;
            if (((InstanceSpecification)semanticLink).getClassifiers().size() > 0 && ((InstanceSpecification)semanticLink).getClassifiers().get(0) instanceof Association && (endTypes = InstanceSpecificationLinkHelper.getEnds((InstanceSpecification)semanticLink)).size() > 0) {
                Element source = (Element)endTypes.get(0);
                Element target = (Element)endTypes.get(1);
                return new ICommandProxy((ICommand)this.dropBinaryLink(new CompositeCommand("drop Instance"), source, target, 4021, dropRequest.getLocation(), semanticLink));
            }
            EObject graphicalParent = ((GraphicalEditPart)this.getHost()).resolveSemanticElement();
            if (this.getHost().getModel() instanceof Diagram) {
                return new ICommandProxy((ICommand)this.getDefaultDropNodeCommand(2001, dropRequest.getLocation(), (EObject)semanticLink));
            }
            if (graphicalParent instanceof Element && ((Element)graphicalParent).getOwnedElements().contains((Object)semanticLink)) {
                return new ICommandProxy((ICommand)this.getDefaultDropNodeCommand(3020, dropRequest.getLocation(), (EObject)semanticLink));
            }
        }
        return UnexecutableCommand.INSTANCE;
    }

    public int getLinkWithClassVisualID(EObject domainElement) {
        return UMLVisualIDRegistry.getLinkWithClassVisualID(domainElement);
    }

    public int getNodeVisualID(View containerView, EObject domainElement) {
        return UMLVisualIDRegistry.getNodeVisualID(containerView, domainElement);
    }

    public IElementType getUMLElementType(int elementID) {
        return UMLElementTypes.getElementType(elementID);
    }

    protected Command dropAssociation(DropObjectsRequest dropRequest, Element semanticLink, int nodeVISUALID) {
        Collection<?> endtypes = ClassLinkMappingHelper.getInstance().getSource(semanticLink);
        if (endtypes.size() == 1) {
            Element source = (Element)endtypes.toArray()[0];
            Element target = (Element)endtypes.toArray()[0];
            return new ICommandProxy((ICommand)this.dropBinaryLink(new CompositeCommand("drop Association"), source, target, 4001, dropRequest.getLocation(), semanticLink));
        }
        if (endtypes.size() == 2) {
            Element source = (Element)endtypes.toArray()[0];
            Element target = (Element)endtypes.toArray()[1];
            return new ICommandProxy((ICommand)this.dropBinaryLink(new CompositeCommand("drop Association"), source, target, 4001, dropRequest.getLocation(), semanticLink));
        }
        if (endtypes.size() > 2) {
            MultiAssociationHelper associationHelper = new MultiAssociationHelper(this.getEditingDomain());
            return associationHelper.dropMutliAssociation((Association)semanticLink, this.getViewer(), this.getDiagramPreferencesHint(), dropRequest.getLocation(), ((GraphicalEditPart)this.getHost()).getNotationView());
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command dropAssociationClass(DropObjectsRequest dropRequest, Element semanticLink, int nodeVISUALID) {
        AssociationClassHelper associationClassHelper = new AssociationClassHelper(this.getEditingDomain());
        return associationClassHelper.dropAssociationClass((AssociationClass)semanticLink, this.getViewer(), this.getDiagramPreferencesHint(), dropRequest.getLocation(), ((GraphicalEditPart)this.getHost()).getNotationView());
    }

    protected Command dropDependency(DropObjectsRequest dropRequest, Element semanticLink, int nodeVISUALID) {
        Collection<?> sources = ClassLinkMappingHelper.getInstance().getSource(semanticLink);
        Collection<?> targets = ClassLinkMappingHelper.getInstance().getTarget(semanticLink);
        if (sources.size() == 1 && targets.size() == 1) {
            Element source = (Element)sources.toArray()[0];
            Element target = (Element)targets.toArray()[0];
            return new ICommandProxy((ICommand)this.dropBinaryLink(new CompositeCommand("drop Association"), source, target, 4008, dropRequest.getLocation(), semanticLink));
        }
        if (sources.size() > 1 || targets.size() > 1) {
            MultiDependencyHelper dependencyHelper = new MultiDependencyHelper(this.getEditingDomain());
            return dependencyHelper.dropMutliDependency((Dependency)semanticLink, this.getViewer(), this.getDiagramPreferencesHint(), dropRequest.getLocation(), ((GraphicalEditPart)this.getHost()).getNotationView());
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command dropTopLevelNodeWithContainmentLink(DropObjectsRequest dropRequest, Element semanticObject, int nodeVISUALID) {
        ContainmentHelper containmentHelper = new ContainmentHelper(this.getEditingDomain());
        Element owner = semanticObject.getOwner();
        if (owner == null) {
            return new ICommandProxy((ICommand)this.getDefaultDropNodeCommand(nodeVISUALID, dropRequest.getLocation(), (EObject)semanticObject));
        }
        EditPart ownerEditPart = containmentHelper.findEditPartFor(this.getViewer().getEditPartRegistry(), owner);
        if (ownerEditPart != null) {
            return containmentHelper.outlineDropContainedClass((PackageableElement)semanticObject, this.getViewer(), this.getDiagramPreferencesHint(), dropRequest.getLocation(), ((GraphicalEditPart)this.getHost()).getNotationView());
        }
        return new ICommandProxy((ICommand)this.getDefaultDropNodeCommand(nodeVISUALID, dropRequest.getLocation(), (EObject)semanticObject));
    }

    protected Command dropChildNodeWithContainmentLink(DropObjectsRequest dropRequest, Element droppedElement, int nodeVISUALID) {
        ContainmentHelper containmentHelper = new ContainmentHelper(this.getEditingDomain());
        CompositeCommand cc = new CompositeCommand(CONTAINED_CLASS_DROP_TO_COMPARTMENT);
        cc.add((IUndoableOperation)this.getDefaultDropNodeCommand(nodeVISUALID, dropRequest.getLocation(), (EObject)droppedElement));
        EObject graphicalParent = ((GraphicalEditPart)this.getHost()).resolveSemanticElement();
        if (!(droppedElement instanceof Element) || !((Element)graphicalParent).getOwnedElements().contains((Object)droppedElement)) {
            return UnexecutableCommand.INSTANCE;
        }
        if (containmentHelper.findEditPartFor(this.getViewer().getEditPartRegistry(), droppedElement) != null) {
            EditPart editpart = containmentHelper.findEditPartFor(this.getViewer().getEditPartRegistry(), droppedElement);
            View droppedView = (View)editpart.getModel();
            containmentHelper.deleteIncomingContainmentLinksFor(cc, droppedView);
            cc.add((IUndoableOperation)new DeleteCommand(this.getEditingDomain(), droppedView));
        }
        return new ICommandProxy((ICommand)cc);
    }

    protected Command dropAsNormalBinaryLink(DropObjectsRequest dropRequest, Element semanticLink, int linkVISUALID) {
        Collection sources = this.linkmappingHelper.getSource(semanticLink);
        Collection targets = this.linkmappingHelper.getTarget(semanticLink);
        if (sources.size() == 0 || targets.size() == 0) {
            return UnexecutableCommand.INSTANCE;
        }
        Element source = (Element)sources.toArray()[0];
        Element target = (Element)targets.toArray()[0];
        CompositeCommand cc = new CompositeCommand("");
        this.dropBinaryLink(cc, source, target, linkVISUALID, dropRequest.getLocation(), semanticLink);
        return new ICommandProxy((ICommand)cc);
    }

    protected Command getDropCommand(ChangeBoundsRequest request) {
        Iterator editPartsIter = request.getEditParts().iterator();
        while (editPartsIter.hasNext()) {
            if (!(editPartsIter.next() instanceof RedefinableTemplateSignatureEditPart)) continue;
            return UnexecutableCommand.INSTANCE;
        }
        editPartsIter = request.getEditParts().iterator();
        boolean containsLabelEditpart = false;
        while (editPartsIter.hasNext() && !containsLabelEditpart) {
            EditPart currentEditPart = (EditPart)editPartsIter.next();
            if (!(currentEditPart instanceof ITextAwareEditPart) || !(currentEditPart instanceof IPrimaryEditPart)) continue;
            containsLabelEditpart = true;
        }
        if (containsLabelEditpart && this.getHost() instanceof DiagramEditPart) {
            return UnexecutableCommand.INSTANCE;
        }
        ChangeBoundsRequest req = new ChangeBoundsRequest((Object)"add children");
        req.setEditParts(request.getEditParts());
        req.setMoveDelta(request.getMoveDelta());
        req.setSizeDelta(request.getSizeDelta());
        req.setLocation(request.getLocation());
        req.setResizeDirection(request.getResizeDirection());
        Command cmd = this.getHost().getCommand((Request)req);
        if (cmd == null || !cmd.canExecute()) {
            return this.getDropObjectsCommand(this.castToDropObjectsRequest(request));
        }
        return cmd;
    }
}

