/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.palette.customaction.providers;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.papyrus.uml.diagram.common.palette.customaction.control.ToolSelectionComposite;
import org.eclipse.papyrus.uml.diagram.common.palette.customaction.providers.ICreator;
import org.eclipse.papyrus.uml.diagram.common.palette.customaction.providers.ITool;
import org.eclipse.papyrus.uml.diagram.common.palette.customaction.providers.Tool;
import org.eclipse.papyrus.uml.diagram.common.palette.customaction.utils.ICallback;
import org.eclipse.papyrus.uml.diagram.common.service.palette.IAspectActionProvider;
import org.eclipse.papyrus.uml.diagram.common.service.palette.IFeatureSetterAspectAction;
import org.eclipse.papyrus.uml.diagram.common.service.palette.IPaletteEntryProxy;
import org.eclipse.papyrus.uml.diagram.common.service.palette.ModelPostAction;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.uml2.uml.Profile;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolAspectAction
extends ModelPostAction
implements ICallback<Tool>,
IFeatureSetterAspectAction {
    public static final String SELECTED_WIZARD = "AspectPredefinedTool";
    private static Collection<Tool> allTools;
    private ToolSelectionComposite mainComposite;
    private Tool selection;
    private Node node;

    static {
        ToolAspectAction.initAllWizards();
    }

    private static void initAllWizards() {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.papyrus.uml.diagram.common.palette.customaction", SELECTED_WIZARD);
        allTools = new ArrayList<Tool>(elements.length);
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            Tool tool = new Tool();
            tool.setId(e.getAttribute("id"));
            tool.setName(e.getAttribute("name"));
            tool.setDescription(e.getAttribute("description"));
            try {
                tool.setCreator((ICreator)e.createExecutableExtension("instance"));
            }
            catch (CoreException e1) {
                e1.printStackTrace();
            }
            allTools.add(tool);
            ++n2;
        }
    }

    public void init(Node configurationNode, IAspectActionProvider factory) {
        super.init(configurationNode, factory);
        if (configurationNode != null) {
            this.node = configurationNode;
            this.selection = ToolSelectionComposite.getTool(configurationNode);
        }
    }

    public Control createConfigurationComposite(Composite parent, IPaletteEntryProxy entryProxy, List<Profile> appliedProfiles) {
        this.mainComposite = new ToolSelectionComposite(parent, entryProxy, 2048, this);
        if (this.node != null && this.selection == null) {
            this.mainComposite.setSelection(this.node);
        } else if (this.selection != null) {
            this.mainComposite.setSelection(this.selection);
        }
        return this.mainComposite;
    }

    public void save(Node parentNode) {
        if (parentNode instanceof Element && this.selection != null) {
            Attr att = parentNode.getOwnerDocument().createAttribute(SELECTED_WIZARD);
            att.setNodeValue(this.selection.getId());
            parentNode.getAttributes().setNamedItem(att);
        }
    }

    public void run(EditPart editPart) {
        ITool tool = this.selection.getCreator().create(editPart);
        tool.run(editPart);
    }

    public static Collection<Tool> getAllExtensions() {
        return allTools;
    }

    public static Tool getExtension(final String id) {
        ArrayList aList = Lists.newArrayList((Iterable)Iterables.filter(allTools, (Predicate)new Predicate<Tool>(){

            public boolean apply(Tool input) {
                return id != null && id.equals(input.getId());
            }
        }));
        return aList.isEmpty() ? null : (Tool)aList.get(0);
    }

    public static List<Tool> getFiltered(final IPaletteEntryProxy entryProxy, Collection<Tool> allExtensions) {
        return Lists.newArrayList((Iterable)Iterables.filter(allExtensions, (Predicate)new Predicate<Tool>(){

            public boolean apply(Tool input) {
                return input.isEnabled(entryProxy);
            }
        }));
    }

    @Override
    public void callBack(Tool object) {
        this.selection = object;
    }

    public EStructuralFeature[] getAllImpactedFeatures() {
        return this.selection == null ? new EStructuralFeature[]{} : this.selection.getAllImpactedFeatures();
    }
}

