/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.papyrus.infra.core.log.LogHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.OverlayVisibilityIcon;
import org.eclipse.papyrus.uml.diagram.common.providers.AlternativeUMLItemProviderAdapterFactory;
import org.eclipse.papyrus.uml.diagram.common.util.ColorManager;
import org.eclipse.papyrus.uml.diagram.common.util.FontManager;
import org.eclipse.papyrus.uml.tools.utils.ElementUtil;
import org.eclipse.papyrus.uml.tools.utils.ImageUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.VisibilityKind;
import org.eclipse.uml2.uml.edit.providers.UMLItemProviderAdapterFactory;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Activator
extends AbstractUIPlugin {
    public static final String ID = "org.eclipse.papyrus.uml.diagram.common";
    private static Activator plugin;
    public static LogHelper log;
    public static final String UML_VIS_ICONS_16x16 = "icons/obj16/";
    public static final String DEFAULT_IMAGE = "icons/papyrus/PapyrusLogo16x16.gif";
    protected static ColorManager colorManager;
    protected static FontManager fontManager;
    public static String ST_LEFT;
    public static String ST_RIGHT;
    public static final PreferencesHint DIAGRAM_PREFERENCES_HINT;
    private ComposedAdapterFactory adapterFactory;

    static {
        colorManager = null;
        fontManager = null;
        ST_LEFT = String.valueOf("\u00ab");
        ST_RIGHT = String.valueOf("\u00bb");
        DIAGRAM_PREFERENCES_HINT = new PreferencesHint(ID);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static ColorManager getColorManager() {
        if (colorManager == null) {
            colorManager = new ColorManager();
        }
        return colorManager;
    }

    public static FontManager getFontManager() {
        if (fontManager == null) {
            fontManager = new FontManager();
        }
        return fontManager;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)ID, (String)path);
    }

    public static Image getImage(String key) {
        return Activator.getImage(key, "");
    }

    public static Image getImage(String key, String visKey) {
        ImageRegistry registry;
        Image image;
        String image_id = key;
        if (!"".equals(visKey)) {
            image_id = String.valueOf(image_id) + "::" + visKey;
        }
        if ((image = (registry = Activator.getDefault().getImageRegistry()).get(image_id)) == null) {
            ImageDescriptor desc = AbstractUIPlugin.imageDescriptorFromPlugin((String)ID, (String)key);
            if (!"".equals(visKey)) {
                Image initialImage = desc.createImage();
                Activator.getDefault();
                ImageDescriptor visDesc = Activator.getImageDescriptor("icons/obj16/VisibilityKind_" + visKey + ".gif");
                OverlayVisibilityIcon overlayIcon = new OverlayVisibilityIcon(initialImage, visDesc);
                image = overlayIcon.getImage();
                registry.put(image_id, image);
            } else {
                registry.put(key, desc);
            }
            image = registry.get(image_id);
        }
        if (image == null && !image_id.equals(DEFAULT_IMAGE)) {
            image = Activator.getImage(DEFAULT_IMAGE);
        }
        return image;
    }

    public static Image getPluginIconImage(String pluginId, String iconPath) {
        String key = String.valueOf(pluginId) + iconPath;
        ImageRegistry registry = Activator.getDefault().getImageRegistry();
        Image image = registry.get(key);
        if (image == null) {
            ImageDescriptor desc = AbstractUIPlugin.imageDescriptorFromPlugin((String)pluginId, (String)iconPath);
            registry.put(key, desc);
            image = registry.get(key);
        }
        if (image == null && !iconPath.equals(DEFAULT_IMAGE)) {
            image = Activator.getImage(DEFAULT_IMAGE);
        }
        return image;
    }

    public static Image getPluginIconImage(String pluginId, ImageDescriptor descriptor) {
        String key = String.valueOf(pluginId) + descriptor;
        ImageRegistry registry = Activator.getDefault().getImageRegistry();
        Image image = registry.get(key);
        if (image == null) {
            registry.put(key, descriptor);
            image = registry.get(key);
        }
        return image;
    }

    public static Image getShapeElement(Element elt) {
        org.eclipse.uml2.uml.Image shape = ElementUtil.getStereotypeImage((Element)elt, (String)"shape");
        if (shape != null) {
            return Activator.getImageInRegistry(shape, null);
        }
        return null;
    }

    public static Image getIconElement(Element element) {
        return Activator.getIconElement(element, false);
    }

    public static Image getIconElement(Element element, boolean withVisibilityDecorator) {
        EList stereotypeList = element.getAppliedStereotypes();
        if (stereotypeList == null || stereotypeList.isEmpty()) {
            return null;
        }
        return Activator.getIconElement(element, (Stereotype)stereotypeList.get(0), withVisibilityDecorator);
    }

    public static Collection<Image> getIconElements(Element elt, Collection<Stereotype> stereotypes, boolean withVisibilityDecorator) {
        ArrayList<Image> images = new ArrayList<Image>();
        VisibilityKind vis = null;
        if (elt instanceof NamedElement && withVisibilityDecorator) {
            vis = ((NamedElement)elt).getVisibility();
        }
        for (Stereotype stereotype : stereotypes) {
            org.eclipse.uml2.uml.Image icon = ElementUtil.getStereotypeImage((Element)elt, (Stereotype)stereotype, (String)"icon");
            if (icon == null) continue;
            images.add(Activator.getImageInRegistry(icon, vis));
        }
        return images;
    }

    public static Image getIconElement(Element elt, Stereotype stereotype, boolean withVisibilityDecorator) {
        org.eclipse.uml2.uml.Image icon;
        VisibilityKind vis = null;
        if (elt instanceof NamedElement && withVisibilityDecorator) {
            vis = ((NamedElement)elt).getVisibility();
        }
        if ((icon = ElementUtil.getStereotypeImage((Element)elt, (Stereotype)stereotype, (String)"icon")) != null) {
            return Activator.getImageInRegistry(icon, vis);
        }
        return null;
    }

    public static Image getShape(Element elt, Stereotype stereotype, boolean withVisibilityDecorator) {
        org.eclipse.uml2.uml.Image icon;
        VisibilityKind vis = null;
        if (elt instanceof NamedElement && withVisibilityDecorator) {
            vis = ((NamedElement)elt).getVisibility();
        }
        if ((icon = ElementUtil.getStereotypeImage((Element)elt, (Stereotype)stereotype, (String)"shape")) != null) {
            return Activator.getImageInRegistry(icon, vis);
        }
        return null;
    }

    public static Image getImageInRegistry(org.eclipse.uml2.uml.Image umlImage, VisibilityKind visibility) {
        Image image;
        ImageRegistry papyrusRegistry = Activator.getDefault().getImageRegistry();
        String image_id = ImageUtil.getImageId((org.eclipse.uml2.uml.Image)umlImage);
        if (visibility != null) {
            image_id = String.valueOf(image_id) + "_" + visibility.getLiteral();
        }
        if ((image = papyrusRegistry.get(image_id)) == null) {
            try {
                image = ImageUtil.getContent((org.eclipse.uml2.uml.Image)umlImage);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (image == null) {
                image = ImageUtil.getImageFromLocation((org.eclipse.uml2.uml.Image)umlImage);
            }
            if (visibility != null) {
                Activator.getDefault();
                ImageDescriptor visDesc = Activator.getImageDescriptor("icons/obj16/VisibilityKind_" + visibility.getLiteral() + ".gif");
                OverlayVisibilityIcon overlayIcon = new OverlayVisibilityIcon(image, visDesc);
                image = overlayIcon.getImage();
            }
            if (image != null) {
                ImageData imdata = image.getImageData();
                papyrusRegistry.put(image_id, ImageDescriptor.createFromImageData((ImageData)imdata));
                image = papyrusRegistry.get(image_id);
            }
        }
        return image;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        PreferencesHint.registerPreferenceStore((PreferencesHint)DIAGRAM_PREFERENCES_HINT, (Object)this.getPreferenceStore());
        plugin = this;
        log = new LogHelper((Plugin)plugin);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        log = null;
        plugin = null;
    }

    public void logError(String error) {
        this.logError(error, null);
    }

    public void logError(String error, Throwable throwable) {
        if (error == null && throwable != null) {
            error = throwable.getMessage();
        }
        this.getLog().log((IStatus)new Status(4, ID, 0, error, throwable));
        this.debug(error, throwable);
    }

    public void logInfo(String message) {
        this.logInfo(message, null);
    }

    public void logInfo(String message, Throwable throwable) {
        if (message == null && throwable != null) {
            message = throwable.getMessage();
        }
        this.getLog().log((IStatus)new Status(1, ID, 0, message, throwable));
        this.debug(message, throwable);
    }

    public void logWarning(String warning, Throwable throwable) {
        if (warning == null && throwable != null) {
            warning = throwable.getMessage();
        }
        this.getLog().log((IStatus)new Status(2, ID, 0, warning, throwable));
    }

    private void debug(String message, Throwable throwable) {
        if (!this.isDebugging()) {
            return;
        }
        if (message != null) {
            System.err.println(message);
        }
        if (throwable != null) {
            throwable.printStackTrace();
        }
    }

    protected ComposedAdapterFactory createAdapterFactory() {
        ArrayList factories = new ArrayList();
        this.fillItemProviderFactories(factories);
        return new ComposedAdapterFactory(factories);
    }

    protected void fillItemProviderFactories(List factories) {
        factories.add(new AlternativeUMLItemProviderAdapterFactory(this.getPreferenceStore()));
        factories.add(new UMLItemProviderAdapterFactory());
        factories.add(new EcoreItemProviderAdapterFactory());
        factories.add(new ResourceItemProviderAdapterFactory());
        factories.add(new ReflectiveItemProviderAdapterFactory());
    }

    public AdapterFactory getItemProvidersAdapterFactory() {
        if (this.adapterFactory == null) {
            this.adapterFactory = this.createAdapterFactory();
        }
        return this.adapterFactory;
    }
}

