/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.editpolicies;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.DynamicEObjectImpl;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.uml.appearance.helper.AppliedStereotypeHelper;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.commands.CreateAppliedStereotypeViewCommand;
import org.eclipse.papyrus.uml.diagram.common.commands.SetNodeVisibilityCommand;
import org.eclipse.papyrus.uml.diagram.common.editparts.AppliedStereotypeConpartmentEditPart;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.AppliedStereotypeNodeLabelDisplayEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.figure.node.IPapyrusNodeUMLElementFigure;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.util.UMLUtil;

public class AppliedStereotypeCompartmentEditPolicy
extends AppliedStereotypeNodeLabelDisplayEditPolicy {
    public void activate() {
        super.activate();
        GraphicalEditPart editPart = (GraphicalEditPart)this.getHost();
        Element UMLEelement = (Element)editPart.resolveSemanticElement();
        for (EObject appliedstereotype : UMLEelement.getStereotypeApplications()) {
            this.createAppliedStereotypeCompartment(appliedstereotype);
        }
    }

    protected void executeAppliedStereotypeCompatmentCreation(final GraphicalEditPart editPart, final EObject appliedstereotype) {
        try {
            editPart.getEditingDomain().runExclusive(new Runnable(){

                public void run() {
                    Display.getCurrent().asyncExec(new Runnable(){

                        public void run() {
                            CreateAppliedStereotypeViewCommand command = new CreateAppliedStereotypeViewCommand(editPart.getEditingDomain(), editPart.getNotationView(), appliedstereotype);
                            editPart.getEditingDomain().getCommandStack().execute((Command)command);
                        }
                    });
                }
            });
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
        }
    }

    public void notifyChanged(Notification notification) {
        int eventType = notification.getEventType();
        if (eventType == 20) {
            this.getDiagramEventBroker().addNotificationListener((EObject)notification.getNewValue(), (NotificationListener)this);
            this.createAppliedStereotypeCompartment((EObject)notification.getNewValue());
        } else if (eventType == 21) {
            this.getDiagramEventBroker().removeNotificationListener((EObject)notification.getOldValue(), (NotificationListener)this);
            this.removeAppliedStereotypeCompartment((EObject)notification.getNewValue());
        }
        if (notification.getNotifier() instanceof Node && notification.getEventType() == 3 && notification.getNewValue() instanceof EAnnotation && "Stereotype_Annotation" == ((EAnnotation)notification.getNewValue()).getSource()) {
            this.refreshDisplay();
        }
    }

    public void createAppliedStereotypeCompartment(EObject stereotypeApplication) {
        GraphicalEditPart editPart = (GraphicalEditPart)this.getHost();
        View node = editPart.getNotationView();
        View correspondedAppliedStereotype = this.getCoresspondedStereotypeApplication(stereotypeApplication, node);
        if (correspondedAppliedStereotype == null) {
            this.executeAppliedStereotypeCompatmentCreation(editPart, stereotypeApplication);
        }
    }

    protected void setVisivility(final View view, final boolean isVisible) {
        try {
            final GraphicalEditPart editPart = (GraphicalEditPart)this.getHost();
            editPart.getEditingDomain().runExclusive(new Runnable(){

                public void run() {
                    Display.getCurrent().asyncExec(new Runnable(){

                        public void run() {
                            SetNodeVisibilityCommand setCommand = new SetNodeVisibilityCommand(editPart.getEditingDomain(), view, isVisible);
                            editPart.getEditingDomain().getCommandStack().execute((Command)setCommand);
                        }
                    });
                }
            });
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    protected View getCoresspondedStereotypeApplication(EObject stereotypeApplication, View node) {
        Node correspondedAppliedStereotype = null;
        int i = 0;
        while (correspondedAppliedStereotype == null && i < node.getChildren().size()) {
            if (node.getChildren().get(i) instanceof Node && stereotypeApplication.equals(((Node)node.getChildren().get(i)).getElement())) {
                correspondedAppliedStereotype = (Node)node.getChildren().get(i);
            }
            ++i;
        }
        return correspondedAppliedStereotype;
    }

    public void removeAppliedStereotypeCompartment(EObject stereotypeApplication) {
        if (stereotypeApplication == null) {
            return;
        }
        final GraphicalEditPart editPart = (GraphicalEditPart)this.getHost();
        View node = editPart.getNotationView();
        try {
            int i = 0;
            while (i < node.getChildren().size()) {
                if (node.getChildren().get(i) instanceof Node) {
                    final Node currentNode = (Node)node.getChildren().get(i);
                    if (stereotypeApplication.equals(currentNode.getElement())) {
                        editPart.getEditingDomain().runExclusive(new Runnable(){

                            public void run() {
                                Display.getCurrent().asyncExec(new Runnable(){

                                    public void run() {
                                        DeleteCommand command = new DeleteCommand((View)currentNode);
                                        editPart.getEditingDomain().getCommandStack().execute((Command)new GMFtoEMFCommandWrapper((ICommand)command));
                                    }
                                });
                            }
                        });
                    }
                    if (currentNode.getType().equals(AppliedStereotypeConpartmentEditPart.ID) && !(currentNode.getElement() instanceof DynamicEObjectImpl)) {
                        editPart.getEditingDomain().runExclusive(new Runnable(){

                            public void run() {
                                Display.getCurrent().asyncExec(new Runnable(){

                                    public void run() {
                                        DeleteCommand command = new DeleteCommand((View)currentNode);
                                        editPart.getEditingDomain().getCommandStack().execute((Command)new GMFtoEMFCommandWrapper((ICommand)command));
                                    }
                                });
                            }
                        });
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    protected void refreshAppliedStereotypesPropertiesInCompartment(String stereotypesPropertiesToDisplay, IPapyrusNodeUMLElementFigure figure) {
        boolean displayInCompartment = AppliedStereotypeHelper.hasAppliedStereotypesPropertiesToDisplay((EModelElement)((View)this.getHost().getModel()), (String)"Compartment");
        GraphicalEditPart editPart = (GraphicalEditPart)this.getHost();
        View node = editPart.getNotationView();
        int i = 0;
        while (i < node.getChildren().size()) {
            Node currentNode;
            if (node.getChildren().get(i) instanceof Node && (currentNode = (Node)node.getChildren().get(i)).getType().equals(AppliedStereotypeConpartmentEditPart.ID)) {
                EObject stereotypeApplication = currentNode.getElement();
                Stereotype stereotype = UMLUtil.getStereotype((EObject)stereotypeApplication);
                if (stereotype != null && stereotypesPropertiesToDisplay.contains(stereotype.getQualifiedName())) {
                    this.setVisivility((View)currentNode, displayInCompartment);
                } else {
                    this.setVisivility((View)currentNode, false);
                }
            }
            ++i;
        }
    }
}

