/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.helper;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.IMaskManagedLabelEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.helper.StereotypedElementLabelHelper;
import org.eclipse.papyrus.uml.tools.utils.PropertyUtil;
import org.eclipse.uml2.uml.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyLabelHelper
extends StereotypedElementLabelHelper {
    private static PropertyLabelHelper labelHelper;
    protected final Map<Integer, String> masks = new HashMap<Integer, String>(7);

    public static PropertyLabelHelper getInstance() {
        if (labelHelper == null) {
            labelHelper = new PropertyLabelHelper();
        }
        return labelHelper;
    }

    protected PropertyLabelHelper() {
        this.masks.put(2, "Visibility");
        this.masks.put(4, "Is Derived");
        this.masks.put(8, "Name");
        this.masks.put(16, "Type");
        this.masks.put(32, "Multiplicity");
        this.masks.put(64, "Default Value");
        this.masks.put(128, "Modifiers");
    }

    @Override
    protected String elementLabel(GraphicalEditPart editPart) {
        Property elem;
        int displayValue = 62;
        IMaskManagedLabelEditPolicy policy = (IMaskManagedLabelEditPolicy)editPart.getEditPolicy((Object)"MaskManagedLabelPolicy");
        if (policy != null) {
            displayValue = policy.getCurrentDisplayValue();
        }
        if ((elem = this.getUMLElement(editPart)) != null) {
            return PropertyUtil.getCustomLabel((Property)elem, (int)displayValue);
        }
        return "";
    }

    public String getMaskLabel(int value) {
        return this.masks.get(value);
    }

    public Collection<String> getMaskLabels() {
        return this.masks.values();
    }

    public Map<Integer, String> getMasks() {
        return this.masks;
    }

    public Set<Integer> getMaskValues() {
        return this.masks.keySet();
    }

    public Property getUMLElement(GraphicalEditPart editPart) {
        View view;
        if (editPart.getModel() instanceof View && (view = (View)editPart.getModel()).getElement() instanceof Property) {
            return (Property)view.getElement();
        }
        return null;
    }
}

