/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.layout;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.papyrus.uml.diagram.common.layout.DistributionConstants;
import org.eclipse.papyrus.uml.diagram.common.layout.EditPartRepresentation;
import org.eclipse.papyrus.uml.diagram.common.layout.LinkRepresentation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SameAlignment {
    private int alignment;
    private List<LinkRepresentation> linksRepresentation;
    private List<EditPartRepresentation> editpartRepresentation;

    public SameAlignment(int align) {
        this.alignment = align;
        this.linksRepresentation = new ArrayList<LinkRepresentation>();
        this.editpartRepresentation = new ArrayList<EditPartRepresentation>();
    }

    public Command getCommand() {
        Collections.sort(this.linksRepresentation, new LinkComparator());
        if (this.alignment == 4 || this.alignment == 32) {
            Collections.reverse(this.linksRepresentation);
        }
        this.removeBadSideLink();
        CompoundCommand cmd = new CompoundCommand("command for alignment");
        if (this.isCorrectSelection()) {
            for (LinkRepresentation currentLink : this.linksRepresentation) {
                Command tmp = currentLink.getCommand();
                if (tmp == null) continue;
                cmd.add(tmp);
            }
        }
        return cmd;
    }

    protected List<LinkRepresentation> getLinkFor(EditPartRepresentation epRepresentation) {
        ArrayList<LinkRepresentation> list = new ArrayList<LinkRepresentation>();
        for (LinkRepresentation link : this.linksRepresentation) {
            if (link.getSource() != epRepresentation && link.getTarget() != epRepresentation) continue;
            list.add(link);
        }
        return list;
    }

    protected boolean isCorrectSelection() {
        for (EditPartRepresentation current : this.editpartRepresentation) {
            if (this.getLinkFor(current).size() <= 2) continue;
            return false;
        }
        return true;
    }

    public void addTriplet(EditPart link, EditPartRepresentation sourceRep, EditPartRepresentation targetRep) {
        this.addEditPartRepresentation(sourceRep);
        this.addEditPartRepresentation(targetRep);
        this.linksRepresentation.add(new LinkRepresentation(link, sourceRep, targetRep, this.alignment));
    }

    protected void addEditPartRepresentation(EditPartRepresentation rep) {
        if (!this.editpartRepresentation.contains(rep)) {
            this.editpartRepresentation.add(rep);
        }
    }

    public void addFamily(SameAlignment family) {
        for (LinkRepresentation currentLink : family.getLinks()) {
            this.addEditPartRepresentation(currentLink.getSource());
            this.addEditPartRepresentation(currentLink.getTarget());
        }
        this.linksRepresentation.addAll(family.getLinks());
    }

    public int getAlignment() {
        return this.alignment;
    }

    public List<LinkRepresentation> getLinks() {
        return this.linksRepresentation;
    }

    public EditPartRepresentation getEditPartRepresentationFor(EditPart representedEditPart) {
        for (EditPartRepresentation currentRepresentation : this.editpartRepresentation) {
            if (currentRepresentation.getRepresentedEditPart() != representedEditPart) continue;
            return currentRepresentation;
        }
        return null;
    }

    protected void removeBadSideLink() {
        ArrayList<LinkRepresentation> linksToRemove = new ArrayList<LinkRepresentation>();
        for (LinkRepresentation link : this.linksRepresentation) {
            int side1 = link.getLinkSideOnSource();
            int side2 = link.getLinkSideOnTarget();
            if (this.alignment == 1 || this.alignment == 4) {
                if (!DistributionConstants.verticalValuesList.contains(side1) || !DistributionConstants.verticalValuesList.contains(side2)) {
                    linksToRemove.add(link);
                }
            } else if (!(this.alignment != 8 && this.alignment != 32 || DistributionConstants.horizontalValuesList.contains(side1) && DistributionConstants.horizontalValuesList.contains(side2))) {
                linksToRemove.add(link);
            }
            if (((AbstractConnectionEditPart)link.getLink()).getFigure() instanceof PolylineConnectionEx) continue;
            linksToRemove.add(link);
        }
        this.linksRepresentation.removeAll(linksToRemove);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class LinkComparator
    implements Comparator<Object> {
        protected LinkComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            PolylineConnectionEx figure1 = (PolylineConnectionEx)((AbstractConnectionEditPart)((LinkRepresentation)o1).getLink()).getFigure();
            PolylineConnectionEx figure2 = (PolylineConnectionEx)((AbstractConnectionEditPart)((LinkRepresentation)o2).getLink()).getFigure();
            if (SameAlignment.this.alignment == 1 || SameAlignment.this.alignment == 4) {
                Point pt11 = figure1.getStart().x < figure1.getEnd().x ? figure1.getStart() : figure1.getEnd();
                Point pt12 = pt11.equals((Object)figure1.getStart()) ? figure1.getEnd() : figure1.getStart();
                Point pt21 = figure2.getStart().x < figure2.getEnd().x ? figure2.getStart() : figure2.getEnd();
                Point pt22 = pt21.equals((Object)figure2.getStart()) ? figure2.getEnd() : figure2.getStart();
                if (pt11.x < pt21.x && pt12.x < pt22.x) {
                    return -1;
                }
                if (pt11.equals((Object)pt21) && pt12.equals((Object)pt22)) {
                    return 0;
                }
                if (pt11.x > pt21.x && pt12.x > pt22.x) {
                    return 1;
                }
                return 0;
            }
            if (SameAlignment.this.alignment == 8 || SameAlignment.this.alignment == 32) {
                Point pt11 = figure1.getStart().y < figure1.getEnd().y ? figure1.getStart() : figure1.getEnd();
                Point pt12 = pt11.equals((Object)figure1.getStart()) ? figure1.getEnd() : figure1.getStart();
                Point pt21 = figure2.getStart().y < figure2.getEnd().y ? figure2.getStart() : figure2.getEnd();
                Point pt22 = pt21.equals((Object)figure2.getStart()) ? figure2.getEnd() : figure2.getStart();
                if (pt11.y < pt21.y && pt12.y < pt22.y) {
                    return -1;
                }
                if (pt11.equals((Object)pt21) && pt12.equals((Object)pt22)) {
                    return 0;
                }
                if (pt11.y > pt21.y && pt12.y > pt22.y) {
                    return 1;
                }
                return 0;
            }
            return 0;
        }
    }
}

