/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HTMLCleaner {
    protected static final Map<String, String> specials = new HashMap<String, String>();
    protected static final List<String> newLine = new ArrayList<String>();
    protected static final Map<String, String> xmlSpecials = new HashMap<String, String>();

    static {
        specials.put("nbsp", " ");
        specials.put("iexcl", "\u00a1");
        specials.put("cent", "\u00a2");
        specials.put("pound", "\u00a3");
        specials.put("curren", "\u00a4");
        specials.put("yen", "\u00a5");
        specials.put("brvbar", "\u00a6");
        specials.put("sect", "\u00a7");
        specials.put("uml", "\u00a8");
        specials.put("copy", "\u00a9");
        specials.put("ordf", "\u00aa");
        specials.put("laquo", "\u00ab");
        specials.put("not", "\u00ac");
        specials.put("shy", "\u00ad");
        specials.put("reg", "\u00ae");
        specials.put("macr", "\u00af");
        specials.put("deg", "\u00b0");
        specials.put("plusmn", "\u00b1");
        specials.put("sup2", "\u00b2");
        specials.put("sup3", "\u00b3");
        specials.put("acute", "\u00b4");
        specials.put("micro", "\u00b5");
        specials.put("para", "\u00b6");
        specials.put("middot", "\u00b7");
        specials.put("ccedil", "\u00b8");
        specials.put("sup1", "\u00b9");
        specials.put("ordm", "\u00ba");
        specials.put("raquo", "\u00bb");
        specials.put("frac14", "\u00bc");
        specials.put("frac12", "\u00bd");
        specials.put("frac34", "\u00be");
        specials.put("iquest", "\u00bf");
        specials.put("Agrave", "\u00c0");
        specials.put("Aacute", "\u00c1");
        specials.put("Acirc", "\u00c2");
        specials.put("Atilde", "\u00c3");
        specials.put("Auml", "\u00c4");
        specials.put("Aring", "\u00c5");
        specials.put("AElig", "\u00c6");
        specials.put("Ccedil", "\u00c7");
        specials.put("Egrave", "\u00c8");
        specials.put("Eacute", "\u00c9");
        specials.put("Ecirc", "\u00ca");
        specials.put("Euml", "\u00cb");
        specials.put("Igrave", "\u00cc");
        specials.put("Iacute", "\u00cd");
        specials.put("Icirc", "\u00ce");
        specials.put("Iuml", "\u00cf");
        specials.put("ETH", "\u00d0");
        specials.put("Ntilde", "\u00d1");
        specials.put("Ograve", "\u00d2");
        specials.put("Oacute", "\u00d3");
        specials.put("Ocirc", "\u00d4");
        specials.put("Otilde", "\u00d5");
        specials.put("Ouml", "\u00d6");
        specials.put("times", "\u00d7");
        specials.put("Oslash", "\u00d8");
        specials.put("Ugrave", "\u00d9");
        specials.put("Uacute", "\u00da");
        specials.put("Ucirc", "\u00db");
        specials.put("Uuml", "\u00dc");
        specials.put("Yacute", "\u00dd");
        specials.put("THORN", "\u00de");
        specials.put("szlig", "\u00df");
        specials.put("agrave", "\u00e0");
        specials.put("aacute", "\u00e1");
        specials.put("acirc", "\u00e2");
        specials.put("atilde", "\u00e3");
        specials.put("auml", "\u00e4");
        specials.put("aring", "\u00e5");
        specials.put("aelig", "\u00e6");
        specials.put("ccedil", "\u00e7");
        specials.put("egrave", "\u00e8");
        specials.put("eacute", "\u00e9");
        specials.put("ecirc", "\u00ea");
        specials.put("euml", "\u00eb");
        specials.put("igrave", "\u00ec");
        specials.put("iacute", "\u00ed");
        specials.put("icirc", "\u00ee");
        specials.put("iuml", "\u00ef");
        specials.put("eth", "\u00f0");
        specials.put("ntilde", "\u00f1");
        specials.put("ograve", "\u00f2");
        specials.put("oacute", "\u00f3");
        specials.put("ocirc", "\u00f4");
        specials.put("otilde", "\u00f5");
        specials.put("ouml", "\u00f6");
        specials.put("divide", "\u00f7");
        specials.put("oslash", "\u00f8");
        specials.put("ugrave", "\u00f9");
        specials.put("uacute", "\u00fa");
        specials.put("ucirc", "\u00fb");
        specials.put("uuml", "\u00fc");
        specials.put("yacute", "\u00fd");
        specials.put("thorn", "\u00fe");
        specials.put("yuml", "\u00ff");
        specials.put("quot", "\"");
        specials.put("radic", "\u221a");
        specials.put("infin", "\u221e");
        specials.put("cap", "\u2229");
        specials.put("int", "\u222b");
        xmlSpecials.put("amp", "&");
        xmlSpecials.put("lt", "<");
        xmlSpecials.put("gt", ">");
        newLine.add("BR");
        newLine.add("br");
        newLine.add("BR/");
        newLine.add("br/");
        newLine.add("br /");
        newLine.add("BR /");
        newLine.add("/H1");
        newLine.add("/H2");
        newLine.add("/H3");
        newLine.add("/h1");
        newLine.add("/h2");
        newLine.add("/h3");
        newLine.add("/p");
        newLine.add("/P");
        newLine.add("/li");
    }

    public static String removeHTMLTags(String htmlString) {
        StringBuffer buffer = new StringBuffer();
        boolean inTag = false;
        boolean inSpecial = false;
        boolean skip = false;
        boolean keepWhitespace = true;
        boolean keepCarriageReturn = false;
        int length = htmlString.length();
        int i = 0;
        while (i < length) {
            skip = false;
            char c = htmlString.charAt(i);
            if (c == '<') {
                inTag = true;
                String tagValue = htmlString.substring(i + 1, htmlString.indexOf(62, i));
                if (newLine.contains(tagValue)) {
                    if (keepCarriageReturn) {
                        buffer.append("\n");
                        keepCarriageReturn = false;
                    }
                    keepWhitespace = false;
                }
            } else if (c == '>' && inTag) {
                inTag = false;
                skip = true;
            } else if (c == '&') {
                inSpecial = true;
                String specialCharacter = htmlString.substring(i + 1, htmlString.indexOf(59, i));
                String replacement = specials.get(specialCharacter);
                if (replacement == null) {
                    replacement = xmlSpecials.get(specialCharacter);
                }
                if (replacement != null) {
                    buffer.append(replacement);
                }
            } else if (c == ';' && inSpecial) {
                inSpecial = false;
                skip = true;
                keepWhitespace = true;
            } else if (c == ' ' || c == '\t') {
                if (keepWhitespace) {
                    buffer.append(" ");
                }
                keepWhitespace = false;
            } else if (c == '\n' || c == '\r') {
                if (keepCarriageReturn) {
                    buffer.append("\n");
                    keepCarriageReturn = false;
                    keepWhitespace = false;
                }
            } else if (!(skip || inSpecial || inTag)) {
                buffer.append(c);
                keepWhitespace = true;
                keepCarriageReturn = true;
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String cleanHTMLTags(String htmlString) {
        StringBuffer buffer = new StringBuffer();
        boolean inTag = false;
        boolean inSpecial = false;
        boolean skip = false;
        boolean keepWhitespace = true;
        boolean keepCarriageReturn = false;
        int length = htmlString.length();
        int i = 0;
        while (i < length) {
            skip = false;
            char c = htmlString.charAt(i);
            if (c == ' ' || c == '\t') {
                if (keepWhitespace) {
                    buffer.append(" ");
                }
                keepWhitespace = false;
            } else if (c == '\n' || c == '\r') {
                if (keepCarriageReturn) {
                    buffer.append("\n");
                    keepCarriageReturn = false;
                    keepWhitespace = false;
                }
            } else if (!(skip || inSpecial || inTag)) {
                buffer.append(c);
                keepWhitespace = true;
                keepCarriageReturn = true;
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String preClean(String htmlString) {
        if (htmlString == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        boolean inSpecial = false;
        boolean skip = false;
        int length = htmlString.length();
        int i = 0;
        while (i < length) {
            skip = false;
            char c = htmlString.charAt(i);
            if (c == '&') {
                inSpecial = true;
                String specialCharacter = htmlString.substring(i + 1, htmlString.indexOf(59, i));
                String replacement = specials.get(specialCharacter);
                if (replacement != null) {
                    buffer.append(replacement);
                } else if (xmlSpecials.get(specialCharacter) != null) {
                    buffer.append("&" + specialCharacter + ";");
                }
            } else if (c == ';' && inSpecial) {
                inSpecial = false;
                skip = true;
            } else if (!skip && !inSpecial) {
                buffer.append(c);
            }
            ++i;
        }
        return buffer.toString();
    }
}

