/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.emf.ui.services.parser.ISemanticParser;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagsAdderParser
implements ISemanticParser {
    private IParser realParser = null;

    public TagsAdderParser(IParser parser) {
        this.realParser = parser;
    }

    public IContentAssistProcessor getCompletionProcessor(IAdaptable element) {
        if (this.realParser != null) {
            return this.realParser.getCompletionProcessor(element);
        }
        return null;
    }

    public String getEditString(IAdaptable element, int flags) {
        if (this.realParser != null) {
            return this.realParser.getEditString(element, flags);
        }
        return null;
    }

    public ICommand getParseCommand(IAdaptable element, String newString, int flags) {
        if (this.realParser != null) {
            return this.realParser.getParseCommand(element, newString, flags);
        }
        return null;
    }

    public String getPrintString(IAdaptable element, int flags) {
        if (this.realParser != null) {
            String printString = this.realParser.getPrintString(element, flags);
            return this.AddTagsToString(printString, element);
        }
        return null;
    }

    public boolean isAffectingEvent(Object event, int flags) {
        if (this.realParser != null) {
            return this.realParser.isAffectingEvent(event, flags);
        }
        return false;
    }

    public IParserEditStatus isValidEditString(IAdaptable element, String editString) {
        if (this.realParser != null) {
            return this.realParser.isValidEditString(element, editString);
        }
        return null;
    }

    private String AddTagsToString(String string, IAdaptable adapter) {
        String str = null;
        Element element = (Element)adapter.getAdapter(Element.class);
        List<String> stereotypesNames = this.getStereotypesNames(element);
        str = String.valueOf(this.StereotypesNamesListToString(stereotypesNames)) + " " + string;
        return str;
    }

    protected List<String> getStereotypesNames(Element element) {
        LinkedList<String> stereotypesNames = new LinkedList<String>();
        EList stereotypes = element.getAppliedStereotypes();
        for (Stereotype st : stereotypes) {
            String name = st.getName();
            if (name != null) {
                stereotypesNames.add(name);
                continue;
            }
            stereotypesNames.add("");
        }
        return stereotypesNames;
    }

    protected String StereotypesNamesListToString(List<String> names) {
        String str = "";
        if (names != null && names.size() > 0) {
            str = String.valueOf(str) + '\u00ab';
            Iterator<String> it = names.iterator();
            while (it.hasNext()) {
                str = String.valueOf(str) + it.next();
                if (!it.hasNext()) continue;
                str = String.valueOf(str) + ", ";
            }
            str = String.valueOf(str) + '\u00bb';
        }
        return str;
    }

    public boolean areSemanticElementsAffected(EObject arg0, Object arg1) {
        if (this.realParser instanceof ISemanticParser) {
            return ((ISemanticParser)this.realParser).areSemanticElementsAffected(arg0, arg1);
        }
        return false;
    }

    public List getSemanticElementsBeingParsed(EObject arg0) {
        if (this.realParser instanceof ISemanticParser) {
            return ((ISemanticParser)this.realParser).getSemanticElementsBeingParsed(arg0);
        }
        ArrayList<EObject> semanticElements = new ArrayList<EObject>();
        semanticElements.add(arg0);
        return semanticElements;
    }
}

