/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.providers;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.papyrus.editor.PapyrusMultiDiagramEditor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.AbstractSourceProvider;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractActionStateSourceProvider
extends AbstractSourceProvider {
    public static final String ENABLED = "enabled";
    public static final String DISABLED = "disabled";
    protected HashMap<String, String> currentState = new HashMap();
    private static ISelectionService selectionService;
    private static IPartService partService;
    private ISelectionListener listener = new SelectionListener();
    private IPartListener partListener = new PartListener();
    private static IWorkbenchPart workbenchPart;

    static {
        workbenchPart = null;
    }

    public void dispose() {
        if (selectionService != null) {
            selectionService.removeSelectionListener(this.listener);
        }
        if (partService != null) {
            partService.removePartListener(this.partListener);
        }
    }

    public Map<String, String> getCurrentState() {
        this.addSelectionListener();
        this.addPartListener();
        return this.currentState;
    }

    public abstract String[] getProvidedSourceNames();

    protected void addSelectionListener() {
        if (selectionService == null) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    IWorkbench workbench = PlatformUI.getWorkbench();
                    IWorkbenchWindow activeWorkbench = workbench.getActiveWorkbenchWindow();
                    if (activeWorkbench != null) {
                        selectionService = activeWorkbench.getSelectionService();
                        if (selectionService != null) {
                            selectionService.addSelectionListener(AbstractActionStateSourceProvider.this.listener);
                        }
                    }
                }
            });
        }
    }

    protected void addPartListener() {
        if (partService == null) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    IWorkbench workbench = PlatformUI.getWorkbench();
                    IWorkbenchWindow activeWorkbench = workbench.getActiveWorkbenchWindow();
                    if (activeWorkbench != null) {
                        partService = activeWorkbench.getPartService();
                        if (partService != null) {
                            partService.addPartListener(AbstractActionStateSourceProvider.this.partListener);
                        }
                    }
                }
            });
        }
    }

    protected boolean isSelectionInDiagram() {
        return workbenchPart instanceof PapyrusMultiDiagramEditor;
    }

    protected abstract void refreshActions();

    public class PartListener
    implements IPartListener {
        public void partOpened(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partActivated(IWorkbenchPart part) {
            workbenchPart = part;
            AbstractActionStateSourceProvider.this.refreshActions();
        }
    }

    protected class SelectionListener
    implements ISelectionListener {
        protected SelectionListener() {
        }

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            workbenchPart = part;
            AbstractActionStateSourceProvider.this.refreshActions();
        }
    }
}

