/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.service.palette;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.part.PaletteUtil;
import org.eclipse.papyrus.uml.diagram.common.service.palette.PropertyRepresentation;
import org.eclipse.papyrus.uml.diagram.common.service.palette.StereotypeRepresentation;
import org.eclipse.papyrus.uml.diagram.common.service.palette.Value;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configuration {
    public static final String PROPERTY = "property";
    public static final String PROPERTY_NAME = "propertyName";
    public static final String RUNTIME_PROPERTY = "runtimeProperty";
    public static final String STEREOTYPE = "stereotype";
    public static final String STEREOTYPE_TO_APPLY = "stereotypesToApply";
    public static final String STEREOTYPE_NAME = "stereotypeName";
    public static final String VALUE = "value";
    private ArrayList<StereotypeRepresentation> myStereotypesList = new ArrayList();
    private Node configurationNode;
    private List<Profile> appliedProfiles;

    public Configuration(Node configurationNode) {
        this.configurationNode = configurationNode;
        this.buildConfiguration();
    }

    public void buildConfiguration() {
        block19: {
            block18: {
                if (this.configurationNode == null) {
                    return;
                }
                NamedNodeMap nodeAttributes = this.configurationNode.getAttributes();
                if (nodeAttributes.getNamedItem(STEREOTYPE_TO_APPLY) == null) break block18;
                String stereotypesToApplyQN = this.configurationNode.getAttributes().getNamedItem(STEREOTYPE_TO_APPLY).getNodeValue();
                if (stereotypesToApplyQN == null || "".equals(stereotypesToApplyQN)) break block19;
                List<String> stereotypesToApply = PaletteUtil.getStereotypeListFromString(stereotypesToApplyQN);
                for (String qualifiedName : stereotypesToApply) {
                    this.myStereotypesList.add(new StereotypeRepresentation(qualifiedName));
                }
                break block19;
            }
            NodeList configurationChildren = this.configurationNode.getChildNodes();
            Node stereotypesToApplyNode = null;
            int i = 0;
            while (i < configurationChildren.getLength()) {
                Node configurationChild = configurationChildren.item(i);
                if (STEREOTYPE_TO_APPLY.equals(configurationChild.getLocalName())) {
                    stereotypesToApplyNode = configurationChild;
                }
                ++i;
            }
            if (stereotypesToApplyNode != null && stereotypesToApplyNode.hasChildNodes()) {
                NodeList childNodes = stereotypesToApplyNode.getChildNodes();
                int iter = 0;
                while (iter < childNodes.getLength()) {
                    Node steNode = childNodes.item(iter);
                    if (STEREOTYPE.equals(steNode.getLocalName())) {
                        String stereotypeName = steNode.getAttributes().getNamedItem(STEREOTYPE_NAME).getNodeValue();
                        StereotypeRepresentation mySte = null;
                        mySte = this.getStereotypeRepresentation(stereotypeName) == null ? new StereotypeRepresentation(stereotypeName) : this.getStereotypeRepresentation(stereotypeName);
                        if (steNode.hasChildNodes()) {
                            NodeList properties = steNode.getChildNodes();
                            int i2 = 0;
                            while (i2 < properties.getLength()) {
                                String propertyName;
                                Node propertyNode = properties.item(i2);
                                if (PROPERTY.equals(propertyNode.getLocalName())) {
                                    propertyName = propertyNode.getAttributes().getNamedItem(PROPERTY_NAME).getNodeValue();
                                    PropertyRepresentation proper = null;
                                    if (mySte.getPropertyRepresentation(stereotypeName, propertyName) != null) {
                                        proper = mySte.getPropertyRepresentation(stereotypeName, propertyName);
                                    } else {
                                        proper = new PropertyRepresentation(stereotypeName, propertyName);
                                        mySte.addProperty(proper);
                                    }
                                    NodeList valuesList = propertyNode.getChildNodes();
                                    int ii = 0;
                                    while (ii < valuesList.getLength()) {
                                        Node valueNode = valuesList.item(ii);
                                        if (VALUE.equals(valueNode.getLocalName())) {
                                            Value myValue = new Value(valueNode.getTextContent());
                                            proper.addValue(myValue);
                                        }
                                        ++ii;
                                    }
                                } else if (RUNTIME_PROPERTY.equals(propertyNode.getLocalName())) {
                                    propertyName = propertyNode.getAttributes().getNamedItem(PROPERTY_NAME).getNodeValue();
                                    propertyName = propertyNode.getAttributes().getNamedItem(PROPERTY_NAME).getNodeValue();
                                    PropertyRepresentation prop = null;
                                    if (mySte.getPropertyRepresentation(stereotypeName, propertyName) != null) {
                                        prop = mySte.getPropertyRepresentation(stereotypeName, propertyName);
                                    } else {
                                        prop = new PropertyRepresentation(stereotypeName, propertyName);
                                        mySte.addProperty(prop);
                                    }
                                    prop.setRuntime(true);
                                }
                                ++i2;
                            }
                        }
                        this.myStereotypesList.add(mySte);
                    }
                    ++iter;
                }
            }
        }
    }

    protected void completeData() {
        List<Stereotype> stereotypeList = this.retrieveAllStereotypesOwnedByTheProfiles();
        if (!stereotypeList.isEmpty()) {
            for (Stereotype ste : stereotypeList) {
                if (ste == null) continue;
                StereotypeRepresentation currentSte = null;
                if (this.getStereotypeRepresentation(ste.getQualifiedName()) == null) {
                    currentSte = new StereotypeRepresentation(ste.getQualifiedName());
                    this.myStereotypesList.add(currentSte);
                } else {
                    currentSte = this.getStereotypeRepresentation(ste.getQualifiedName());
                }
                currentSte.setUMLStereotype(ste);
                EList attributs = ste.getAllAttributes();
                for (Property prop : attributs) {
                    if (prop == null || (prop.getAssociation() != null || prop.isDerived()) && (prop.getAssociation() == null || prop.getName().startsWith("base_") || prop.isDerived())) continue;
                    if (currentSte.getPropertyRepresentation(ste.getQualifiedName(), prop.getQualifiedName()) == null) {
                        PropertyRepresentation myProp = new PropertyRepresentation(ste.getQualifiedName(), prop.getQualifiedName());
                        myProp.setUMLProperty(prop);
                        currentSte.addProperty(myProp);
                        continue;
                    }
                    currentSte.getPropertyRepresentation(ste.getQualifiedName(), prop.getQualifiedName()).setUMLProperty(prop);
                }
            }
        }
    }

    public void save(Node parentNode) {
        ListIterator<StereotypeRepresentation> it = this.getStereotypesRepresentations().listIterator();
        Element appliedStereotypeNode = ((Element)parentNode).getOwnerDocument().createElement(STEREOTYPE_TO_APPLY);
        while (it.hasNext()) {
            Element propertyNode;
            StereotypeRepresentation currentStereotype = it.next();
            Element stereotypeNode = ((Element)parentNode).getOwnerDocument().createElement(STEREOTYPE);
            stereotypeNode.setAttribute(STEREOTYPE_NAME, currentStereotype.getStereotypeQualifiedName());
            for (PropertyRepresentation prop : currentStereotype.getPropertiesWithValues()) {
                propertyNode = ((Element)parentNode).getOwnerDocument().createElement(PROPERTY);
                propertyNode.setAttribute(PROPERTY_NAME, prop.getQualifiedName());
                ArrayList<Value> values = prop.getValues();
                int i = 0;
                while (i < values.size()) {
                    Element valueNode = ((Element)parentNode).getOwnerDocument().createElement(VALUE);
                    valueNode.setTextContent(((Object)values.get(i)).toString());
                    propertyNode.appendChild(valueNode);
                    ++i;
                }
                stereotypeNode.appendChild(propertyNode);
            }
            for (PropertyRepresentation prop : currentStereotype.getRuntimeProperties()) {
                propertyNode = ((Element)parentNode).getOwnerDocument().createElement(RUNTIME_PROPERTY);
                propertyNode.setAttribute(PROPERTY_NAME, prop.getQualifiedName());
                stereotypeNode.appendChild(propertyNode);
            }
            appliedStereotypeNode.appendChild(stereotypeNode);
        }
        parentNode.appendChild(appliedStereotypeNode);
    }

    public void setStereotypesRepresentations(ArrayList<String> stereotypesQNList) {
        for (String oldSte : this.getStereotypesToApplyQN()) {
            if (stereotypesQNList.contains(oldSte)) continue;
            this.myStereotypesList.remove(this.getStereotypeRepresentation(oldSte));
        }
        for (String ste : stereotypesQNList) {
            this.myStereotypesList.add(new StereotypeRepresentation(ste));
        }
        this.completeData();
    }

    public StereotypeRepresentation getStereotypeRepresentation(String stereotypeQN) {
        for (StereotypeRepresentation ste : this.myStereotypesList) {
            if (!ste.getStereotypeQualifiedName().equals(stereotypeQN)) continue;
            return ste;
        }
        return null;
    }

    public ArrayList<StereotypeRepresentation> getStereotypesRepresentations() {
        return this.myStereotypesList;
    }

    public ArrayList<String> getStereotypesToApplyQN() {
        ArrayList<String> stereotypesList = new ArrayList<String>();
        for (StereotypeRepresentation ste : this.getStereotypesRepresentations()) {
            stereotypesList.add(ste.getStereotypeQualifiedName());
        }
        return stereotypesList;
    }

    public void removeStereotype(StereotypeRepresentation stereotype) {
        this.myStereotypesList.remove(stereotype);
    }

    public void setAppliedProfiles(List<Profile> appliedProfiles) {
        this.appliedProfiles = appliedProfiles;
        this.completeData();
    }

    public List<Profile> getAppliedProfiles() {
        return this.appliedProfiles;
    }

    protected List<Stereotype> retrieveAllStereotypesOwnedByTheProfiles() {
        ArrayList<Stereotype> stereotypes = new ArrayList<Stereotype>();
        for (String qualifiedName : this.getStereotypesToApplyQN()) {
            Stereotype stereotype = null;
            Iterator<Profile> it = this.getAppliedProfiles().iterator();
            while (stereotype == null && it.hasNext()) {
                stereotype = this.retrieveStereotypeFromQualifiedName(qualifiedName, it.next());
            }
            if (stereotype == null) {
                Activator.log.error("impossible to retrieve stereotype " + qualifiedName, null);
            }
            stereotypes.add(stereotype);
        }
        return stereotypes;
    }

    protected Stereotype retrieveStereotypeFromQualifiedName(String qualifiedName, Profile profile) {
        for (Stereotype stereotype : profile.getOwnedStereotypes()) {
            if (!qualifiedName.equals(stereotype.getQualifiedName())) continue;
            return stereotype;
        }
        return null;
    }

    public List<Stereotype> getUMLStereotypes() {
        ArrayList<Stereotype> list = new ArrayList<Stereotype>();
        for (StereotypeRepresentation ste : this.myStereotypesList) {
            list.add(ste.getUMLStereotype());
        }
        return list;
    }

    public boolean hasRuntimeProperties() {
        for (StereotypeRepresentation ste : this.myStereotypesList) {
            if (!ste.hasRuntimeProperties()) continue;
            return true;
        }
        return false;
    }

    public Node getConfigurationNode() {
        return this.configurationNode;
    }
}

