/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.service.palette;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.util.EditPartUtil;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.part.PaletteUtil;
import org.eclipse.papyrus.uml.diagram.common.service.palette.DynamicConfigureRequest;
import org.eclipse.papyrus.uml.diagram.common.service.palette.IAspectActionProvider;
import org.eclipse.papyrus.uml.diagram.common.service.palette.IPaletteEntryProxy;
import org.eclipse.papyrus.uml.diagram.common.service.palette.ModelPostAction;
import org.eclipse.papyrus.uml.diagram.common.service.palette.SetDynamicValueCommand;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.uml2.uml.Profile;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SemanticPostAction
extends ModelPostAction {
    protected Map<String, Object> propertiesToUpdate = new HashMap<String, Object>();
    protected List<String> runtimeDefinedProperties = new ArrayList<String>();
    protected IPaletteEntryProxy entryProxy;
    protected List<Profile> appliedProfiles;
    protected TableViewer attributeViewer;
    protected EClass metaclass = null;
    protected static final String ICON_CHECKED = "/icons/complete_tsk.gif";
    protected static final String ICON_UNCHECKED = "/icons/incomplete_tsk.gif";
    protected static final String SEPARATOR = ",,";

    @Override
    public void init(Node configurationNode, IAspectActionProvider factory) {
        super.init(configurationNode, factory);
        if (configurationNode == null) {
            return;
        }
        NodeList childNodes = configurationNode.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node nameNode;
            Node featureNode = childNodes.item(i);
            if ("feature".equals(featureNode.getNodeName())) {
                nameNode = featureNode.getAttributes().getNamedItem("name");
                Node valueNode = featureNode.getAttributes().getNamedItem("value");
                Node separatorNode = featureNode.getAttributes().getNamedItem("separator");
                if (nameNode != null && valueNode != null && separatorNode != null) {
                    this.propertiesToUpdate.put(nameNode.getNodeValue(), this.parseValue(valueNode.getNodeValue(), separatorNode.getNodeValue()));
                } else {
                    Activator.log.error("Impossible to parse the configuration node for semantic post action", null);
                }
            } else if ("runtimeFeature".equals(featureNode.getNodeName())) {
                nameNode = featureNode.getAttributes().getNamedItem("name");
                if (nameNode != null) {
                    this.runtimeDefinedProperties.add(nameNode.getNodeValue());
                } else {
                    Activator.log.error("Impossible to parse the configuration node for semantic post action", null);
                }
            }
            ++i;
        }
    }

    protected Object parseValue(String nodeValue, String separator) {
        if (nodeValue.indexOf(separator) > 0) {
            ArrayList<Object> values = new ArrayList<Object>();
            StringTokenizer tokenizer = new StringTokenizer(nodeValue, separator);
            while (tokenizer.hasMoreElements()) {
                Object value = tokenizer.nextElement();
                values.add(value);
            }
            return values;
        }
        return nodeValue;
    }

    @Override
    public void run(EditPart editPart) {
        final CompositeCommand compositeCommand = new CompositeCommand("Modify Semantic");
        EObject objectToEdit = ((View)editPart.getModel()).getElement();
        for (String featureName : this.propertiesToUpdate.keySet()) {
            EStructuralFeature feature = objectToEdit.eClass().getEStructuralFeature(featureName);
            if (feature == null) {
                Activator.log.error("Impossible to find the feature " + featureName + " for element " + objectToEdit, null);
                return;
            }
            SetRequest request = new SetRequest(objectToEdit, feature, this.getValue(feature, this.propertiesToUpdate.get(featureName)));
            compositeCommand.compose((IUndoableOperation)new SetValueCommand(request));
        }
        if (this.runtimeDefinedProperties.size() > 0) {
            DynamicConfigureRequest request = new DynamicConfigureRequest(objectToEdit, this.runtimeDefinedProperties);
            compositeCommand.compose((IUndoableOperation)new SetDynamicValueCommand(request));
        }
        compositeCommand.reduce();
        if (compositeCommand.canExecute()) {
            boolean isActivating = true;
            Map<String, Boolean> options = null;
            EditPartViewer viewer = editPart.getViewer();
            if (viewer instanceof DiagramGraphicalViewer) {
                isActivating = ((DiagramGraphicalViewer)viewer).isInitializing();
            }
            if (isActivating || !EditPartUtil.isWriteTransactionInProgress((IGraphicalEditPart)((IGraphicalEditPart)editPart), (boolean)false, (boolean)false)) {
                options = Collections.singletonMap("unprotected", Boolean.TRUE);
            }
            AbstractEMFOperation operation = new AbstractEMFOperation(((IGraphicalEditPart)editPart).getEditingDomain(), "", options){

                protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    compositeCommand.execute(monitor, info);
                    return Status.OK_STATUS;
                }
            };
            try {
                operation.execute((IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException e) {
                Activator.log.error((Throwable)e);
            }
        }
    }

    public Map<String, Object> getPropertiesToUpdate() {
        return this.propertiesToUpdate;
    }

    @Override
    public Control createConfigurationComposite(Composite parent, IPaletteEntryProxy entryProxy, List<Profile> appliedProfiles) {
        this.appliedProfiles = appliedProfiles;
        this.entryProxy = entryProxy;
        if (entryProxy.getEntry() instanceof CombinedTemplateCreationEntry) {
            this.metaclass = PaletteUtil.getToolMetaclass((ToolEntry)((CombinedTemplateCreationEntry)entryProxy.getEntry()));
        }
        Composite mainComposite = new Composite(parent, 2048);
        GridLayout layout = new GridLayout(3, false);
        mainComposite.setLayout((Layout)layout);
        Label titleLabel = new Label(mainComposite, 0);
        titleLabel.setText("Values to set for the semantic element");
        GridData data = new GridData(4, 0x1000000, true, false, 1, 1);
        titleLabel.setLayoutData((Object)data);
        this.attributeViewer = new TableViewer(mainComposite, 67584);
        this.createColumns(this.attributeViewer);
        this.attributeViewer.setContentProvider((IContentProvider)new AttributeContentProvider());
        this.attributeViewer.setLabelProvider((IBaseLabelProvider)new AttributeLabelProvider());
        data = new GridData(4, 4, true, true);
        data.horizontalSpan = 3;
        this.attributeViewer.getControl().setLayoutData((Object)data);
        this.updateAttributesViewer();
        return mainComposite;
    }

    protected void createColumns(TableViewer viewer) {
        TableViewerColumn nameColumn = new TableViewerColumn(viewer, 0);
        nameColumn.getColumn().setText("Feature Name");
        nameColumn.getColumn().setWidth(130);
        nameColumn.getColumn().setResizable(true);
        nameColumn.getColumn().setMoveable(false);
        TableViewerColumn runtimeColumn = new TableViewerColumn(viewer, 0);
        runtimeColumn.getColumn().setText("Runtime");
        runtimeColumn.getColumn().setWidth(70);
        runtimeColumn.getColumn().setResizable(true);
        runtimeColumn.getColumn().setMoveable(false);
        runtimeColumn.setEditingSupport((EditingSupport)new DynamicFeatureEditingSupport((ColumnViewer)viewer));
        TableViewerColumn valueColumn = new TableViewerColumn(viewer, 0);
        valueColumn.getColumn().setText("Values");
        valueColumn.getColumn().setWidth(300);
        valueColumn.getColumn().setResizable(true);
        valueColumn.getColumn().setMoveable(false);
        valueColumn.setEditingSupport((EditingSupport)new AttributeEditingSupport((ColumnViewer)viewer));
        Table table = viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
    }

    protected void updateAttributesViewer() {
        this.attributeViewer.setInput((Object)this.metaclass);
    }

    @Override
    public void save(Node parentNode) {
        Element childElement;
        if (!(parentNode instanceof Element)) {
            Activator.log.error("parent node is not an Element", null);
            return;
        }
        for (String featureName : this.propertiesToUpdate.keySet()) {
            childElement = ((Element)parentNode).getOwnerDocument().createElement("feature");
            childElement.setAttribute("name", featureName);
            childElement.setAttribute("value", this.serializeValue(this.propertiesToUpdate.get(featureName), SEPARATOR));
            childElement.setAttribute("separator", SEPARATOR);
            parentNode.appendChild(childElement);
        }
        for (String featureName : this.runtimeDefinedProperties) {
            childElement = ((Element)parentNode).getOwnerDocument().createElement("runtimeFeature");
            childElement.setAttribute("name", featureName);
            parentNode.appendChild(childElement);
        }
    }

    protected String serializeValue(Object object, String separator) {
        if (object instanceof List) {
            StringBuffer result = new StringBuffer();
            Iterator it = ((List)object).iterator();
            while (it.hasNext()) {
                Object o = it.next();
                result.append(o);
                if (!it.hasNext()) continue;
                result.append(separator);
            }
            return result.toString();
        }
        return object.toString();
    }

    protected boolean isRuntimeDefined(EStructuralFeature feature) {
        return this.runtimeDefinedProperties.contains(feature.getName());
    }

    protected class AttributeContentProvider
    implements IStructuredContentProvider {
        protected EClass currentEClass;

        protected AttributeContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof EClass) {
                this.currentEClass = (EClass)inputElement;
                ArrayList<EAttribute> attributes = new ArrayList<EAttribute>();
                for (EAttribute attribute : this.currentEClass.getEAllAttributes()) {
                    if (attribute.isDerived() || !attribute.isChangeable()) continue;
                    attributes.add(attribute);
                }
                return attributes.toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    protected class AttributeEditingSupport
    extends EditingSupport {
        protected final String[] booleanProposals;

        public AttributeEditingSupport(ColumnViewer viewer) {
            super(viewer);
            this.booleanProposals = new String[]{"", "true", "false"};
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            EStructuralFeature feature = (EStructuralFeature)element;
            EClassifier eType = feature.getEType();
            if (eType instanceof EEnum) {
                return this.createEnumerationEditor(feature);
            }
            String instanceTypeName = eType.getInstanceClassName();
            if (instanceTypeName.equals(String.class.getCanonicalName())) {
                return new TextCellEditor((Composite)((TableViewer)this.getViewer()).getTable());
            }
            if (instanceTypeName.equals(Integer.class.getCanonicalName())) {
                return new TextCellEditor((Composite)((TableViewer)this.getViewer()).getTable());
            }
            if (instanceTypeName.equals("boolean")) {
                return this.createBooleanEditor(feature);
            }
            return new TextCellEditor((Composite)((TableViewer)this.getViewer()).getTable());
        }

        protected CellEditor createBooleanEditor(EStructuralFeature feature) {
            return new ComboBoxCellEditor((Composite)((TableViewer)this.getViewer()).getTable(), this.booleanProposals, 8);
        }

        protected CellEditor createEnumerationEditor(EStructuralFeature feature) {
            EEnum eType = (EEnum)feature.getEType();
            EList literals = eType.getELiterals();
            String[] proposals = new String[literals.size() + 1];
            proposals[0] = "";
            int i = 0;
            while (i < literals.size()) {
                proposals[i + 1] = ((EEnumLiteral)literals.get(i)).getLiteral();
                ++i;
            }
            return new ComboBoxCellEditor((Composite)((TableViewer)this.getViewer()).getTable(), proposals, 8);
        }

        protected Object getValue(Object element) {
            EStructuralFeature feature = (EStructuralFeature)element;
            EClassifier eType = feature.getEType();
            if (eType instanceof EEnum) {
                return this.getEnumerationValue(feature);
            }
            String instanceTypeName = eType.getInstanceClassName();
            if (instanceTypeName.equals("boolean")) {
                return this.getBooleanValue(feature);
            }
            return SemanticPostAction.this.propertiesToUpdate.get(feature.getName()) != null ? SemanticPostAction.this.propertiesToUpdate.get(feature.getName()) : "";
        }

        protected Object getEnumerationValue(EStructuralFeature feature) {
            EEnum eType = (EEnum)feature.getEType();
            EList literals = eType.getELiterals();
            ArrayList<String> proposals = new ArrayList<String>();
            proposals.add("");
            int i = 0;
            while (i < literals.size()) {
                proposals.add(i + 1, ((EEnumLiteral)literals.get(i)).getLiteral());
                ++i;
            }
            Object value = SemanticPostAction.this.propertiesToUpdate.get(feature.getName());
            if (value == null) {
                return 0;
            }
            return proposals.indexOf(value);
        }

        protected Object getBooleanValue(EStructuralFeature feature) {
            List<String> booleans = Arrays.asList(this.booleanProposals);
            Object value = SemanticPostAction.this.propertiesToUpdate.get(feature.getName());
            if (value == null || value.equals("")) {
                return 0;
            }
            return booleans.indexOf(value);
        }

        protected void setValue(Object element, Object value) {
            EStructuralFeature feature = (EStructuralFeature)element;
            String featureName = ((EStructuralFeature)element).getName();
            EClassifier eType = feature.getEType();
            if (eType instanceof EEnum) {
                this.setEnumerationValue(element, value);
            } else {
                String instanceTypeName = eType.getInstanceClassName();
                if (instanceTypeName.equals("boolean")) {
                    this.setBooleanValue(element, value);
                } else if (value == null || value.equals("")) {
                    SemanticPostAction.this.propertiesToUpdate.remove(featureName);
                } else {
                    SemanticPostAction.this.propertiesToUpdate.put(featureName, value);
                }
            }
            this.getViewer().update(element, null);
        }

        protected void setEnumerationValue(Object element, Object value) {
            EStructuralFeature feature = (EStructuralFeature)element;
            EEnum eType = (EEnum)feature.getEType();
            EList literals = eType.getELiterals();
            ArrayList<String> proposals = new ArrayList<String>();
            proposals.add("");
            int i = 0;
            while (i < literals.size()) {
                proposals.add(i + 1, ((EEnumLiteral)literals.get(i)).getLiteral());
                ++i;
            }
            String featureName = feature.getName();
            if (value == null || value.equals(0)) {
                SemanticPostAction.this.propertiesToUpdate.remove(featureName);
            } else {
                int index = (Integer)value;
                SemanticPostAction.this.propertiesToUpdate.put(featureName, proposals.get(index));
            }
        }

        protected void setBooleanValue(Object element, Object value) {
            EStructuralFeature feature = (EStructuralFeature)element;
            String featureName = feature.getName();
            if (value == null || value.equals(0)) {
                SemanticPostAction.this.propertiesToUpdate.remove(featureName);
            } else if (value.equals(1)) {
                SemanticPostAction.this.propertiesToUpdate.put(featureName, this.booleanProposals[1]);
            } else if (value.equals(2)) {
                SemanticPostAction.this.propertiesToUpdate.put(featureName, this.booleanProposals[2]);
            } else {
                Activator.log.error("impossible to set boolean value " + value, null);
            }
        }
    }

    protected class AttributeLabelProvider
    implements ITableLabelProvider {
        protected AttributeLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 1) {
                EStructuralFeature feature = (EStructuralFeature)element;
                if (SemanticPostAction.this.isRuntimeDefined(feature)) {
                    return Activator.getPluginIconImage("org.eclipse.papyrus.uml.diagram.common", SemanticPostAction.ICON_CHECKED);
                }
                return Activator.getPluginIconImage("org.eclipse.papyrus.uml.diagram.common", SemanticPostAction.ICON_UNCHECKED);
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String text = "";
            EStructuralFeature feature = (EStructuralFeature)element;
            switch (columnIndex) {
                case 0: {
                    text = feature.getName();
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    Object value = SemanticPostAction.this.propertiesToUpdate.get(feature.getName());
                    text = value != null ? value.toString() : "";
                }
            }
            return text;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    protected class DynamicFeatureEditingSupport
    extends EditingSupport {
        private CellEditor editor;

        public DynamicFeatureEditingSupport(ColumnViewer viewer) {
            super(viewer);
            this.editor = new CheckboxCellEditor(null, 0);
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected Object getValue(Object element) {
            EStructuralFeature feature = (EStructuralFeature)element;
            return SemanticPostAction.this.runtimeDefinedProperties.contains(feature.getName());
        }

        protected void setValue(Object element, Object value) {
            String featureName = ((EStructuralFeature)element).getName();
            if (!SemanticPostAction.this.runtimeDefinedProperties.contains(featureName)) {
                SemanticPostAction.this.runtimeDefinedProperties.add(featureName);
            } else {
                SemanticPostAction.this.runtimeDefinedProperties.remove(featureName);
            }
            this.getViewer().update(element, null);
        }
    }
}

