/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.papyrus.uml.diagram.common.Messages;
import org.eclipse.papyrus.uml.diagram.common.ui.dialogs.ComboDialogWithMessage;
import org.eclipse.papyrus.uml.diagram.common.ui.dialogs.ComboInputDialog;
import org.eclipse.papyrus.uml.diagram.common.ui.dialogs.InputDialogMessage;
import org.eclipse.papyrus.uml.diagram.common.util.Util;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyEditors {
    public static final String IntegerEditor_Title = Messages.PropertyEditors_IntegerTitle;
    public static final String UnlimitedNaturalEditor_Title = Messages.PropertyEditors_UnlimitedNaturalTitle;
    public static final String StringEditor_Title = Messages.PropertyEditors_StringTitle;
    public static final String BooleanEditor_Title = Messages.PropertyEditors_BooleanTitle;
    public static final String EnumerationLiteralEditor_Title = Messages.PropertyEditors_EnumerationLiteralTitle;
    private static final String StereotypeEditor_Title = Messages.PropertyEditors_StereotypeTitle;
    private static final String MetaclassEditor_Title = Messages.PropertyEditors_MetaclassTitle;
    private static final String DataTypeEditor_Title = Messages.PropertyEditors_DataTypeTitle;
    public static final String Value = Messages.PropertyEditors_Value;
    public static final String Choice = Messages.PropertyEditors_Choice;
    public static final String IntegerValidator_WarningMessage = Messages.PropertyEditors_IntegerWarning;
    public static final String UnlimitedNaturalValidator_WarningMessage = Messages.PropertyEditors_UnlimitedNaturalWarning;
    public static final String MetaclassEditor_WarningMessage = Messages.PropertyEditors_NoFoundElementMetaclass;
    public static final String StereotypeEditor_WarningMessage = Messages.PropertyEditors_NoFoundElementStereotype;
    public static final String UML_PREFIX = "org.eclipse.uml2.uml.";
    static String[] unNamedElements = new String[]{"ActivityGroup", "Clause", "Comment", "ExceptionHandler", "Image", "LinkEndData", "MultiplicityElement", "ParameterableElement", "QualifierValue", "Relationship", "Slot", "TemplateableElement", "TemplateParameter", "TemplateParameterSubstitution", "TemplateableParameterSubsitution"};

    public static String IntegerEditor(Property property, Object oldValue) {
        String value = null;
        String initialValue = PropertyEditors.findInitialValue(property, oldValue);
        InputDialogMessage dialog = new InputDialogMessage(new Shell(), IntegerEditor_Title, Value, initialValue, new IntegerValidator());
        if (dialog.open() != 1) {
            if (!"".equals(dialog.getValue())) {
                value = dialog.getValue();
            }
        } else {
            value = oldValue.toString();
        }
        return value;
    }

    private static String findInitialValue(Property property, Object oldValue) {
        String initialValue = null;
        if (oldValue != null) {
            initialValue = oldValue.toString();
        } else if (property.isSetDefault()) {
            initialValue = property.getDefault();
        }
        return initialValue;
    }

    public static String UnlimitedNaturalEditor(Property property, Object oldValue) {
        String value = null;
        String initialValue = PropertyEditors.findInitialValue(property, oldValue);
        InputDialogMessage dialog = new InputDialogMessage(new Shell(), UnlimitedNaturalEditor_Title, Value, initialValue, new UnlimitedNaturalValidator());
        if (dialog.open() != 1) {
            if (!"".equals(dialog.getValue())) {
                value = dialog.getValue();
            }
        } else if (value != null) {
            value = oldValue.toString();
        }
        return value;
    }

    public static String StringEditor(Property property, Object oldValue) {
        String value = null;
        String initialValue = PropertyEditors.findInitialValue(property, oldValue);
        InputDialogMessage dialog = new InputDialogMessage(new Shell(), StringEditor_Title, Value, initialValue, null);
        if (dialog.open() != 1) {
            value = new String(dialog.getValue());
            if (value.equals("")) {
                value = null;
            }
        } else if (oldValue != null) {
            return oldValue.toString();
        }
        return value;
    }

    public static String DataTypeEditor(Property property, Object oldValue) {
        String value = null;
        String initialValue = null;
        if (oldValue != null) {
            initialValue = oldValue.toString();
        } else if (property.isSetDefault()) {
            initialValue = property.getDefault();
        }
        InputDialogMessage dialog = new InputDialogMessage(new Shell(), DataTypeEditor_Title, Value, initialValue, null);
        if (dialog.open() != 1) {
            if (!"".equals(dialog.getValue())) {
                value = dialog.getValue();
            }
        } else if (oldValue != null) {
            value = oldValue.toString();
        }
        return value;
    }

    public static String BooleanEditor(Property property, Object oldValue) {
        String value = null;
        String[] listOfChoice = property.getLower() > 0 ? new String[]{Boolean.FALSE.toString(), Boolean.TRUE.toString()} : new String[]{"", Boolean.FALSE.toString(), Boolean.TRUE.toString()};
        String initialValue = PropertyEditors.findInitialValue(property, oldValue);
        ComboInputDialog dialog = new ComboInputDialog(new Shell(), BooleanEditor_Title, Choice, initialValue, listOfChoice);
        if (dialog.open() != 1) {
            int selection = dialog.getIndexOfSelection();
            if (listOfChoice[selection] != "") {
                value = listOfChoice[selection];
            }
        } else if (oldValue != null) {
            value = oldValue.toString();
        }
        return value;
    }

    public static String EnumerationEditor(Property property, Object oldValue) {
        int i;
        String[] listOfChoice;
        EList literals = ((Enumeration)property.getType()).getOwnedLiterals();
        String initialValue = PropertyEditors.findInitialValue(property, oldValue);
        String value = null;
        if (property.getLower() > 0) {
            listOfChoice = new String[literals.size()];
            i = 0;
            while (i < listOfChoice.length) {
                listOfChoice[i] = ((EnumerationLiteral)literals.get(i)).getName();
                ++i;
            }
        } else {
            listOfChoice = new String[literals.size() + 1];
            listOfChoice[0] = "";
            i = 1;
            while (i < listOfChoice.length) {
                listOfChoice[i] = ((EnumerationLiteral)literals.get(i - 1)).getName();
                ++i;
            }
        }
        ComboInputDialog dialog = new ComboInputDialog(new Shell(), EnumerationLiteralEditor_Title, Choice, initialValue, listOfChoice);
        if (dialog.open() != 1) {
            int selection = dialog.getIndexOfSelection();
            if (listOfChoice[selection] != "") {
                value = listOfChoice[selection].toString();
            }
        } else if (oldValue != null) {
            value = oldValue.toString();
        }
        return value;
    }

    public static String CompositeClassEditor(Property property, Object oldValue) {
        return oldValue.toString();
    }

    public static String StereotypeEditor(Property property, Object oldValue, List<Profile> appliedProfiles) {
        Type type = property.getType();
        String returnedValue = null;
        ArrayList stereotypedElement = new ArrayList();
        String initialValue = PropertyEditors.findInitialValue(property, oldValue);
        String[] proposals = null;
        if (type != null) {
            int i;
            for (Profile profile : appliedProfiles) {
                stereotypedElement.addAll(Util.getInstancesFilteredByType((Package)profile, null, (Stereotype)type));
            }
            if (property.getLower() > 0) {
                proposals = new String[stereotypedElement.size()];
                i = 0;
                while (i < stereotypedElement.size()) {
                    if (stereotypedElement.get(i) instanceof NamedElement) {
                        proposals[i] = ((NamedElement)stereotypedElement.get(i)).getQualifiedName();
                    }
                    ++i;
                }
            } else {
                proposals = new String[stereotypedElement.size() + 1];
                proposals[0] = "";
                i = 1;
                while (i < proposals.length) {
                    if (stereotypedElement.get(i - 1) instanceof NamedElement) {
                        proposals[i] = ((NamedElement)stereotypedElement.get(i - 1)).getQualifiedName();
                    }
                    ++i;
                }
            }
            ComboDialogWithMessage dialog = new ComboDialogWithMessage(new Shell(), StereotypeEditor_Title, Choice, initialValue, proposals, StereotypeEditor_WarningMessage);
            if (dialog.open() != 1) {
                int selection = dialog.getIndexOfSelection();
                if (proposals[selection] != "") {
                    returnedValue = dialog.getValue();
                }
            } else if (oldValue != null) {
                returnedValue = oldValue.toString();
            }
        }
        return returnedValue;
    }

    public static String MetaclassEditor(Property property, Object oldValue, List<Profile> appliedProfiles) {
        Type type = property.getType();
        String returnedValue = null;
        ArrayList<String> problematicMetaclasses = new ArrayList<String>(Arrays.asList(unNamedElements));
        if (type != null && !problematicMetaclasses.contains(((Class)type).getName())) {
            String label;
            int i;
            String[] proposals;
            ArrayList metaclassElement = new ArrayList();
            String initialValue = PropertyEditors.findInitialValue(property, oldValue);
            String metaclassName = ((Class)type).getName();
            java.lang.Class<?> metaType = null;
            try {
                metaType = java.lang.Class.forName(UML_PREFIX + metaclassName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            for (Profile profile : appliedProfiles) {
                metaclassElement.addAll(Util.getInstancesFilteredByType((Package)profile, metaType, null));
            }
            if (property.getLower() == 0) {
                proposals = new String[metaclassElement.size() + 1];
                proposals[0] = "";
                i = 0;
                while (i < metaclassElement.size()) {
                    if (metaclassElement.get(i) instanceof NamedElement) {
                        proposals[i + 1] = ((NamedElement)metaclassElement.get(i)).getQualifiedName();
                    } else {
                        proposals[i + 1] = label = ((Element)metaclassElement.get(i)).toString();
                        UML2Util.getXMIIdentifier((InternalEObject)((InternalEObject)((Element)metaclassElement.get(i))));
                    }
                    ++i;
                }
            } else {
                proposals = new String[metaclassElement.size()];
                i = 0;
                while (i < metaclassElement.size()) {
                    if (metaclassElement.get(i) instanceof NamedElement) {
                        proposals[i] = ((NamedElement)metaclassElement.get(i)).getQualifiedName();
                    } else {
                        proposals[i] = label = ((Element)metaclassElement.get(i)).toString();
                        UML2Util.getXMIIdentifier((InternalEObject)((InternalEObject)((Element)metaclassElement.get(i))));
                    }
                    ++i;
                }
            }
            ComboDialogWithMessage dialog = new ComboDialogWithMessage(new Shell(), MetaclassEditor_Title, Choice, initialValue, proposals, MetaclassEditor_WarningMessage);
            if (dialog.open() != 1) {
                int selection = dialog.getIndexOfSelection();
                if (proposals[selection] != "") {
                    returnedValue = dialog.getValue();
                }
            } else if (oldValue != null) {
                returnedValue = oldValue.toString();
            }
        }
        return returnedValue;
    }

    public static class IntegerValidator
    implements IInputValidator {
        public String isValid(String newText) {
            if (newText != null && newText != "") {
                int iter = 0;
                while (iter < newText.length()) {
                    if (!(Character.isDigit(newText.charAt(iter)) || iter == 0 && newText.charAt(iter) == '-')) {
                        return IntegerValidator_WarningMessage;
                    }
                    ++iter;
                }
            }
            return null;
        }
    }

    public static class UnlimitedNaturalValidator
    implements IInputValidator {
        public String isValid(String newText) {
            if (newText != null && newText != "") {
                int iter = 0;
                while (iter < newText.length()) {
                    if (!Character.isDigit(newText.charAt(iter))) {
                        if (newText.length() == 1 && newText.charAt(0) == '*') break;
                        return UnlimitedNaturalValidator_WarningMessage;
                    }
                    ++iter;
                }
            }
            return null;
        }
    }
}

