/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.component.edit.parts;

import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.papyrus.uml.diagram.common.figure.node.IMultilineEditableFigure;
import org.eclipse.papyrus.uml.diagram.component.edit.parts.AbstractionAppliedStereotypeEditPart;
import org.eclipse.papyrus.uml.diagram.component.edit.parts.AbstractionEditPart;
import org.eclipse.papyrus.uml.diagram.component.edit.parts.AbstractionNameEditPart;
import org.eclipse.papyrus.uml.diagram.component.edit.parts.CommentAnnotatedElementEditPart;
import org.eclipse.papyrus.uml.diagram.component.edit.parts.CommentBodyEditPart;
import org.eclipse.papyrus.uml.diagram.component.edit.parts.CommentBodyEditPartPCN;
import org.eclipse.papyrus.uml.diagram.component.edit.parts.CommentEditPart;
import org.eclipse.papyrus.uml.diagram.component.edit.parts.CommentEditPartPCN;
import org.eclipse.papyrus.uml.diagram.component.edit.parts.ComponentCompositeCompartmentEditPart;
import org.eclipse.papyrus.uml.diagram.component.edit.parts.ComponentCompositeCompartmentEditPartCN;
import org.eclipse.papyrus.uml.diagram.component.edit.parts.ComponentCompositeCompartmentEditPartPCN;
import org.eclipse.papyrus.uml.diagram.component.edit.parts.ComponentDiagramEditPart;
import org.eclipse.papyrus.uml.diagram.component.edit.parts.ComponentEditPart;
import org.eclipse.papyrus.uml.diagram.component.edit.parts.ComponentEditPartCN;
import org.eclipse.papyrus.uml.diagram.component.edit.parts.ComponentEditPartPCN;
import org.eclipse.papyrus.uml.diagram.component.edit.parts.ComponentNameEditPart;
import org.eclipse.papyrus.uml.diagram.component.edit.parts.ComponentNameEditPartCN;
import org.eclipse.papyrus.uml.diagram.component.edit.parts.ComponentNameEditPartPCN;
import org.eclipse.papyrus.uml.diagram.component.edit.parts.ComponentRealizationAppliedStereotypeEditPart;
import org.eclipse.papyrus.uml.diagram.component.edit.parts.ComponentRealizationEditPart;
import org.eclipse.papyrus.uml.diagram.component.edit.parts.ComponentRealizationNameEditPart;
import org.eclipse.papyrus.uml.diagram.component.edit.parts.ConstraintConstrainedElementEditPart;
import org.eclipse.papyrus.uml.diagram.component.edit.parts.ConstraintEditPart;
import org.eclipse.papyrus.uml.diagram.component.edit.parts.ConstraintEditPartPCN;
import org.eclipse.papyrus.uml.diagram.component.edit.parts.ConstraintNameEditPart;
import org.eclipse.papyrus.uml.diagram.component.edit.parts.ConstraintNameEditPartPCN;
import org.eclipse.papyrus.uml.diagram.component.edit.parts.ConstraintSpecificationEditPart;
import org.eclipse.papyrus.uml.diagram.component.edit.parts.ConstraintSpecificationEditPartPCN;
import org.eclipse.papyrus.uml.diagram.component.edit.parts.DependencyAppliedStereotypeEditPart;
import org.eclipse.papyrus.uml.diagram.component.edit.parts.DependencyEditPart;
import org.eclipse.papyrus.uml.diagram.component.edit.parts.DependencyNameEditPart;
import org.eclipse.papyrus.uml.diagram.component.edit.parts.GeneralizationAppliedStereotypeEditPart;
import org.eclipse.papyrus.uml.diagram.component.edit.parts.GeneralizationEditPart;
import org.eclipse.papyrus.uml.diagram.component.edit.parts.InterfaceEditPart;
import org.eclipse.papyrus.uml.diagram.component.edit.parts.InterfaceEditPartPCN;
import org.eclipse.papyrus.uml.diagram.component.edit.parts.InterfaceNameEditPart;
import org.eclipse.papyrus.uml.diagram.component.edit.parts.InterfaceNameEditPartPCN;
import org.eclipse.papyrus.uml.diagram.component.edit.parts.InterfaceRealizationEditPart;
import org.eclipse.papyrus.uml.diagram.component.edit.parts.LinkDescriptorEditPart;
import org.eclipse.papyrus.uml.diagram.component.edit.parts.ManifestationAppliedStereotypeEditPart;
import org.eclipse.papyrus.uml.diagram.component.edit.parts.ManifestationEditPart;
import org.eclipse.papyrus.uml.diagram.component.edit.parts.ManifestationNameEditPart;
import org.eclipse.papyrus.uml.diagram.component.edit.parts.PackageEditPart;
import org.eclipse.papyrus.uml.diagram.component.edit.parts.PackageNameEditPart;
import org.eclipse.papyrus.uml.diagram.component.edit.parts.PackagePackageableElementCompartmentEditPart;
import org.eclipse.papyrus.uml.diagram.component.edit.parts.PortAppliedStereotypeEditPart;
import org.eclipse.papyrus.uml.diagram.component.edit.parts.PortEditPart;
import org.eclipse.papyrus.uml.diagram.component.edit.parts.PortNameEditPart;
import org.eclipse.papyrus.uml.diagram.component.edit.parts.SubstitutionAppliedStereotypeEditPart;
import org.eclipse.papyrus.uml.diagram.component.edit.parts.SubstitutionEditPart;
import org.eclipse.papyrus.uml.diagram.component.edit.parts.SubstitutionNameEditPart;
import org.eclipse.papyrus.uml.diagram.component.edit.parts.UsageEditPart;
import org.eclipse.papyrus.uml.diagram.component.part.UMLVisualIDRegistry;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Text;

public class UMLEditPartFactory
implements EditPartFactory {
    public EditPart createEditPart(EditPart context, Object model) {
        if (model instanceof View) {
            View view = (View)model;
            switch (UMLVisualIDRegistry.getVisualID(view)) {
                case 1000: {
                    return new ComponentDiagramEditPart(view);
                }
                case 2002: {
                    return new ComponentEditPart(view);
                }
                case 5004: {
                    return new ComponentNameEditPart(view);
                }
                case 2003: {
                    return new InterfaceEditPart(view);
                }
                case 5005: {
                    return new InterfaceNameEditPart(view);
                }
                case 3200: {
                    return new PackageEditPart(view);
                }
                case 5254: {
                    return new PackageNameEditPart(view);
                }
                case 3201: {
                    return new CommentEditPart(view);
                }
                case 5255: {
                    return new CommentBodyEditPart(view);
                }
                case 3199: {
                    return new ConstraintEditPart(view);
                }
                case 5252: {
                    return new ConstraintNameEditPart(view);
                }
                case 5253: {
                    return new ConstraintSpecificationEditPart(view);
                }
                case 3069: {
                    return new PortEditPart(view);
                }
                case 5006: {
                    return new PortNameEditPart(view);
                }
                case 5007: {
                    return new PortAppliedStereotypeEditPart(view);
                }
                case 3070: {
                    return new ComponentEditPartCN(view);
                }
                case 5256: {
                    return new ComponentNameEditPartCN(view);
                }
                case 3071: {
                    return new ComponentEditPartPCN(view);
                }
                case 5257: {
                    return new ComponentNameEditPartPCN(view);
                }
                case 3072: {
                    return new InterfaceEditPartPCN(view);
                }
                case 0: {
                    return new InterfaceNameEditPartPCN(view);
                }
                case 3074: {
                    return new CommentEditPartPCN(view);
                }
                case 5258: {
                    return new CommentBodyEditPartPCN(view);
                }
                case 3075: {
                    return new ConstraintEditPartPCN(view);
                }
                case 5259: {
                    return new ConstraintNameEditPartPCN(view);
                }
                case 5260: {
                    return new ConstraintSpecificationEditPartPCN(view);
                }
                case 7001: {
                    return new ComponentCompositeCompartmentEditPart(view);
                }
                case 7002: {
                    return new PackagePackageableElementCompartmentEditPart(view);
                }
                case 7003: {
                    return new ComponentCompositeCompartmentEditPartCN(view);
                }
                case 7004: {
                    return new ComponentCompositeCompartmentEditPartPCN(view);
                }
                case 4001: {
                    return new UsageEditPart(view);
                }
                case 4006: {
                    return new InterfaceRealizationEditPart(view);
                }
                case 4003: {
                    return new GeneralizationEditPart(view);
                }
                case 2: {
                    return new GeneralizationAppliedStereotypeEditPart(view);
                }
                case 4012: {
                    return new SubstitutionEditPart(view);
                }
                case 6006: {
                    return new SubstitutionNameEditPart(view);
                }
                case 6020: {
                    return new SubstitutionAppliedStereotypeEditPart(view);
                }
                case 4014: {
                    return new ManifestationEditPart(view);
                }
                case 6008: {
                    return new ManifestationNameEditPart(view);
                }
                case 6022: {
                    return new ManifestationAppliedStereotypeEditPart(view);
                }
                case 4007: {
                    return new ComponentRealizationEditPart(view);
                }
                case 3: {
                    return new ComponentRealizationNameEditPart(view);
                }
                case 4: {
                    return new ComponentRealizationAppliedStereotypeEditPart(view);
                }
                case 4013: {
                    return new AbstractionEditPart(view);
                }
                case 6007: {
                    return new AbstractionNameEditPart(view);
                }
                case 6021: {
                    return new AbstractionAppliedStereotypeEditPart(view);
                }
                case 4016: {
                    return new LinkDescriptorEditPart(view);
                }
                case 4015: {
                    return new CommentAnnotatedElementEditPart(view);
                }
                case 4009: {
                    return new ConstraintConstrainedElementEditPart(view);
                }
                case 4010: {
                    return new DependencyEditPart(view);
                }
                case 6009: {
                    return new DependencyNameEditPart(view);
                }
                case 6023: {
                    return new DependencyAppliedStereotypeEditPart(view);
                }
            }
        }
        return this.createUnrecognizedEditPart(context, model);
    }

    private EditPart createUnrecognizedEditPart(EditPart context, Object model) {
        return null;
    }

    public static CellEditorLocator getTextCellEditorLocator(ITextAwareEditPart source) {
        if (source.getFigure() instanceof IMultilineEditableFigure) {
            return new MultilineCellEditorLocator((IMultilineEditableFigure)source.getFigure());
        }
        if (source.getFigure() instanceof WrappingLabel) {
            return new TextCellEditorLocator((WrappingLabel)source.getFigure());
        }
        return new LabelCellEditorLocator((Label)source.getFigure());
    }

    private static class LabelCellEditorLocator
    implements CellEditorLocator {
        private Label label;

        public LabelCellEditorLocator(Label label) {
            this.label = label;
        }

        public Label getLabel() {
            return this.label;
        }

        public void relocate(CellEditor celleditor) {
            Text text = (Text)celleditor.getControl();
            Rectangle rect = this.getLabel().getTextBounds().getCopy();
            this.getLabel().translateToAbsolute((Translatable)rect);
            if (!text.getFont().isDisposed()) {
                int avr = FigureUtilities.getFontMetrics((Font)text.getFont()).getAverageCharWidth();
                rect.setSize(new Dimension(text.computeSize(-1, -1)).expand(avr * 2, 0));
            }
            if (!rect.equals((Object)new Rectangle(text.getBounds()))) {
                text.setBounds(rect.x, rect.y, rect.width, rect.height);
            }
        }
    }

    private static class MultilineCellEditorLocator
    implements CellEditorLocator {
        private IMultilineEditableFigure multilineEditableFigure;

        public MultilineCellEditorLocator(IMultilineEditableFigure figure) {
            this.multilineEditableFigure = figure;
        }

        public IMultilineEditableFigure getMultilineEditableFigure() {
            return this.multilineEditableFigure;
        }

        public void relocate(CellEditor celleditor) {
            Text text = (Text)celleditor.getControl();
            Rectangle rect = this.getMultilineEditableFigure().getBounds().getCopy();
            rect.x = this.getMultilineEditableFigure().getEditionLocation().x;
            rect.y = this.getMultilineEditableFigure().getEditionLocation().y;
            this.getMultilineEditableFigure().translateToAbsolute((Translatable)rect);
            if (this.getMultilineEditableFigure().getText().length() > 0) {
                rect.setSize(new Dimension(text.computeSize(rect.width, -1)));
            }
            if (!rect.equals((Object)new Rectangle(text.getBounds()))) {
                text.setBounds(rect.x, rect.y, rect.width, rect.height);
            }
        }
    }

    private static class TextCellEditorLocator
    implements CellEditorLocator {
        private WrappingLabel wrapLabel;

        public TextCellEditorLocator(WrappingLabel wrapLabel) {
            this.wrapLabel = wrapLabel;
        }

        public WrappingLabel getWrapLabel() {
            return this.wrapLabel;
        }

        public void relocate(CellEditor celleditor) {
            Text text = (Text)celleditor.getControl();
            Rectangle rect = this.getWrapLabel().getTextBounds().getCopy();
            this.getWrapLabel().translateToAbsolute((Translatable)rect);
            if (!text.getFont().isDisposed()) {
                if (this.getWrapLabel().isTextWrapOn() && this.getWrapLabel().getText().length() > 0) {
                    rect.setSize(new Dimension(text.computeSize(rect.width, -1)));
                } else {
                    int avr = FigureUtilities.getFontMetrics((Font)text.getFont()).getAverageCharWidth();
                    rect.setSize(new Dimension(text.computeSize(-1, -1)).expand(avr * 2, 0));
                }
            }
            if (!rect.equals((Object)new Rectangle(text.getBounds()))) {
                text.setBounds(rect.x, rect.y, rect.width, rect.height);
            }
        }
    }
}

