/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.composite.custom.edit.command;

import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.papyrus.extensionpoints.editors.Activator;
import org.eclipse.papyrus.extensionpoints.editors.configuration.IDirectEditorConfiguration;
import org.eclipse.papyrus.extensionpoints.editors.ui.ExtendedDirectEditionDialog;
import org.eclipse.papyrus.extensionpoints.editors.utils.DirectEditorsUtil;
import org.eclipse.papyrus.uml.diagram.composite.custom.messages.Messages;
import org.eclipse.papyrus.uml.diagram.composite.custom.ui.InformationItemElementTreeSelectionDialog;
import org.eclipse.papyrus.uml.diagram.composite.custom.ui.InformationItemValidator;
import org.eclipse.papyrus.uml.diagram.composite.custom.ui.NameLabelValidator;
import org.eclipse.papyrus.uml.diagram.composite.providers.ElementInitializers;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.InformationFlow;
import org.eclipse.uml2.uml.InformationItem;
import org.eclipse.uml2.uml.UMLFactory;

public class InformationFlowCreateCommand
extends org.eclipse.papyrus.uml.diagram.composite.edit.commands.InformationFlowCreateCommand {
    public InformationFlowCreateCommand(CreateRelationshipRequest request, EObject source, EObject target) {
        super(request, source, target);
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        Shell currentShell = new Shell(Display.getCurrent(), 67680);
        InformationItemElementTreeSelectionDialog dialog = new InformationItemElementTreeSelectionDialog(currentShell, (ILabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory), (ITreeContentProvider)new AdapterFactoryContentProvider((AdapterFactory)adapterFactory));
        dialog.setTitle(Messages.InformationFlowSelectionDialog_Title);
        dialog.setMessage(Messages.InformationFlowSelectionDialog_Message);
        dialog.setAllowMultiple(true);
        dialog.setHelpAvailable(false);
        dialog.setInput(this.getSource().getModel());
        dialog.setValidator(new InformationItemValidator());
        ArrayList<InformationItem> initialSelection = new ArrayList<InformationItem>();
        while (dialog.open() != 1) {
            if (dialog.getReturnCode() == 0) {
                Object[] conveyedClassified = dialog.getResult();
                InformationFlow newInformationFlow = UMLFactory.eINSTANCE.createInformationFlow();
                this.getContainer().getPackagedElements().add((Object)newInformationFlow);
                newInformationFlow.getInformationSources().add((Object)this.getSource());
                newInformationFlow.getInformationTargets().add((Object)this.getTarget());
                int i = 0;
                while (i < conveyedClassified.length) {
                    newInformationFlow.getConveyeds().add((Object)((Classifier)conveyedClassified[i]));
                    ++i;
                }
                ElementInitializers.getInstance().init_InformationFlow_4021(newInformationFlow);
                ((CreateElementRequest)this.getRequest()).setNewElement((EObject)newInformationFlow);
                return CommandResult.newOKCommandResult((Object)newInformationFlow);
            }
            if (dialog.getReturnCode() != 1025) continue;
            initialSelection.add(this.createNewInformationItem());
            dialog.setInitialElementSelections(initialSelection);
        }
        return CommandResult.newCancelledCommandResult();
    }

    private InformationItem createNewInformationItem() {
        InformationItem infoItem = UMLFactory.eINSTANCE.createInformationItem();
        this.getContainer().getPackagedElements().add((Object)infoItem);
        ElementInitializers.getInstance().init_InformationItem_2080(infoItem);
        Shell currentShell = new Shell(Display.getCurrent(), 67680);
        String languagePreferred = Activator.getDefault().getPreferenceStore().getString("papyrus.directeditor." + infoItem.eClass().getInstanceClassName());
        IDirectEditorConfiguration configuration = DirectEditorsUtil.findEditorConfiguration((String)languagePreferred, (String)infoItem.eClass().getInstanceClassName());
        configuration.preEditAction((Object)infoItem);
        configuration.setInputValidator((IInputValidator)new NameLabelValidator(Messages.InformationItemGetNameDialog_Error_Message));
        ExtendedDirectEditionDialog dialog = new ExtendedDirectEditionDialog(currentShell, (Object)infoItem, infoItem.getName(), configuration);
        dialog.open();
        if (dialog.getReturnCode() == 1) {
            int index = this.getContainer().getPackagedElements().indexOf((Object)infoItem);
            this.getContainer().getPackagedElements().remove(index);
            return null;
        }
        infoItem.setName(dialog.getValue());
        ((CreateElementRequest)this.getRequest()).setNewElement((EObject)infoItem);
        return infoItem;
    }
}

