/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.composite.custom.preferences;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.papyrus.infra.gmfdiag.preferences.pages.AbstractPapyrusElementPreferencePage;
import org.eclipse.papyrus.infra.gmfdiag.preferences.utils.GradientPreferenceConverter;
import org.eclipse.papyrus.infra.gmfdiag.preferences.utils.PreferenceConstantHelper;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class ParameterPreferencePage
extends AbstractPapyrusElementPreferencePage {
    public static final String ID = "org.eclipse.papyrus.uml.diagram.composite.custom.preferences.ParameterPreferencePage";
    protected Button displVisibility;
    protected Button displDirection;
    protected Button displName;
    protected Button displType;
    protected Button displMutliplicity;
    protected Button displDefault;
    protected Button displModifiers;
    private int parameterValue = this.getPreferenceStore().getInt("Parameter.label.display");

    public static void initDefaults(IPreferenceStore store) {
        String elementName = "Parameter";
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)PreferenceConstantHelper.getElementConstant((String)elementName, (int)0), (RGB)new RGB(255, 255, 255));
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)PreferenceConstantHelper.getElementConstant((String)elementName, (int)3), (RGB)new RGB(177, 207, 229));
        store.setDefault(PreferenceConstantHelper.getElementConstant((String)elementName, (int)5), false);
        GradientPreferenceConverter gradientPreferenceConverter = new GradientPreferenceConverter(new RGB(255, 255, 255), new RGB(177, 207, 229), 0, 0);
        store.setDefault(PreferenceConstantHelper.getElementConstant((String)elementName, (int)4), gradientPreferenceConverter.getPreferenceValue());
        store.setDefault("Property.label.display", 6400);
    }

    protected Button createCheckButton(Composite parent, String label, int mask) {
        Button button = new Button(parent, 32);
        button.setText(label);
        button.addSelectionListener((SelectionListener)new AppearenceSelectionListener(mask));
        return button;
    }

    protected void createLabelPreferencesButtons(Composite parent) {
        Group group = new Group(parent, 32);
        group.setText("Label Display");
        group.setLayout((Layout)new FormLayout());
        this.displVisibility = this.createCheckButton((Composite)group, "Visibility", 2);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 0);
        this.displVisibility.setLayoutData((Object)data);
        this.displDirection = this.createCheckButton((Composite)group, "Direction", 2048);
        data = new FormData();
        data.left = new FormAttachment((Control)this.displVisibility, 85);
        data.top = new FormAttachment(0, 0);
        this.displDirection.setLayoutData((Object)data);
        this.displName = this.createCheckButton((Composite)group, "Name", 4096);
        data = new FormData();
        data.left = new FormAttachment((Control)this.displDirection, 85);
        data.top = new FormAttachment(0, 0);
        this.displName.setLayoutData((Object)data);
        this.displType = this.createCheckButton((Composite)group, "Type", 256);
        data = new FormData();
        data.left = new FormAttachment((Control)this.displName, 85);
        data.top = new FormAttachment(0, 0);
        this.displType.setLayoutData((Object)data);
        this.displMutliplicity = this.createCheckButton((Composite)group, "Multiplicity", 16384);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment((Control)this.displVisibility, 5);
        this.displMutliplicity.setLayoutData((Object)data);
        this.displDefault = this.createCheckButton((Composite)group, "Default Value", 32768);
        data = new FormData();
        data.left = new FormAttachment((Control)this.displVisibility, 85);
        data.top = new FormAttachment((Control)this.displVisibility, 5);
        this.displDefault.setLayoutData((Object)data);
        this.displModifiers = this.createCheckButton((Composite)group, "Modifiers", 65536);
        data = new FormData();
        data.left = new FormAttachment((Control)this.displDirection, 85);
        data.top = new FormAttachment((Control)this.displVisibility, 5);
        this.displModifiers.setLayoutData((Object)data);
    }

    protected void createPageContents(Composite parent) {
        super.createPageContents(parent);
        this.createLabelPreferencesButtons(parent);
        this.refreshButtons();
    }

    protected String getBundleId() {
        return "org.eclipse.papyrus.uml.diagram.composite";
    }

    protected void loadDefaultPreferences() {
        this.parameterValue = this.getPreferenceStore().getInt("Parameter.label.display");
        this.refreshButtons();
    }

    protected void performDefaults() {
        this.loadDefaultPreferences();
        super.performDefaults();
    }

    public boolean performOk() {
        this.storePreferences();
        return super.performOk();
    }

    protected void refreshButtons() {
        this.displVisibility.setSelection((this.parameterValue & 2) == 2);
        this.displDirection.setSelection((this.parameterValue & 0x800) == 2048);
        this.displName.setSelection((this.parameterValue & 0x1000) == 4096);
        this.displType.setSelection((this.parameterValue & 0x100) == 256);
        this.displMutliplicity.setSelection((this.parameterValue & 0x4000) == 16384);
        this.displDefault.setSelection((this.parameterValue & 0x8000) == 32768);
        this.displModifiers.setSelection((this.parameterValue & 0x10000) == 65536);
    }

    protected void storePreferences() {
        IPreferenceStore store = this.getPreferenceStore();
        if (this.parameterValue != store.getInt("Parameter.label.display")) {
            store.setValue("Parameter.label.display", this.parameterValue);
        }
    }

    private class AppearenceSelectionListener
    implements SelectionListener {
        private final int style;

        public AppearenceSelectionListener(int style) {
            this.style = style;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            ParameterPreferencePage parameterPreferencePage = ParameterPreferencePage.this;
            parameterPreferencePage.parameterValue = parameterPreferencePage.parameterValue ^ this.style;
            ParameterPreferencePage.this.refreshButtons();
        }
    }
}

