/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.deployment.part;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.providers.BaseViewInfo;
import org.eclipse.papyrus.uml.diagram.common.providers.ViewInfo;
import org.eclipse.papyrus.uml.diagram.deployment.part.UMLDiagramEditorPlugin;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLPackage;

public class UMLVisualIDRegistry {
    private static final String DEBUG_KEY = "org.eclipse.papyrus.uml.diagram.deployment/debug/visualID";
    private static ViewInfo diagramViewInfo = null;

    public static int getVisualID(View view) {
        if (view instanceof Diagram) {
            if ("PapyrusUMLDeploymentDiagram".equals(view.getType())) {
                return 1000;
            }
            return -1;
        }
        return UMLVisualIDRegistry.getVisualID(view.getType());
    }

    public static String getModelID(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return (String)annotation.getDetails().get((Object)"modelID");
            }
            view = (View)view.eContainer();
        }
        return diagram != null ? diagram.getType() : null;
    }

    public static int getVisualID(String type) {
        try {
            return Integer.parseInt(type);
        }
        catch (NumberFormatException e) {
            if (Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)DEBUG_KEY))) {
                UMLDiagramEditorPlugin.getInstance().logError("Unable to parse view type as a visualID number: " + type);
            }
            return -1;
        }
    }

    public static String getType(int visualID) {
        return Integer.toString(visualID);
    }

    public static int getDiagramVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDiagram((Package)domainElement)) {
            return 1000;
        }
        return -1;
    }

    public static int getNodeVisualID(View containerView, EObject domainElement) {
        int containerVisualID;
        if (domainElement == null) {
            return -1;
        }
        String containerModelID = UMLVisualIDRegistry.getModelID(containerView);
        if (!"PapyrusUMLDeploymentDiagram".equals(containerModelID)) {
            return -1;
        }
        if ("PapyrusUMLDeploymentDiagram".equals(containerModelID)) {
            containerVisualID = UMLVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return -1;
        }
        switch (containerVisualID) {
            case 1000: {
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 2001;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 2005;
                }
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 2002;
                }
                if (UMLPackage.eINSTANCE.getDevice().isSuperTypeOf(domainElement.eClass())) {
                    return 2003;
                }
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) {
                    return 2006;
                }
                if (!UMLPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass())) break;
                return 2008;
            }
            case 17: {
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 21;
                }
                if (UMLPackage.eINSTANCE.getDevice().isSuperTypeOf(domainElement.eClass())) {
                    return 16;
                }
                if (!UMLPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass())) break;
                return 23;
            }
            case 18: {
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 21;
                }
                if (!UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) break;
                return 25;
            }
            case 19: {
                if (UMLPackage.eINSTANCE.getDevice().isSuperTypeOf(domainElement.eClass())) {
                    return 16;
                }
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 21;
                }
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) {
                    return 25;
                }
                if (!UMLPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass())) break;
                return 23;
            }
            case 26: {
                if (!UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) break;
                return 28;
            }
            case 30: {
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 21;
                }
                if (UMLPackage.eINSTANCE.getDevice().isSuperTypeOf(domainElement.eClass())) {
                    return 16;
                }
                if (!UMLPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass())) break;
                return 23;
            }
            case 31: {
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) {
                    return 25;
                }
                if (!UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) break;
                return 21;
            }
            case 32: {
                if (UMLPackage.eINSTANCE.getDevice().isSuperTypeOf(domainElement.eClass())) {
                    return 16;
                }
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 21;
                }
                if (UMLPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass())) {
                    return 23;
                }
                if (!UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) break;
                return 25;
            }
            case 33: {
                if (!UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) break;
                return 28;
            }
            case 34: {
                if (!UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) break;
                return 28;
            }
        }
        return -1;
    }

    public static boolean canCreateNode(View containerView, int nodeVisualID) {
        int containerVisualID;
        String containerModelID = UMLVisualIDRegistry.getModelID(containerView);
        if (!"PapyrusUMLDeploymentDiagram".equals(containerModelID)) {
            return false;
        }
        if ("PapyrusUMLDeploymentDiagram".equals(containerModelID)) {
            containerVisualID = UMLVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return false;
        }
        switch (containerVisualID) {
            case 1000: {
                if (2001 == nodeVisualID) {
                    return true;
                }
                if (2005 == nodeVisualID) {
                    return true;
                }
                if (2002 == nodeVisualID) {
                    return true;
                }
                if (2003 == nodeVisualID) {
                    return true;
                }
                if (2006 == nodeVisualID) {
                    return true;
                }
                if (2008 != nodeVisualID) break;
                return true;
            }
            case 2001: {
                if (1 != nodeVisualID) break;
                return true;
            }
            case 2005: {
                if (2 == nodeVisualID) {
                    return true;
                }
                if (3 != nodeVisualID) break;
                return true;
            }
            case 2002: {
                if (5 == nodeVisualID) {
                    return true;
                }
                if (18 != nodeVisualID) break;
                return true;
            }
            case 2003: {
                if (6 == nodeVisualID) {
                    return true;
                }
                if (17 != nodeVisualID) break;
                return true;
            }
            case 2006: {
                if (8 == nodeVisualID) {
                    return true;
                }
                if (26 != nodeVisualID) break;
                return true;
            }
            case 2008: {
                if (9 == nodeVisualID) {
                    return true;
                }
                if (19 != nodeVisualID) break;
                return true;
            }
            case 23: {
                if (24 == nodeVisualID) {
                    return true;
                }
                if (32 != nodeVisualID) break;
                return true;
            }
            case 16: {
                if (20 == nodeVisualID) {
                    return true;
                }
                if (30 != nodeVisualID) break;
                return true;
            }
            case 21: {
                if (22 == nodeVisualID) {
                    return true;
                }
                if (31 != nodeVisualID) break;
                return true;
            }
            case 25: {
                if (27 == nodeVisualID) {
                    return true;
                }
                if (33 != nodeVisualID) break;
                return true;
            }
            case 28: {
                if (29 == nodeVisualID) {
                    return true;
                }
                if (34 != nodeVisualID) break;
                return true;
            }
            case 17: {
                if (21 == nodeVisualID) {
                    return true;
                }
                if (16 == nodeVisualID) {
                    return true;
                }
                if (23 != nodeVisualID) break;
                return true;
            }
            case 18: {
                if (21 == nodeVisualID) {
                    return true;
                }
                if (25 != nodeVisualID) break;
                return true;
            }
            case 19: {
                if (16 == nodeVisualID) {
                    return true;
                }
                if (21 == nodeVisualID) {
                    return true;
                }
                if (25 == nodeVisualID) {
                    return true;
                }
                if (23 != nodeVisualID) break;
                return true;
            }
            case 26: {
                if (28 != nodeVisualID) break;
                return true;
            }
            case 30: {
                if (21 == nodeVisualID) {
                    return true;
                }
                if (16 == nodeVisualID) {
                    return true;
                }
                if (23 != nodeVisualID) break;
                return true;
            }
            case 31: {
                if (25 == nodeVisualID) {
                    return true;
                }
                if (21 != nodeVisualID) break;
                return true;
            }
            case 32: {
                if (16 == nodeVisualID) {
                    return true;
                }
                if (21 == nodeVisualID) {
                    return true;
                }
                if (23 == nodeVisualID) {
                    return true;
                }
                if (25 != nodeVisualID) break;
                return true;
            }
            case 33: {
                if (28 != nodeVisualID) break;
                return true;
            }
            case 34: {
                if (28 != nodeVisualID) break;
                return true;
            }
            case 4001: {
                if (13 == nodeVisualID) {
                    return true;
                }
                if (14 != nodeVisualID) break;
                return true;
            }
            case 4002: {
                if (10 == nodeVisualID) {
                    return true;
                }
                if (11 != nodeVisualID) break;
                return true;
            }
            case 4003: {
                if (4 != nodeVisualID) break;
                return true;
            }
            case 4004: {
                if (12 == nodeVisualID) {
                    return true;
                }
                if (15 != nodeVisualID) break;
                return true;
            }
        }
        return false;
    }

    public static int getLinkWithClassVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (UMLPackage.eINSTANCE.getDeployment().isSuperTypeOf(domainElement.eClass())) {
            return 4001;
        }
        if (UMLPackage.eINSTANCE.getManifestation().isSuperTypeOf(domainElement.eClass())) {
            return 4002;
        }
        if (UMLPackage.eINSTANCE.getGeneralization().isSuperTypeOf(domainElement.eClass())) {
            return 4003;
        }
        if (UMLPackage.eINSTANCE.getDependency().isSuperTypeOf(domainElement.eClass())) {
            return 4004;
        }
        return -1;
    }

    private static boolean isDiagram(Package element) {
        return true;
    }

    public static ViewInfo getDiagramViewInfo() {
        if (diagramViewInfo == null) {
            diagramViewInfo = UMLVisualIDRegistry.getPackage_1000ViewInfo();
        }
        return diagramViewInfo;
    }

    protected static ViewInfo getPackage_1000ViewInfo() {
        BaseViewInfo root = new BaseViewInfo(1000, 0, "", null, null);
        BaseViewInfo viewInfo = null;
        BaseViewInfo labelInfo = null;
        viewInfo = new BaseViewInfo(2001, 2, "Comment");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(2005, 2, "Constraint");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(2002, 2, "ExecutionEnvironment");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(2003, 2, "Device");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(2006, 2, "Artifact");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(2008, 2, "Node");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(4005, 3, "");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(4008, 3, "");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(4009, 3, "");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(4001, 3, "");
        root.addNode(1000, (ViewInfo)viewInfo);
        labelInfo = new BaseViewInfo(13, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        labelInfo = new BaseViewInfo(14, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        viewInfo = new BaseViewInfo(4002, 3, "");
        root.addNode(1000, (ViewInfo)viewInfo);
        labelInfo = new BaseViewInfo(10, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        labelInfo = new BaseViewInfo(11, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        viewInfo = new BaseViewInfo(4003, 3, "");
        root.addNode(1000, (ViewInfo)viewInfo);
        labelInfo = new BaseViewInfo(4, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        viewInfo = new BaseViewInfo(4004, 3, "");
        root.addNode(1000, (ViewInfo)viewInfo);
        labelInfo = new BaseViewInfo(12, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        labelInfo = new BaseViewInfo(15, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        viewInfo = new BaseViewInfo(23, 2, "Node");
        root.addNode(19, (ViewInfo)viewInfo);
        root.addNode(32, (ViewInfo)viewInfo);
        root.addNode(17, (ViewInfo)viewInfo);
        root.addNode(30, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(16, 2, "Device");
        root.addNode(19, (ViewInfo)viewInfo);
        root.addNode(32, (ViewInfo)viewInfo);
        root.addNode(17, (ViewInfo)viewInfo);
        root.addNode(30, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(21, 2, "ExecutionEnvironment");
        root.addNode(19, (ViewInfo)viewInfo);
        root.addNode(17, (ViewInfo)viewInfo);
        root.addNode(18, (ViewInfo)viewInfo);
        root.addNode(30, (ViewInfo)viewInfo);
        root.addNode(31, (ViewInfo)viewInfo);
        root.addNode(32, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(25, 2, "Artifact");
        root.addNode(18, (ViewInfo)viewInfo);
        root.addNode(19, (ViewInfo)viewInfo);
        root.addNode(31, (ViewInfo)viewInfo);
        root.addNode(32, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(28, 2, "Artifact");
        root.addNode(26, (ViewInfo)viewInfo);
        root.addNode(33, (ViewInfo)viewInfo);
        root.addNode(34, (ViewInfo)viewInfo);
        return root;
    }
}

