/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.deployment.providers;

import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.papyrus.uml.diagram.deployment.part.UMLDiagramEditorPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.UMLPackage;

public class UMLElementTypes {
    private static Map<IElementType, ENamedElement> elements;
    private static ImageRegistry imageRegistry;
    private static Set<IElementType> KNOWN_ELEMENT_TYPES;
    public static final IElementType Package_1000;
    public static final IElementType Comment_2001;
    public static final IElementType Constraint_2005;
    public static final IElementType ExecutionEnvironment_2002;
    public static final IElementType Device_2003;
    public static final IElementType Artifact_2006;
    public static final IElementType Node_2008;
    public static final IElementType Node_23;
    public static final IElementType Device_16;
    public static final IElementType ExecutionEnvironment_21;
    public static final IElementType Artifact_25;
    public static final IElementType Artifact_28;
    public static final IElementType Link_4005;
    public static final IElementType CommentAnnotatedElement_4008;
    public static final IElementType ConstraintConstrainedElement_4009;
    public static final IElementType Deployment_4001;
    public static final IElementType Manifestation_4002;
    public static final IElementType Generalization_4003;
    public static final IElementType Dependency_4004;

    static {
        Package_1000 = UMLElementTypes.getElementType("org.eclipse.papyrus.uml.diagram.deployment.Package_1000");
        Comment_2001 = UMLElementTypes.getElementType("org.eclipse.papyrus.uml.diagram.deployment.Comment_2001");
        Constraint_2005 = UMLElementTypes.getElementType("org.eclipse.papyrus.uml.diagram.deployment.Constraint_2005");
        ExecutionEnvironment_2002 = UMLElementTypes.getElementType("org.eclipse.papyrus.uml.diagram.deployment.ExecutionEnvironment_2002");
        Device_2003 = UMLElementTypes.getElementType("org.eclipse.papyrus.uml.diagram.deployment.Device_2003");
        Artifact_2006 = UMLElementTypes.getElementType("org.eclipse.papyrus.uml.diagram.deployment.Artifact_2006");
        Node_2008 = UMLElementTypes.getElementType("org.eclipse.papyrus.uml.diagram.deployment.Node_2008");
        Node_23 = UMLElementTypes.getElementType("org.eclipse.papyrus.uml.diagram.deployment.Node_23");
        Device_16 = UMLElementTypes.getElementType("org.eclipse.papyrus.uml.diagram.deployment.Device_16");
        ExecutionEnvironment_21 = UMLElementTypes.getElementType("org.eclipse.papyrus.uml.diagram.deployment.ExecutionEnvironment_21");
        Artifact_25 = UMLElementTypes.getElementType("org.eclipse.papyrus.uml.diagram.deployment.Artifact_25");
        Artifact_28 = UMLElementTypes.getElementType("org.eclipse.papyrus.uml.diagram.deployment.Artifact_28");
        Link_4005 = UMLElementTypes.getElementType("org.eclipse.papyrus.uml.diagram.deployment.Link_4005");
        CommentAnnotatedElement_4008 = UMLElementTypes.getElementType("org.eclipse.papyrus.uml.diagram.deployment.CommentAnnotatedElement_4006");
        ConstraintConstrainedElement_4009 = UMLElementTypes.getElementType("org.eclipse.papyrus.uml.diagram.deployment.ConstraintConstrainedElement_4007");
        Deployment_4001 = UMLElementTypes.getElementType("org.eclipse.papyrus.uml.diagram.deployment.Deployment_4001");
        Manifestation_4002 = UMLElementTypes.getElementType("org.eclipse.papyrus.uml.diagram.deployment.Manifestation_4002");
        Generalization_4003 = UMLElementTypes.getElementType("org.eclipse.papyrus.uml.diagram.deployment.Generalization_4003");
        Dependency_4004 = UMLElementTypes.getElementType("org.eclipse.papyrus.uml.diagram.deployment.Dependency_4004");
    }

    private UMLElementTypes() {
    }

    private static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            imageRegistry = new ImageRegistry();
        }
        return imageRegistry;
    }

    private static String getImageRegistryKey(ENamedElement element) {
        return element.getName();
    }

    private static ImageDescriptor getProvidedImageDescriptor(ENamedElement element) {
        EClass eClass;
        if (element instanceof EStructuralFeature) {
            EStructuralFeature feature = (EStructuralFeature)element;
            EClass eContainingClass = feature.getEContainingClass();
            EClassifier eType = feature.getEType();
            if (eContainingClass != null && !eContainingClass.isAbstract()) {
                element = eContainingClass;
            } else if (eType instanceof EClass && !((EClass)eType).isAbstract()) {
                element = eType;
            }
        }
        if (element instanceof EClass && !(eClass = (EClass)element).isAbstract()) {
            return UMLDiagramEditorPlugin.getInstance().getItemImageDescriptor(eClass.getEPackage().getEFactoryInstance().create(eClass));
        }
        return null;
    }

    public static ImageDescriptor getImageDescriptor(ENamedElement element) {
        String key = UMLElementTypes.getImageRegistryKey(element);
        ImageDescriptor imageDescriptor = UMLElementTypes.getImageRegistry().getDescriptor(key);
        if (imageDescriptor == null) {
            imageDescriptor = UMLElementTypes.getProvidedImageDescriptor(element);
            if (imageDescriptor == null) {
                imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
            }
            UMLElementTypes.getImageRegistry().put(key, imageDescriptor);
        }
        return imageDescriptor;
    }

    public static Image getImage(ENamedElement element) {
        String key = UMLElementTypes.getImageRegistryKey(element);
        Image image = UMLElementTypes.getImageRegistry().get(key);
        if (image == null) {
            ImageDescriptor imageDescriptor = UMLElementTypes.getProvidedImageDescriptor(element);
            if (imageDescriptor == null) {
                imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
            }
            UMLElementTypes.getImageRegistry().put(key, imageDescriptor);
            image = UMLElementTypes.getImageRegistry().get(key);
        }
        return image;
    }

    public static ImageDescriptor getImageDescriptor(IAdaptable hint) {
        ENamedElement element = UMLElementTypes.getElement(hint);
        if (element == null) {
            return null;
        }
        return UMLElementTypes.getImageDescriptor(element);
    }

    public static Image getImage(IAdaptable hint) {
        ENamedElement element = UMLElementTypes.getElement(hint);
        if (element == null) {
            return null;
        }
        return UMLElementTypes.getImage(element);
    }

    public static ENamedElement getElement(IAdaptable hint) {
        Object type = hint.getAdapter(IElementType.class);
        if (elements == null) {
            elements = new IdentityHashMap<IElementType, ENamedElement>();
            elements.put(Package_1000, (ENamedElement)UMLPackage.eINSTANCE.getPackage());
            elements.put(Comment_2001, (ENamedElement)UMLPackage.eINSTANCE.getComment());
            elements.put(Constraint_2005, (ENamedElement)UMLPackage.eINSTANCE.getConstraint());
            elements.put(ExecutionEnvironment_2002, (ENamedElement)UMLPackage.eINSTANCE.getExecutionEnvironment());
            elements.put(Device_2003, (ENamedElement)UMLPackage.eINSTANCE.getDevice());
            elements.put(Artifact_2006, (ENamedElement)UMLPackage.eINSTANCE.getArtifact());
            elements.put(Node_2008, (ENamedElement)UMLPackage.eINSTANCE.getNode());
            elements.put(Node_23, (ENamedElement)UMLPackage.eINSTANCE.getNode());
            elements.put(Device_16, (ENamedElement)UMLPackage.eINSTANCE.getDevice());
            elements.put(ExecutionEnvironment_21, (ENamedElement)UMLPackage.eINSTANCE.getExecutionEnvironment());
            elements.put(Artifact_25, (ENamedElement)UMLPackage.eINSTANCE.getArtifact());
            elements.put(Artifact_28, (ENamedElement)UMLPackage.eINSTANCE.getArtifact());
            elements.put(CommentAnnotatedElement_4008, (ENamedElement)UMLPackage.eINSTANCE.getComment_AnnotatedElement());
            elements.put(ConstraintConstrainedElement_4009, (ENamedElement)UMLPackage.eINSTANCE.getConstraint_ConstrainedElement());
            elements.put(Deployment_4001, (ENamedElement)UMLPackage.eINSTANCE.getDeployment());
            elements.put(Manifestation_4002, (ENamedElement)UMLPackage.eINSTANCE.getManifestation());
            elements.put(Generalization_4003, (ENamedElement)UMLPackage.eINSTANCE.getGeneralization());
            elements.put(Dependency_4004, (ENamedElement)UMLPackage.eINSTANCE.getDependency());
        }
        return elements.get(type);
    }

    private static IElementType getElementType(String id) {
        return ElementTypeRegistry.getInstance().getType(id);
    }

    public static boolean isKnownElementType(IElementType elementType) {
        if (KNOWN_ELEMENT_TYPES == null) {
            KNOWN_ELEMENT_TYPES = new HashSet<IElementType>();
            KNOWN_ELEMENT_TYPES.add(Package_1000);
            KNOWN_ELEMENT_TYPES.add(Comment_2001);
            KNOWN_ELEMENT_TYPES.add(Constraint_2005);
            KNOWN_ELEMENT_TYPES.add(ExecutionEnvironment_2002);
            KNOWN_ELEMENT_TYPES.add(Device_2003);
            KNOWN_ELEMENT_TYPES.add(Artifact_2006);
            KNOWN_ELEMENT_TYPES.add(Node_2008);
            KNOWN_ELEMENT_TYPES.add(Node_23);
            KNOWN_ELEMENT_TYPES.add(Device_16);
            KNOWN_ELEMENT_TYPES.add(ExecutionEnvironment_21);
            KNOWN_ELEMENT_TYPES.add(Artifact_25);
            KNOWN_ELEMENT_TYPES.add(Artifact_28);
            KNOWN_ELEMENT_TYPES.add(Link_4005);
            KNOWN_ELEMENT_TYPES.add(CommentAnnotatedElement_4008);
            KNOWN_ELEMENT_TYPES.add(ConstraintConstrainedElement_4009);
            KNOWN_ELEMENT_TYPES.add(Deployment_4001);
            KNOWN_ELEMENT_TYPES.add(Manifestation_4002);
            KNOWN_ELEMENT_TYPES.add(Generalization_4003);
            KNOWN_ELEMENT_TYPES.add(Dependency_4004);
        }
        return KNOWN_ELEMENT_TYPES.contains(elementType);
    }

    public static IElementType getElementType(int visualID) {
        switch (visualID) {
            case 1000: {
                return Package_1000;
            }
            case 2001: {
                return Comment_2001;
            }
            case 2005: {
                return Constraint_2005;
            }
            case 2002: {
                return ExecutionEnvironment_2002;
            }
            case 2003: {
                return Device_2003;
            }
            case 2006: {
                return Artifact_2006;
            }
            case 2008: {
                return Node_2008;
            }
            case 23: {
                return Node_23;
            }
            case 16: {
                return Device_16;
            }
            case 21: {
                return ExecutionEnvironment_21;
            }
            case 25: {
                return Artifact_25;
            }
            case 28: {
                return Artifact_28;
            }
            case 4005: {
                return Link_4005;
            }
            case 4008: {
                return CommentAnnotatedElement_4008;
            }
            case 4009: {
                return ConstraintConstrainedElement_4009;
            }
            case 4001: {
                return Deployment_4001;
            }
            case 4002: {
                return Manifestation_4002;
            }
            case 4003: {
                return Generalization_4003;
            }
            case 4004: {
                return Dependency_4004;
            }
        }
        return null;
    }
}

