/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.dnd.strategy.instancespecification.ui;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassifierPropertiesContentProvider
implements ITreeContentProvider {
    private Viewer viewer;
    private Collection<Classifier> input;

    public void dispose() {
        this.viewer = null;
        this.input = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = viewer;
        this.input = (Collection)newInput;
    }

    public Object[] getElements(Object inputElement) {
        LinkedHashSet<Classifier> result = new LinkedHashSet<Classifier>();
        for (Classifier classifier : this.input) {
            this.getAllGenerals(classifier, result);
        }
        return result.toArray();
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof Classifier) {
            Classifier element = (Classifier)parentElement;
            return element.getAttributes().toArray();
        }
        return new Object[0];
    }

    protected boolean isCloserClassifier(Classifier current, Classifier classifier) {
        if (current == classifier || this.input.size() == 1) {
            return true;
        }
        return !this.input.contains(classifier);
    }

    protected void getAllGenerals(Classifier classifier, Collection<Classifier> result) {
        if (result.contains(classifier)) {
            return;
        }
        for (Classifier general : classifier.getGenerals()) {
            this.getAllGenerals(general, result);
        }
        result.add(classifier);
    }

    public Object getParent(Object element) {
        if (element instanceof Property) {
            return ((Property)element).getOwner();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof Classifier) {
            return !((Classifier)element).getAllAttributes().isEmpty();
        }
        return false;
    }
}

