/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.menu.dialogs;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.services.editpart.EditPartService;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.papyrus.uml.diagram.common.dialogs.AbstractCheckedTreeColumnViewerSelectionDialog;
import org.eclipse.papyrus.uml.diagram.common.editparts.ILabelRoleProvider;
import org.eclipse.papyrus.uml.diagram.common.util.DiagramEditPartsUtil;
import org.eclipse.papyrus.uml.diagram.menu.Activator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

public class ShowHideLabelSelectionDialog
extends AbstractCheckedTreeColumnViewerSelectionDialog {
    private DiagramEditPart diagramEP = null;

    public ShowHideLabelSelectionDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
        super(parent, labelProvider, contentProvider, 0x1010800, 2);
        this.init();
    }

    protected void init() {
        this.setColumnTitles(new String[]{"Label Role", "Displayed Text"});
        this.setColumnWidths(new int[]{300, 300});
        this.setColumnCellLabelProvider(new CellLabelProvider[]{new RoleLabelProvider(), new TextLabelProvider()});
    }

    public void setInput(Object input) {
        Object obj;
        super.setInput(input);
        if (input instanceof List && !((List)input).isEmpty() && (obj = ((List)input).get(0)) instanceof EditPart) {
            this.diagramEP = DiagramEditPartsUtil.getDiagramEditPart((EditPart)((EditPart)obj));
        }
        Assert.isNotNull((Object)this.diagramEP);
    }

    protected EditingSupport getEditingSupport(int columnIndex) {
        return null;
    }

    public class RoleLabelProvider
    extends CellLabelProvider
    implements ILabelProvider {
        public Image getImage(Object element) {
            if (element instanceof View) {
                IGraphicalEditPart dummyEP = EditPartService.getInstance().createGraphicEditPart((View)element);
                String iconPath = "";
                if (dummyEP instanceof ILabelRoleProvider && (iconPath = ((ILabelRoleProvider)dummyEP).getIconPathRole()) != null && iconPath.indexOf("platform") == 0) {
                    try {
                        return ImageDescriptor.createFromURL((URL)new URL(iconPath)).createImage();
                    }
                    catch (MalformedURLException e) {
                        Activator.log.error("I can't find the following image " + iconPath, (Throwable)e);
                        return null;
                    }
                }
            }
            return null;
        }

        public String getText(Object element) {
            IGraphicalEditPart dummyEP;
            if (element instanceof View && (dummyEP = EditPartService.getInstance().createGraphicEditPart((View)element)) instanceof ILabelRoleProvider) {
                return ((ILabelRoleProvider)dummyEP).getLabelRole();
            }
            return "";
        }

        public void update(ViewerCell cell) {
            cell.setImage(this.getImage(cell.getElement()));
            cell.setText(this.getText(cell.getElement()));
        }
    }

    class TextLabelProvider
    extends CellLabelProvider
    implements ILabelProvider {
        TextLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            String str;
            IFigure figure;
            EditPart dummyEP = DiagramEditPartsUtil.getEditPartFromView((View)((View)element), (EditPart)ShowHideLabelSelectionDialog.this.diagramEP);
            String text = "[No Text To Display]";
            if (dummyEP instanceof GraphicalEditPart && (figure = ((GraphicalEditPart)dummyEP).getFigure()) instanceof WrappingLabel && (str = ((WrappingLabel)figure).getText()) != null && str.length() != 0) {
                text = str;
            }
            return text;
        }

        public void update(ViewerCell cell) {
            cell.setImage(this.getImage(cell.getElement()));
            cell.setText(this.getText(cell.getElement()));
        }
    }
}

